unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls,
  UUtils;

type
  TForm3 = class(TForm)
    sgSource: TStringGrid;
    Button1: TButton;
    sgResult: TStringGrid;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button2Click(Sender: TObject);
  private
    FMatrix: TMatrix;
    procedure Calculate;
  public
    procedure Init(matrix: TMatrix);
  end;

var
  Form3: TForm3;

implementation
{$R *.dfm}

procedure TForm3.Button1Click(Sender: TObject);
begin
  if (FMatrix.colCount <> FMatrix.rowCount + 1) then begin
    ShowMessage(
      '       - ');
    Exit;
  end;
  Calculate;
  GridInit(sgResult,FMatrix );
end;


procedure TForm3.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm3.Calculate;
var
  i: integer;

  procedure divideRow(ARow: integer; AVal: double);
  var
    k: integer;
  begin
    for k := 0 to FMatrix.colCount - 1 do
      FMatrix.matrix[ARow, k] := FMatrix.matrix[ARow, k] / AVal;
  end;

  procedure zeroColumn(ACol: integer);
  var
    k: integer;
    j: integer;
    ov: double;
  begin
    for k := 0 to FMatrix.rowCount - 1 do begin
      if k = ACol then
        Continue;
      ov := FMatrix.matrix[k, ACol];
      for j := 0 to FMatrix.colCount - 1 do
        FMatrix.matrix[k, j] :=
          FMatrix.matrix[k, j] - FMatrix.matrix[ACol, j] * ov;
    end;
  end;

begin
  for i := 0 to FMatrix.rowCount - 1 do begin
    divideRow(i, FMatrix.matrix[i, i]);
    zeroColumn(i);
  end;
end;

procedure TForm3.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Application.MainForm.Show;
end;

procedure TForm3.Init(matrix: TMatrix);
begin
  Show;
  FMatrix := matrix;
  sgSource.ColCount := FMatrix.colCount;
  sgSource.RowCount := FMatrix.rowCount;
  sgResult.ColCount := FMatrix.colCount;
  sgResult.RowCount := FMatrix.rowCount;
  GridInit(sgSource, FMatrix);
end;

end.






