unit Unit4;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids,
   UUtils;

type
  TForm4 = class(TForm)
    sgSource: TStringGrid;
    sgResult: TStringGrid;
    matr1: TStringGrid;
    matr2: TStringGrid;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Proverka: TStringGrid;
    Label2: TLabel;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button2Click(Sender: TObject);
  private
    tx,pr,mb,mc, FMatrix: TMatrix;
    procedure Calculate;
  public
    procedure Init(matrix: TMatrix);
  end;

var
  Form4: TForm4;

implementation
{$R *.dfm}
var {tx,mb,mc : TMatrix;}
    n:integer;

procedure TForm4.Button1Click(Sender: TObject);
begin
   if (FMatrix.colCount <> FMatrix.rowCount + 1) then begin
    ShowMessage(
      '       - ');
    Exit;
  end;
  Calculate;
  GridInit(sgResult, tx);
  GridInit(matr1, mb);
  GridInit(matr2, mc);
  GridInit(Proverka, pr);
end;

procedure TForm4.Button2Click(Sender: TObject);
begin
   Close;
end;

procedure TForm4.Calculate;
  var
    i,j,k: integer;
    s:real;
    a,b,c : array[1..16, 1..16] of real;
    ab,x,y: array[1..16] of REAL;
Begin
    n:= FMatrix.rowCount;
    for i:=1 to n do
     for j:=1 to n do
        a[i,j]:=FMatrix.matrix[i-1, j-1];
    for i:=1 to n do
      ab[i]:=FMatrix.matrix[i-1,n];
  for i:=1 to n do
    begin
      c[i,i]:=1;
      b[i,1]:=a[i,1];
      c[1,i]:=a[1,i]/b[1,1];
    end;
  y[1]:=ab[1]/b[1,1];

  for i:=2 to n do
   for j:=2 to i do
    begin
     b[i,j]:=a[i,j];
     for k:=1 to j-1 do
       b[i,j]:=b[i,j]-b[i,k]*c[k,j];
     s:=0;
     if j<i then
       begin
	 for k:=1 to j-1 do
	   s:=s+b[j,k]*c[k,i];
	 c[j,i]:=(a[j,i]-s)/b[j,j];
       end;
    end;

  mb.colCount := n;
  mb.rowCount := n;
  mc.colCount := n;
  mc.rowCount := n;
  for i:=1 to n do
    for j:=1 to n do
      begin
        mb.matrix[i-1,j-1]:=b[i,j];
        mc.matrix[i-1,j-1]:=c[i,j];
      end;
    mc.matrix[1,0]:=0;
    mc.matrix[2,0]:=0;

  for i:=2 to n do
    begin
      s:=0;
      for k:=1 to i-1 do
      	s:=s+b[i,k]*y[k];
      y[i]:=(ab[i]-s)/b[i,i];
    end;
   x[n]:=y[n];s:=0;
   for i:=n-1 downto 1 do
     begin
       s:=0;
       for k:=i+1 to n do
      	 s:=s+c[i,k]*x[k];
       x[i]:=y[i]-s;
     end;

  tx.colCount := n;
  tx.rowCount := 0;
     for i := 1 to n do
        tx.matrix[0,i-1] := x[i];

  pr.colCount := n;
  pr.rowCount := 0;
  for i:=1 to n do begin
   pr.matrix[0,i-1] := 0;
   for j:=1 to n do
     pr.matrix[0,i-1]:=pr.matrix[0,i-1]+a[i,j]*x[j]
  end;
End;


procedure TForm4.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Application.MainForm.Show;
end;

procedure TForm4.Init(matrix: TMatrix);
begin
  Show;
  FMatrix := matrix;
  matr1.ColCount:=n;
  matr1.RowCount:=n;
  matr2.ColCount:=n;
  matr2.RowCount:=n;
  sgSource.ColCount := FMatrix.colCount;
  sgSource.RowCount := FMatrix.rowCount;
  sgResult.ColCount := FMatrix.colCount;
  sgResult.RowCount := FMatrix.rowCount;
  GridInit(sgSource, FMatrix);
end;

end.
