unit Compiler;

{$O+,F+,S-}

interface

uses Objects, CompVars;

procedure InitCompiler(var Params: TInitParams; var Result: TInitResult);
procedure Compile(var Params: TCompParams; var Result: TCompResult);
procedure ResetCompiler;
function  StartProgram: Longint;
procedure StopProgram;
function  FindError(Address: Pointer): Longint;
function  GetSourceCount: Integer;
function  GetSourceName(N: Integer): PString;
procedure ChangeSourceName(N: Integer; Name: String);
function  FindSourceName(Name: String): Integer;
function  FindCode(Line: TSrcPoint; var Address: Pointer; var Len: Word):
  Integer;
function  FindSrcLine(Address: Pointer; var Copy: Pointer): Longint;
function  FindUnit(Segment: Word): Boolean;
function  FindStubSeg(Segment: Word): Word;
procedure InitDebugger;
function  Evaluate(Expr: string; var Result: string;
  var CanModify: Boolean): Longint;
function  Modify(Expr: string; var NewValue: string): Longint;
function  CheckCondition(Expr: string): Longint;
function  FindProc(Expr: string): Longint;
function  GetCallStackSize: Integer;
procedure GetCallStackEntry(N: Integer; var S: string);
function  GetCallStackPos(N: Integer): Longint;
procedure ScreenSwap;
procedure GetAsmSymbol(Name: string; var Symbol);
procedure GetAsmLabel(Name: string);
procedure EmitByte(Value: Byte);
procedure EmitFixup(Typ: Byte; Address, Value: Word);
procedure EmitJump(Opcode: Byte; Address: Word);
procedure EmitFloat(Opcode, Prefix: Byte; Fwait: Boolean);
procedure FileCreate;
procedure FileClose;
procedure FileWrite;
procedure WriteBig;
procedure GetFlatMem;
procedure GetProcStackSize;
procedure FlatMemAvail;
procedure Error;

implementation

uses Mem, TDos, TVars, VSwap, Debug, Extend, Basm, TdInfo, VFiles, CompWind;

{$L STDPROC}
{$L STDFUNC}
{$L STDUTILS}
{$L DEBUGGER}
{$L PUT}
{$L DECLARE}
{$L OPERS}
{$L CONVERT}
{$L CODEGEN}
{$L COMPILE}
{$L ERROR}
{$L ARITH}
{$L OBJECT}
{$L STMTPART}
{$L STMT}
{$L LEX}
{$L EXPR}
{$L CONVERT2}
{$L ASM}
{$L LINK}
{$L UNITS}
{$L CHEAP}
{$L TPSTART}

procedure ScreenSwap;
begin
  if ScreenSwapping <> swNone then
  begin
    SaveEms;
    SwapScreen(scUser, True);
    RestoreEms;
  end;
end;

procedure InitCompiler(var Params: TInitParams; var Result: TInitResult);
  external;
procedure Compile(var Params: TCompParams; var Result: TCompResult);
  external;
procedure ResetCompiler; external;
function  StartProgram: Longint; external;
procedure StopProgram; external;
function  FindError(Address: Pointer): Longint; external;
function  GetSourceCount: Integer; external;
function  GetSourceName(N: Integer): PString; external;
procedure ChangeSourceName(N: Integer; Name: String); external;
function  FindSourceName(Name: String): Integer; external;
function  FindCode(Line: TSrcPoint; var Address: Pointer; var Len: Word):
  Integer; external;
function  FindSrcLine(Address: Pointer; var Copy: Pointer): Longint; external;
function  FindUnit(Segment: Word): Boolean; external;
function  FindStubSeg(Segment: Word): Word; external;
procedure InitDebugger; external;
function  Evaluate(Expr: string; var Result: string;
  var CanModify: Boolean): Longint; external;
function  Modify(Expr: string; var NewValue: string): Longint; external;
function  CheckCondition(Expr: string): Longint; external;
function  FindProc(Expr: string): Longint; external;
function  GetCallStackSize: Integer; external;
procedure GetCallStackEntry(N: Integer; var S: string); external;
function  GetCallStackPos(N: Integer): Longint; external;
procedure GetAsmSymbol(Name: string; var Symbol); external;
procedure GetAsmLabel(Name: string); external;
procedure EmitByte(Value: Byte); external;
procedure EmitFixup(Typ: Byte; Address, Value: Word); external;
procedure EmitJump(Opcode: Byte; Address: Word); external;
procedure EmitFloat(Opcode, Prefix: Byte; Fwait: Boolean); external;
procedure FileCreate; external;
procedure FileClose; external;
procedure FileWrite; external;
procedure WriteBig; external;
procedure GetFlatMem; external;
procedure GetProcStackSize; external;
procedure FlatMemAvail; external;
procedure Error; external;

end.
