	model	large compiler_text,pascal
	include	compiler.inc

	.code	compiler_text

	public	GetMemOnBottom
	public	FreeMemOnBottom
	public	GetMemOnTop
	public	FreeMemOnTop
	public	MarkMem
	public	ReleaseMem
	public	GetMemAvail
	public	InitHeap
	public	GetDictMem
	public	GetStmtMem
	public	GetMemory
	public	SaveHeap
	public	RestoreHeap
	public	ReadFile

GetMemOnBottom	proc	near
	add	ax,15
	mov	cl,4
	shr	ax,cl
	mov	bx,CompMemPtr
	add	ax,bx
	cmp	ax,CompMemTop
	ja	NoMemory
	mov	CompMemPtr,ax
	ret
GetMemOnBottom	endp

FreeMemOnBottom	proc	near
	mov	CompMemPtr,bx
	ret
FreeMemOnBottom	endp

GetMemOnTop	proc	near
	add	ax,15
	mov	cl,4
	shr	ax,cl
	mov	bx,CompMemTop
	sub	bx,ax
	cmp	bx,CompMemPtr
	jb	NoMemory
	mov	CompMemTop,bx
	ret
GetMemOnTop	endp

FreeMemOnTop	proc	near
	add	ax,15
	mov	cl,4
	shr	ax,cl
	add	ax,bx
	mov	CompMemTop,ax
	ret
FreeMemOnTop	endp

MarkMem	proc	near
	mov	bx,CompMemPtr
	ret
MarkMem	endp

ReleaseMem	proc	near
	mov	CompMemPtr,bx
	ret
ReleaseMem	endp

NoMemory	proc	near
	mov	ax,1
	Chain	CompileError
NoMemory	endp

GetMemAvail	proc	near
	mov	ax,CompMemTop
	sub	ax,CompMemPtr
	mov	cl,4
	rol	ax,cl
	mov	dx,ax
	and	ax,0fff0h
	and	dx,0fh
	ret
GetMemAvail	endp

InitHeap	proc	near
	mov	FirstHeapRec,di
	mov	EndHeapRec,dx
	push	ds
	pop	es
@@1:	xor	ax,ax
	stosw
	mov	ax,CompMemPtr
	stosw
	xor	ax,ax
	stosw
	movsw
	cmp	di,dx
	jne	@@1
	ret
InitHeap	endp

GetDictMem	proc	near
	lea	bx,Dictionary
	jmp	short GetMemory
GetStmtMem	label	near
	lea	bx,StmtPart
GetMemory	label	near
	les	di,[bx].hrAddress
	add	ax,di
	jc	@@2
	mov	[bx].hrAddress.Offs,ax
	cmp	ax,[bx].hrLimit
	ja	@@3
	ret
@@2:	mov	ax,[bx].hrError
	Chain	CompileError
@@3:	cmp	ax,0fff0h
	ja	@@2
	push	cx dx si di es
	add	ax,15
	and	ax,0fff0h
	cmp	ExactAlloc,0
	jne	@@6
	mov	ax,200h
@@4:	cmp	ax,[bx].hrAddress.Offs
	ja	@@6
	shl	ax,1
	cmp	ax,2000h
	jb	@@4
@@5:	cmp	ax,[bx].hrAddress.Offs
	ja	@@6
	add	ax,2000h
	jae	@@5
	mov	ax,0fff0h
@@6:	sub	ax,[bx].hrLimit
	mov	cl,4
	shr	ax,cl
	mov	dx,CompMemTop
	sub	dx,CompMemPtr
	cmp	ax,dx
	jbe	@@7
	mov	ax,dx
	shl	ax,cl
	add	ax,[bx].hrLimit
	cmp	ax,[bx].hrAddress.Offs
	jb	@@10
	mov	ax,dx
@@7:	add	CompMemPtr,ax
	mov	dx,ax
	shl	dx,cl
	add	[bx].hrLimit,dx
	mov	dx,bx
	mov	bx,EndHeapRec
@@8:	sub	bx,size THeapRecord
	cmp	bx,dx
	je	@@9
	push	ds
	lds	cx,[bx].hrAddress
	mov	di,ds
	add	di,ax
	mov	es,di
	xor	si,si
	xor	di,di
	Invoke	MoveBlockRev
	pop	ds
	add	[bx].hrAddress.Segm,ax
	jmp	@@8
@@9:	pop	es di si dx cx
	ret
@@10:	mov	ax,1
	Chain	CompileError
GetDictMem	endp

SaveHeap	proc	near
	mov	bx,FirstHeapRec
	mov	ax,[bx].hrAddress.Segm
	mov	CompMemPtr,ax
	mov	bx,EndHeapRec
	mov	dx,CompMemTop
@@1:	sub	bx,size THeapRecord
	mov	ax,[bx].hrAddress.Offs
	add	ax,15
	and	ax,0fff0h
	mov	[bx].hrLimit,ax
	mov	cl,4
	shr	ax,cl
	sub	dx,ax
	push	ds
	lds	cx,[bx].hrAddress
	mov	es,dx
	xor	si,si
	xor	di,di
	Invoke	MoveBlockRev
	pop	ds
	mov	[bx].hrAddress.Segm,dx
	cmp	bx,FirstHeapRec
	jne	@@1
	mov	CompMemTop,dx
	ret
SaveHeap	endp

RestoreHeap	proc	near
	mov	bx,EndHeapRec
	mov	ax,[bx-size THeapRecord].hrLimit
	mov	cl,4
	shr	ax,cl
	add	ax,[bx-size THeapRecord].hrAddress.Segm
	mov	CompMemTop,ax
	mov	bx,FirstHeapRec
	mov	dx,CompMemPtr
@@1:	push	ds
	lds	cx,[bx].hrAddress
	mov	es,dx
	xor	si,si
	xor	di,di
	Invoke	MoveBlock
	pop	ds
	mov	[bx].hrAddress.Segm,dx
	mov	ax,[bx].hrAddress.Offs
	add	ax,15
	mov	cl,4
	shr	ax,cl
	add	dx,ax
	add	bx,8
	cmp	bx,EndHeapRec
	jne	@@1
	mov	CompMemPtr,dx
	ret
RestoreHeap	endp

ReadFile	proc	near
	mov	es,CompMemPtr
@@1:	mov	ax,CompMemTop
	mov	dx,CompMemPtr
	sub	ax,dx
	jz	@@3
	cmp	ax,1000h
	jb	@@2
	mov	ax,0fffh
@@2:	mov	cl,4
	shl	ax,cl
	mov	cx,ax
	xor	ax,ax
	push	bx
	push	cx
	Invoke	ReadHandle
	push	ax
	add	ax,15
	mov	cl,4
	shr	ax,cl
	add	CompMemPtr,ax
	pop	ax cx bx
	cmp	ax,cx
	je	@@1
	ret
@@3:	mov	ax,1
	Chain	CompileError
ReadFile	endp

	end
