	include	basm.inc

C	macro	Typ,Opcode,RM,ArgCount,C286,Next
	local	A,F
	ifb	<Next>
		db	Typ
	else
		db	Typ+80h
	endif
	A = 0
	ifnb	<C286>
		A = 4
	endif
	ifnb	<RM>
		A = A+RM*8
	endif
	ifnb	<ArgCount>
		A = A+ArgCount*64
	endif
	irp	F,<Opcode>
	A = A+1
	endm
	db	A-1
	db	Opcode
	endm

N	macro	Typ,Opcode,RM,ArgCount,C286
	C	<Typ>,<Opcode>,<RM>,<ArgCount>,<C286>,N
	endm

	.code	Basm_Text

	public	OpcodeTable
OpcodeTable	proc	near
	lea	di,@@1
	ret
@@1	label	word
	Hash	16
	HEnt	DB
	db	80h+cDB,1
	HEnt	DW
	db	80h+cDB,2
	HEnt	DD
	db	80h+cDB,4
	HEnt	LOCK
	N	cPrefix,0f0h
	HEnt	REP
	N	cPrefix,0f3h
	HEnt	REPE
	N	cPrefix,0f3h
	HEnt	REPZ
	N	cPrefix,0f3h
	HEnt	REPNE
	N	cPrefix,0f2h
	HEnt	REPNZ
	N	cPrefix,0f2h
	HEnt	SEGES
	N	cPrefix,26h
	HEnt	SEGCS
	N	cPrefix,2eh
	HEnt	SEGSS
	N	cPrefix,36h
	HEnt	SEGDS
	N	cPrefix,3eh
	HEnt	ADC
	N	cArOpRD,14h,,2
	N	cMovRMR,10h,,2
	C	cArOpRMD,80h,2,2
	HEnt	ADD
	N	cArOpRD,4,,2
	N	cMovRMR,0,,2
	C	cArOpRMD,80h,0,2
	HEnt	AND
	N	cArOpRD,24h,,2
	N	cMovRMR,20h,,2
	C	cMovRMD,80h,4,2
	HEnt	AAA
	C	cNop,37h
	HEnt	AAS
	C	cNop,3fh
	HEnt	AAD
	N	cNop,<0d5h,0ah>
	C	cPushD8,0d5h,,1
	HEnt	AAM
	N	cNop,<0d4h,0ah>
	C	cPushD8,0d4h,,1
	HEnt	BOUND
	C	cLds,62h,,2,286
	HEnt	CALL
	N	cJmpNear,0e8h,,1
	N	cJmpFar,9ah,,1
	N	cJmpRM16,0ffh,2,1
	C	cJmpRM32,0ffh,3,1
	HEnt	CMP
	N	cArOpRD,3ch,,2
	N	cMovRMR,38h,,2
	C	cArOpRMD,80h,7,2
	HEnt	CBW
	C	cNop,98h
	HEnt	CWD
	C	cNop,99h
	HEnt	CLC
	C	cNop,0f8h
	HEnt	CLD
	C	cNop,0fch
	HEnt	CLI
	C	cNop,0fah
	HEnt	CMC
	C	cNop,0f5h
	HEnt	CMPSB
	C	cNop,0a6h
	HEnt	CMPSW
	C	cNop,0a7h
	HEnt	DAA
	C	cNop,27h
	HEnt	DAS
	C	cNop,2fh
	HEnt	DEC
	N	cIncR16,48h,,1
	C	cIncRM,0feh,1,1
	HEnt	DIV
	C	cIncRM,0f6h,6,1
	HEnt	ENTER
	C	cEnter,0c8h,,2,286
	HEnt	HLT
	C	cNop,0f4h
	HEnt	IDIV
	C	cIncRM,0f6h,7,1
	HEnt	IMUL
	N	cIncRM,0f6h,5,1
	C	cImul286,69h,,3,286
	HEnt	IN
	N	cInDX,0ech,,2
	C	cInD8,0e4h,,2
	HEnt	INC
	N	cIncR16,40h,,1
	C	cIncRM,0feh,0,1
	HEnt	INSB
	C	cNop,6ch,,,286
	HEnt	INSW
	C	cNop,6dh,,,286
	HEnt	INT
	C	cInt,0cch,,1
	HEnt	INTO
	C	cNop,0ceh
	HEnt	IRET
	C	cNop,0cfh
	HEnt	JMP
	N	cJcc,0ebh,,1
	N	cJmpNear,0e9h,,1
	N	cJmpFar,0eah,,1
	N	cJmpRM16,0ffh,4,1
	C	cJmpRM32,0ffh,5,1
	HEnt	JO
	C	cJcc,70h,,1
	HEnt	JNO
	C	cJcc,71h,,1
	HEnt	JC
	C	cJcc,72h,,1
	HEnt	JB
	C	cJcc,72h,,1
	HEnt	JNAE
	C	cJcc,72h,,1
	HEnt	JNC
	C	cJcc,73h,,1
	HEnt	JAE
	C	cJcc,73h,,1
	HEnt	JNB
	C	cJcc,73h,,1
	HEnt	JE
	C	cJcc,74h,,1
	HEnt	JZ
	C	cJcc,74h,,1
	HEnt	JNE
	C	cJcc,75h,,1
	HEnt	JNZ
	C	cJcc,75h,,1
	HEnt	JBE
	C	cJcc,76h,,1
	HEnt	JNA
	C	cJcc,76h,,1
	HEnt	JA
	C	cJcc,77h,,1
	HEnt	JNBE
	C	cJcc,77h,,1
	HEnt	JS
	C	cJcc,78h,,1
	HEnt	JNS
	C	cJcc,79h,,1
	HEnt	JP
	C	cJcc,7ah,,1
	HEnt	JPE
	C	cJcc,7ah,,1
	HEnt	JNP
	C	cJcc,7bh,,1
	HEnt	JPO
	C	cJcc,7bh,,1
	HEnt	JL
	C	cJcc,7ch,,1
	HEnt	JNGE
	C	cJcc,7ch,,1
	HEnt	JGE
	C	cJcc,7dh,,1
	HEnt	JNL
	C	cJcc,7dh,,1
	HEnt	JLE
	C	cJcc,7eh,,1
	HEnt	JNG
	C	cJcc,7eh,,1
	HEnt	JG
	C	cJcc,7fh,,1
	HEnt	JNLE
	C	cJcc,7fh,,1
	HEnt	JCXZ
	C	cJcc,0e3h,,1
	HEnt	LAHF
	C	cNop,9fh
	HEnt	LDS
	C	cLds,0c5h,,2
	HEnt	LEA
	C	cLea,8dh,,2
	HEnt	LEAVE
	C	cNop,0c9h,,,286
	HEnt	LES
	C	cLds,0c4h,,2
	HEnt	LODSB
	C	cNop,0ach
	HEnt	LODSW
	C	cNop,0adh
	HEnt	LOOP
	C	cJcc,0e2h,,1
	HEnt	LOOPE
	C	cJcc,0e1h,,1
	HEnt	LOOPZ
	C	cJcc,0e1h,,1
	HEnt	LOOPNE
	C	cJcc,0e0h,,1
	HEnt	LOOPNZ
	C	cJcc,0e0h,,1
	HEnt	MOV
	N	cMovAccM,0a0h,,2
	N	cMovMAcc,0a2h,,2
	N	cMovRD,0b0h,,2
	N	cMovRMD,0c6h,,2
	N	cMovRMR,88h,,2
	N	cMovRMSr,8ch,,2
	C	cMovSrRM,8eh,,2
	HEnt	MOVSB
	C	cNop,0a4h
	HEnt	MOVSW
	C	cNop,0a5h
	HEnt	MUL
	C	cIncRM,0f6h,4,1
	HEnt	NEG
	C	cIncRM,0f6h,3,1
	HEnt	NOP
	C	cNop,90h
	HEnt	NOT
	C	cIncRM,0f6h,2,1
	HEnt	OR
	N	cArOpRD,0ch,,2
	N	cMovRMR,8,,2
	C	cMovRMD,80h,1,2
	HEnt	OUT
	N	cOutDX,0eeh,,2
	C	cOutD8,0e6h,,2
	HEnt	OUTSB
	C	cNop,6eh,,,286
	HEnt	OUTSW
	C	cNop,6fh,,,286
	HEnt	POP
	N	cIncR16,58h,,1
	N	cPopSr,7,,1
	C	cPopRM,8fh,0,1
	HEnt	POPA
	C	cNop,61h,,,286
	HEnt	POPF
	C	cNop,9dh
	HEnt	PUSH
	N	cIncR16,50h,,1
	N	cPushSr,6,,1
	N	cPopRM,0ffh,6,1
	N	cPushD8,6ah,,1,286
	C	cPushD16,68h,,1,286
	HEnt	PUSHA
	C	cNop,60h,,,286
	HEnt	PUSHF
	C	cNop,9ch
	HEnt	RET
	N	cRet,0c3h
	C	cRet,0c2h,,1
	HEnt	RETN
	N	cNop,0c3h
	C	cRetnD16,0c2h,,1
	HEnt	RETF
	N	cNop,0cbh
	C	cRetnD16,0cah,,1
	HEnt	SUB
	N	cArOpRD,2ch,,2
	N	cMovRMR,28h,,2
	C	cArOpRMD,80h,5,2
	HEnt	SBB
	N	cArOpRD,1ch,,2
	N	cMovRMR,18h,,2
	C	cArOpRMD,80h,3,2
	HEnt	RCL
	C	cShift,0d0h,2,2
	HEnt	RCR
	C	cShift,0d0h,3,2
	HEnt	ROL
	C	cShift,0d0h,0,2
	HEnt	ROR
	C	cShift,0d0h,1,2
	HEnt	SAL
	C	cShift,0d0h,4,2
	HEnt	SHL
	C	cShift,0d0h,4,2
	HEnt	SAR
	C	cShift,0d0h,7,2
	HEnt	SHR
	C	cShift,0d0h,5,2
	HEnt	SAHF
	C	cNop,9eh
	HEnt	SCASB
	C	cNop,0aeh
	HEnt	SCASW
	C	cNop,0afh
	HEnt	STC
	C	cNop,0f9h
	HEnt	STD
	C	cNop,0fdh
	HEnt	STI
	C	cNop,0fbh
	HEnt	STOSB
	C	cNop,0aah
	HEnt	STOSW
	C	cNop,0abh
	HEnt	TEST
	N	cArOpRD,0a8h,,2
	N	cMovRMD,0f6h,0,2
	C	cXchgRMR,84h,,2
	HEnt	WAIT
	C	cNop,9bh
	HEnt	XCHG
	N	cXchgRAX,90h,,2
	N	cXchgAXR,90h,,2
	C	cXchgRMR,86h,,2
	HEnt	XLAT
	C	cNop,0d7h
	HEnt	XOR
	N	cArOpRD,34h,,2
	N	cMovRMR,30h,,2
	C	cMovRMD,80h,6,2
	HEnt	ARPL
	C	cArpl,63h,,2,286
	HEnt	LAR
	C	cLar,<0fh,2>,,2,286
	HEnt	CLTS
	C	cNop,<0fh,6>,,,286
	HEnt	LGDT
	C	cLgdt,<0fh,1>,2,1,286
	HEnt	SGDT
	C	cLgdt,<0fh,1>,0,1,286
	HEnt	LIDT
	C	cLgdt,<0fh,1>,3,1,286
	HEnt	SIDT
	C	cLgdt,<0fh,1>,1,1,286
	HEnt	LLDT
	C	cPopRM,<0fh,0>,2,1,286
	HEnt	SLDT
	C	cPopRM,<0fh,0>,0,1,286
	HEnt	LMSW
	C	cPopRM,<0fh,1>,6,1,286
	HEnt	SMSW
	C	cPopRM,<0fh,1>,4,1,286
	HEnt	LSL
	C	cLar,<0fh,3>,,2,286
	HEnt	LTR
	C	cPopRM,<0fh,0>,3,1,286
	HEnt	STR
	C	cPopRM,<0fh,0>,1,1,286
	HEnt	VERR
	C	cPopRM,<0fh,0>,4,1,286
	HEnt	VERW
	C	cPopRM,<0fh,0>,5,1,286
	HEnt	FLD
	N	cFoper,<0d9h,0c1h>
	N	cF_STi,<0d9h,0c0h>,,1
	N	cF_RM,0d9h,0,1
	C	cF_Tbyte,0dbh,5,1
	HEnt	FILD
	N	cFiadd,0dbh,0,1
	C	cFild,0dfh,5,1
	HEnt	FST
	N	cFoper,<0ddh,0d1h>
	N	cF_STi,<0ddh,0d0h>,,1
	C	cF_RM,0d9h,2,1
	HEnt	FSTP
	N	cFoper,<0ddh,0d9h>
	N	cF_STi,<0ddh,0d8h>,,1
	N	cF_RM,0d9h,3,1
	C	cF_Tbyte,0dbh,7,1
	HEnt	FIST
	C	cFiadd,0dbh,2,1
	HEnt	FISTP
	N	cFiadd,0dbh,3,1
	C	cFild,0dfh,7,1
	HEnt	FADD
	N	cFoper,<0deh,0c1h>
	N	cF_STSTi,<0d8h,0c0h>,,2
	N	cF_STiST,<0dch,0c0h>,,2
	C	cF_RM,0d8h,0,1
	HEnt	FADDP
	N	cFoper,<0deh,0c1h>
	C	cF_STiST,<0deh,0c0h>,,2
	HEnt	FIADD
	C	cFiadd,0dah,0,1
	HEnt	FSUB
	N	cFoper,<0deh,0e9h>
	N	cF_STSTi,<0d8h,0e0h>,,2
	N	cF_STiST,<0dch,0e8h>,,2
	C	cF_RM,0d8h,4,1
	HEnt	FSUBP
	N	cFoper,<0deh,0e9h>
	C	cF_STiST,<0deh,0e8h>,,2
	HEnt	FSUBR
	N	cFoper,<0deh,0e1h>
	N	cF_STSTi,<0d8h,0e8h>,,2
	N	cF_STiST,<0dch,0e0h>,,2
	C	cF_RM,0d8h,5,1
	HEnt	FSUBRP
	N	cFoper,<0deh,0e1h>
	C	cF_STiST,<0deh,0e0h>,,2
	HEnt	FISUB
	C	cFiadd,0dah,4,1
	HEnt	FISUBR
	C	cFiadd,0dah,5,1
	HEnt	FMUL
	N	cFoper,<0deh,0c9h>
	N	cF_STSTi,<0d8h,0c8h>,,2
	N	cF_STiST,<0dch,0c8h>,,2
	C	cF_RM,0d8h,1,1
	HEnt	FMULP
	N	cFoper,<0deh,0c9h>
	C	cF_STiST,<0deh,0c8h>,,2
	HEnt	FIMUL
	C	cFiadd,0dah,1,1
	HEnt	FDIV
	N	cFoper,<0deh,0f9h>
	N	cF_STSTi,<0d8h,0f0h>,,2
	N	cF_STiST,<0dch,0f8h>,,2
	C	cF_RM,0d8h,6,1
	HEnt	FDIVP
	N	cFoper,<0deh,0f9h>
	C	cF_STiST,<0deh,0f8h>,,2
	HEnt	FDIVR
	N	cFoper,<0deh,0f1h>
	N	cF_STSTi,<0d8h,0f8h>,,2
	N	cF_STiST,<0dch,0f0h>,,2
	C	cF_RM,0d8h,7,1
	HEnt	FDIVRP
	N	cFoper,<0deh,0f1h>
	C	cF_STiST,<0deh,0f0h>,,2
	HEnt	FIDIV
	C	cFiadd,0dah,6,1
	HEnt	FIDIVR
	C	cFiadd,0dah,7,1
	HEnt	FCOM
	N	cFoper,<0d8h,0d1h>
	N	cF_STi,<0d8h,0d0h>,,1
	C	cF_RM,0d8h,2,1
	HEnt	FCOMP
	N	cFoper,<0d8h,0d9h>
	N	cF_STi,<0d8h,0d8h>,,1
	C	cF_RM,0d8h,3,1
	HEnt	FCOMPP
	C	cFoper,<0deh,0d9h>
	HEnt	FICOM
	C	cFiadd,0dah,2,1
	HEnt	FICOMP
	C	cFiadd,0dah,3,1
	HEnt	F2XM1
	C	cFoper,<0d9h,0f0h>
	HEnt	FABS
	C	cFoper,<0d9h,0e1h>
	HEnt	FBLD
	C	cF_Tbyte,0dfh,4,1
	HEnt	FBSTP
	C	cF_Tbyte,0dfh,6,1
	HEnt	FCHS
	C	cFoper,<0d9h,0e0h>
	HEnt	FDECSTP
	C	cFoper,<0d9h,0f6h>
	HEnt	FFREE
	C	cF_STi,<0ddh,0c0h>,,1
	HEnt	FINCSTP
	C	cFoper,<0d9h,0f7h>
	HEnt	FLD1
	C	cFoper,<0d9h,0e8h>
	HEnt	FLDCW
	C	cFstsw,0d9h,5,1
	HEnt	FLDENV
	C	cFstenv,0d9h,4,1
	HEnt	FLDL2E
	C	cFoper,<0d9h,0eah>
	HEnt	FLDL2T
	C	cFoper,<0d9h,0e9h>
	HEnt	FLDLG2
	C	cFoper,<0d9h,0ech>
	HEnt	FLDLN2
	C	cFoper,<0d9h,0edh>,,,286
	HEnt	FLDPI
	C	cFoper,<0d9h,0ebh>
	HEnt	FLDZ
	C	cFoper,<0d9h,0eeh>
	HEnt	FNOP
	C	cFoper,<0d9h,0d0h>
	HEnt	FPATAN
	C	cFoper,<0d9h,0f3h>
	HEnt	FPREM
	C	cFoper,<0d9h,0f8h>
	HEnt	FPTAN
	C	cFoper,<0d9h,0f2h>
	HEnt	FRNDINT
	C	cFoper,<0d9h,0fch>
	HEnt	FRSTOR
	C	cFsave,0ddh,4,1
	HEnt	FSCALE
	C	cFoper,<0d9h,0fdh>
	HEnt	FSETPM
	C	cFoper,<0dbh,0e4h>,,,286
	HEnt	FSQRT
	C	cFoper,<0d9h,0fah>
	HEnt	FTST
	C	cFoper,<0d9h,0e4h>
	HEnt	FWAIT
	C	cFoper,9bh
	HEnt	FXAM
	C	cFoper,<0d9h,0e5h>
	HEnt	FXCH
	N	cFoper,<0d9h,0c9h>
	C	cF_STi,<0d9h,0c8h>,,1
	HEnt	FXTRACT
	C	cFoper,<0d9h,0f4h>
	HEnt	FYL2X
	C	cFoper,<0d9h,0f1h>
	HEnt	FYL2XP1
	C	cFoper,<0d9h,0f9h>
	HEnt	FCLEX
	C	cFoper,<1,0dbh,0e2h>
	HEnt	FNCLEX
	C	cFoper,<0,0dbh,0e2h>
	HEnt	FDISI
	C	cFoper,<1,0dbh,0e1h>
	HEnt	FNDISI
	C	cFoper,<0,0dbh,0e1h>
	HEnt	FENI
	C	cFoper,<1,0dbh,0e0h>
	HEnt	FNENI
	C	cFoper,<0,0dbh,0e0h>
	HEnt	FINIT
	C	cFoper,<1,0dbh,0e3h>
	HEnt	FNINIT
	C	cFoper,<0,0dbh,0e3h>
	HEnt	FSAVE
	C	cFsave,<1,0ddh>,6,1
	HEnt	FNSAVE
	C	cFsave,<0,0ddh>,6,1
	HEnt	FSTCW
	C	cFstsw,<1,0d9h>,7,1
	HEnt	FNSTCW
	C	cFstsw,<0,0d9h>,7,1
	HEnt	FSTENV
	C	cFstenv,<1,0d9h>,6,1
	HEnt	FNSTENV
	C	cFstenv,<0,0d9h>,6,1
	HEnt	FSTSW
	N	cFstsw,<1,0ddh>,7,1
	C	cFstswAX,<1,0dfh,0e0h>,,1,286
	HEnt	FNSTSW
	N	cFstsw,<0,0ddh>,7,1
	C	cFstswAX,<0,0dfh,0e0h>,,1,286
	HEnd
OpcodeTable	endp

	public	ResWordTable
ResWordTable	proc	near
	lea	di,@@1
	ret
@@1	label	word
	Hash	8
	HEnt	OFFSET
	db	tOFFSET
	HEnt	SEG
	db	tSEG
	HEnt	TYPE
	db	tTYPE
	HEnt	PTR
	db	tPTR
	HEnt	NOT
	db	tNOT
	HEnt	OR
	db	tOR
	HEnt	XOR
	db	tXOR
	HEnt	AND
	db	tAND
	HEnt	MOD
	db	tMOD
	HEnt	SHR
	db	tSHR
	HEnt	SHL
	db	tSHL
	HEnt	HIGH
	db	tHIGH
	HEnt	LOW
	db	tLOW
	HEnt	BYTE
	db	tTYP
	dw	1
	HEnt	WORD
	db	tTYP
	dw	2
	HEnt	DWORD
	db	tTYP
	dw	4
	HEnt	QWORD
	db	tTYP
	dw	8
	HEnt	TBYTE
	db	tTYP
	dw	10
	HEnt	NEAR
	db	tTYP
	dw	-1
	HEnt	FAR
	db	tTYP
	dw	-2
	HEnt	AX
	db	tREG
	dw	rgAX*256+szWord
	HEnt	CX
	db	tREG
	dw	rgCX*256+szWord
	HEnt	DX
	db	tREG
	dw	rgDX*256+szWord
	HEnt	BX
	db	tREG
	dw	rgBX*256+szWord
	HEnt	SP
	db	tREG
	dw	rgSP*256+szWord
	HEnt	BP
	db	tREG
	dw	rgBP*256+szWord
	HEnt	SI
	db	tREG
	dw	rgSI*256+szWord
	HEnt	DI
	db	tREG
	dw	rgDI*256+szWord
	HEnt	AL
	db	tREG
	dw	rgAL*256+szByte
	HEnt	CL
	db	tREG
	dw	rgCL*256+szByte
	HEnt	DL
	db	tREG
	dw	rgDL*256+szByte
	HEnt	BL
	db	tREG
	dw	rgBL*256+szByte
	HEnt	AH
	db	tREG
	dw	rgAH*256+szByte
	HEnt	CH
	db	tREG
	dw	rgCH*256+szByte
	HEnt	DH
	db	tREG
	dw	rgDH*256+szByte
	HEnt	BH
	db	tREG
	dw	rgBH*256+szByte
	HEnt	ES
	db	tREG
	dw	rgES*256+szSreg
	HEnt	CS
	db	tREG
	dw	rgCS*256+szSreg
	HEnt	SS
	db	tREG
	dw	rgSS*256+szSreg
	HEnt	DS
	db	tREG
	dw	rgDS*256+szSreg
	HEnt	ST
	db	tREG
	dw	0*256+szST
	HEnd
ResWordTable	endp

	end
