	model	large compiler_text,pascal
	include	compiler.inc

	.code	compiler_text

	public	CompoundStmt
	public	ProcessInline
	public	PutInline

Statement	proc	near
	mov	ax,GlobalOptions
	mov	CompilerOptions,ax
	Invoke	Number2Ident
	Invoke	GetSymbol
	lea	bx,@@3
	Invoke	ChooseToken
	jnz	@@2
	Invoke	GetLineNumber
	push	ax TempLocalsSize
	call	word ptr cs:[bx+1]
	pop	TempLocalsSize dx
	or	dx,dx
	jz	@@1
	xchg	ax,dx
	Invoke	PutLineNumber
	xchg	ax,dx
	Invoke	UseGoal
	Invoke	DoneGoal
@@1:	mov	bl,1
	ret
@@2:	xor	ax,ax
	xor	bx,bx
	ret
@@3	db	22,3
	db	t_Var
	dw	Assignment
	db	t_Proc
	dw	Assignment
	db	t_StdProc
	dw	ProcedureCall
	db	tBegin
	dw	CompoundStmt
	db	tIf
	dw	IfStatement
	db	tWhile
	dw	WhileStatement
	db	tRepeat
	dw	RepeatStatement
	db	tFor
	dw	ForStatement
	db	tCase
	dw	CaseStatement
	db	tWith
	dw	WithStatement
	db	tGoto
	dw	GotoStatement
	db	t_Label
	dw	_Label
	db	tAsm
	dw	AsmStatement
	db	tInline
	dw	InlineStatement
	db	t_New
	dw	ProcedureCall
	db	t_Type
	dw	Assignment
	db	tString
	dw	Assignment
	db	tFile
	dw	Assignment
	db	t_StdFun
	dw	Assignment
	db	tAt
	dw	Assignment
	db	t_Mem
	dw	Assignment
	db	t_Port
	dw	PortAssignment
Statement	endp

ProcedureCall	proc	near
	Chain	StdProcedure
ProcedureCall	endp

AsmStatement	proc	near
	Chain	AsmClause
AsmStatement	endp

_Label	proc	near
	Invoke	GetHash
	les	di,CurrentSymbol
	cmp	di,si
	jb	@@1
	cmp	es:[di].lsLink,0
	jne	@@2
	dec	es:[di].lsLink
	Invoke	GetToken
	mov	al,tColon
	Invoke	NeedToken
	push	es di
	call	Statement
	push	ax
	mov	ax,3
	Invoke	GetStmtMem
	mov	al,12
	stosb
	mov	bx,di
	pop	ax di es
	mov	es:[di],bx
	Invoke	UseGoal
	Chain	DoneGoal
@@1:	mov	ax,80
	Chain	CompileError
@@2:	mov	ax,81
	Chain	CompileError
_Label	endp

CompoundStmt	proc	near
	mov	ax,tBegin+tEnd*256
Closure	label	near
	Loc	FinToken,byte,1
	Loc	WasStmt,byte,1
	Loc	Buffer,word,64
	Entry
	mov	FinToken,ah
	Invoke	NeedToken
	mov	Buffer[0],0
@@1:	call	Statement
	mov	WasStmt,bl
	lea	bx,Buffer
	Invoke	AddGoal
	mov	al,CurrentToken
	cmp	al,FinToken
	je	@@2
	cmp	al,tSemicolon
	jne	@@3
	Invoke	GetToken
	jmp	@@1
@@2:	lea	bx,Buffer
	Invoke	FlushGoals
	Invoke	GetLineNumber
	Invoke	PutLineNumber
	Invoke	DoneGoal
	Invoke	GetToken
	Exit
@@3:	mov	ax,85
	cmp	WasStmt,0
	jne	@@4
	mov	ax,113
@@4:	Chain	CompileError
CompoundStmt	endp

IfStatement	proc	near
	Loc	Condition,byte,<size TExpr>
	Loc	ThenGoal,word,1
	Loc	ElseGoal,word,1
	Loc	EndLabel,word,1
	Entry
	Invoke	GetToken
	mov	ElseGoal,0
	mov	EndLabel,0
	lea	di,Condition
	Invoke	GetBooleanExpr
	mov	ax,tThen
	Invoke	NeedToken
	call	Statement
	mov	ThenGoal,ax
	mov	al,tElse
	Invoke	CheckToken
	jnz	@@1
	call	Statement
	mov	ElseGoal,ax
@@1:	cmp	Condition.exLocation,elImmediate
	jne	@@2
	mov	ax,ThenGoal
	cmp	Condition.exValue.B0,0
	jne	@@4
	mov	ax,ElseGoal
	jmp	short @@4
@@2:	mov	ax,Condition.exCode
	Invoke	UseGoal
	mov	ax,ThenGoal
	Invoke	UseGoal
	cmp	ElseGoal,0
	je	@@3
	mov	al,cdAlways
	lea	bx,EndLabel
	Invoke	PutJmp
@@3:	lea	bx,Condition.exChain2
	Invoke	PutLabel
	mov	ax,ElseGoal
	Invoke	UseGoal
	lea	bx,EndLabel
	Invoke	PutLabel
	Invoke	DoneGoal
@@4:	Exit
IfStatement	endp

WhileStatement	proc	near
	Loc	Condition,byte <size TExpr>
	Loc	EndLabel,word,1
	Entry
	Invoke	GetToken
	mov	EndLabel,0
	lea	di,Condition
	Invoke	GetBooleanExpr
	mov	ax,tDo
	Invoke	NeedToken
	call	Statement
	cmp	Condition.exLocation,elImmediate
	jne	@@2
	cmp	Condition.exValue.B0,0
	jne	@@1
	xor	ax,ax
	jmp	short @@3
@@1:	mov	Condition.exChain2,0
@@2:	Invoke	UseGoal
	mov	al,cdAlways
	lea	bx,EndLabel
	Invoke	PutJmp
	Invoke	DoneGoal
	push	ax
	lea	bx,EndLabel
	Invoke	PutLabel
	mov	ax,Condition.exCode
	Invoke	UseGoal
	pop	ax
	Invoke	UseGoal
	lea	bx,Condition.exChain2
	Invoke	PutLabel
	Invoke	DoneGoal
@@3:	Exit
WhileStatement	endp

RepeatStatement	proc	near
	Loc	Condition,byte,<size TExpr>
	Loc	Body,word,1
	Entry
	mov	ax,tRepeat+tUntil*256
	call	Closure
	mov	Body,ax
	lea	di,Condition
	Invoke	GetBooleanExpr
	cmp	Condition.exLocation,elImmediate
	jne	@@1
	mov	ax,Body
	cmp	Condition.exValue.B0,0
	jne	@@2
	mov	Condition.exChain2,0
	mov	al,cdAlways
	lea	bx,Condition.exChain2
	Invoke	PutJmp
	Invoke	DoneGoal
	mov	Condition.exCode,ax
@@1:	lea	bx,Condition.exChain2
	Invoke	PutLabel
	mov	ax,Body
	Invoke	UseGoal
	mov	ax,Condition.exCode
	Invoke	UseGoal
	Invoke	DoneGoal
@@2:	Exit
RepeatStatement	endp

ForStatement	proc	near
	Loc	ControlVar,byte,<size TExpr>
	Loc	LowerBound,byte,<size TExpr>
	Loc	UpperBound,byte,<size TExpr>
	Loc	X,byte,<size TExpr>
	Loc	Y,byte,<size TExpr>
	Loc	Z,byte,<size TExpr>
	Loc	Action,word,1
	Loc	Body,word,1
	Loc	SmartLabel,word,1
	Entry
	Invoke	GetToken
	mov	SmartLabel,0
	lea	di,ControlVar
	Invoke	GetReference
	les	bx,[di].exType
	cmp	es:[bx].tdType,ttInteger
	jb	@@1
	test	[di].exMisc,efDS+efSS
	jz	@@1
	test	[di].exMisc,efDI
	jz	@@2
@@1:	mov	ax,97
	Chain	CompileError
@@2:	mov	ax,tAssign
	Invoke	NeedToken
	lea	di,LowerBound
	call	GetBound
	lea	bx,ToDownto
	Invoke	ChooseToken
	jz	@@3
	mov	ax,58
	Chain	CompileError
@@3:	mov	Action,bx
	Invoke	GetToken
	lea	di,UpperBound
	call	GetBound
	cmp	LowerBound.exLocation,elImmediate
	jne	@@4
	cmp	UpperBound.exLocation,elImmediate
	je	@@5
@@4:	lea	di,LowerBound
	Invoke	UseExpr
	mov	al,lvAX
	Invoke	LoadValue
	Invoke	DoneExpr
	cmp	UpperBound.exLocation,elImmediate
	je	@@5
	lea	di,UpperBound
	Invoke	CreateTempInt
	mov	[di].exRegsUsed,0
@@5:	mov	ax,tDo
	Invoke	NeedToken
	call	Statement
	mov	Body,ax
	lea	di,X
	lea	si,LowerBound
	call	CopyExpr
	lea	di,Z
	lea	si,UpperBound
	call	CopyExpr
	lea	di,X
	lea	si,Z
	mov	bx,Action
	mov	al,cs:[bx+1]
	call	Compare
	lea	di,Y
	lea	si,ControlVar
	call	CopyExpr
	lea	di,Z
	lea	si,UpperBound
	call	CopyExpr
	lea	di,Y
	lea	si,Z
	mov	al,opNotEqual
	call	Compare
	lea	di,Z
	lea	si,LowerBound
	call	CopyExpr
	lea	di,ControlVar
	lea	si,Z
	Invoke	Store
	cmp	X.exLocation,elImmediate
	jne	@@7
	cmp	X.exValue.B0,0
	je	@@6
	xor	ax,ax
	jmp	short @@8
@@6:	mov	X.exValue.W0,0
@@7:	mov	ax,UpperBound.exCode
	Invoke	UseGoal
	mov	ax,LowerBound.exCode
	Invoke	UseGoal
	mov	ax,X.exCode
	Invoke	UseGoal
	mov	ax,ControlVar.exCode
	Invoke	UseGoal
	mov	al,cdAlways
	lea	bx,SmartLabel
	Invoke	PutJmp
	lea	bx,Y.exChain1
	Invoke	PutLabel
	call	AdvanceVar
	lea	bx,SmartLabel
	Invoke	PutLabel
	mov	ax,Body
	Invoke	UseGoal
	mov	ax,Y.exCode
	Invoke	UseGoal
	lea	bx,X.exChain1
	Invoke	PutLabel
	Invoke	DoneGoal
@@8:	Exit

CopyExpr	proc	near
	mov	cx,size TExpr shr 1
	push	ds
	pop	es
	rep	movsw
	mov	[di-size TExpr].exCode,cx
	ret
CopyExpr	endp

GetBound	proc	near
	Invoke	GetExpr
	lea	si,ControlVar
	Invoke	TypeCompat
	Chain	CastOrdinal
GetBound	endp

Compare	proc	near
	Invoke	Operation
	cmp	[di].exLocation,elImmediate
	je	@@1
	Invoke	UseExpr
	mov	al,[di].exMisc
	lea	bx,[di].exChain1
	Invoke	PutJmp
	lea	bx,[di].exChain2
	Invoke	PutLabel
	Chain	DoneExpr
@@1:	ret
Compare	endp

AdvanceVar	proc	near
	lea	di,ControlVar
	mov	si,Action
	test	[di].exModifier,emXX
	jnz	@@1
	mov	dl,0feh
	mov	dh,cs:[si+2]
	Chain	PutRM
@@1:	mov	ax,1
	mov	dl,cs:[si+3]
	Invoke	PutArOpRMImm
	add	[di].exOffset,2
	xor	ax,ax
	mov	dl,cs:[si+4]
	Invoke	PutArOpRMImm
	sub	[di].exOffset,2
	ret
AdvanceVar	endp

ToDownto	db	2,5
		db	tTo
		db	opGreater
		db	0		; inc
		db	0		; add
		db	10h		; adc
		db	tDownTo
		db	opLess
		db	8		; dec
		db	28h		; sub
		db	18h		; sbb
ForStatement	endp

CaseStatement	proc	near
	Loc	CaseLabel,word,1
	Loc	NextLabel,word,1
	Loc	EndLabel,word,1
	Loc	BaseType,dword,1
	Loc	CaseExpr,byte,<size TExpr>
	Loc	CaseConst,byte,<size TExpr>
	Loc	Buffer,word,64
	Entry
	Invoke	GetToken
	xor	ax,ax
	mov	CaseLabel,ax
	mov	NextLabel,ax
	mov	EndLabel,ax
	mov	Buffer[0],ax
	lea	di,CaseExpr
	Invoke	GetOrdExpr
	mov	si,es:[bx].itBase.Offs
	mov	bx,es:[bx].itBase.Segm
	mov	es,es:[bx]
	mov	BaseType.Offs,si
	mov	BaseType.Segm,es
	test	[di].exModifier,emXX
	jz	@@1
	Invoke	CastInt
@@1:	Invoke	UseExpr
	mov	al,lvAX
	Invoke	LoadValue
	Invoke	DoneGoal
	lea	bx,Buffer
	Invoke	AddGoal
	mov	al,tOf
	Invoke	NeedToken
@@2:	call	Case
	Invoke	DoneGoal
	lea	bx,Buffer
	Invoke	AddGoal
	call	Statement
	lea	bx,Buffer
	Invoke	AddGoal
	mov	al,tSemicolon
	Invoke	CheckToken
	jnz	@@3
	cmp	CurrentToken,tEnd
	je	@@3
	cmp	CurrentToken,tElse
	je	@@3
	mov	al,cdAlways
	lea	bx,EndLabel
	Invoke	PutJmp
	lea	bx,NextLabel
	Invoke	PutLabel
	jmp	@@2
@@3:	mov	al,tElse
	Invoke	CheckToken
	jnz	@@5
	mov	al,cdAlways
	lea	bx,EndLabel
	Invoke	PutJmp
	lea	bx,NextLabel
	Invoke	PutLabel
	Invoke	DoneGoal
	lea	bx,Buffer
	Invoke	AddGoal
@@4:	call	Statement
	lea	bx,Buffer
	Invoke	AddGoal
	cmp	CurrentToken,tEnd
	je	@@5
	mov	al,tSemicolon
	Invoke	NeedToken
	jmp	@@4
@@5:	mov	al,tEnd
	Invoke	NeedToken
	lea	bx,Buffer
	Invoke	FlushGoals
	lea	bx,EndLabel
	mov	ax,NextLabel
	Invoke	AddToChain
	lea	bx,EndLabel
	Invoke	PutLabel
	Invoke	DoneGoal
	Exit

Case	proc	near
	Invoke	GetLineNumber
	Invoke	PutLineNumber
@@1:	call	CaseConstant
	mov	dl,cdEqual
	mov	al,tRange
	Invoke	CheckToken
	jnz	@@3
	mov	al,cdLess
	mov	dl,cdNotGreater
	test	CaseExpr.exModifier,emUnsigned
	jz	@@2
	mov	al,cdBelow
	mov	dl,cdNotAfter
@@2:	push	dx
	lea	bx,NextLabel
	Invoke	PutJmp
	call	CaseConstant
	pop	dx
@@3:	mov	al,tComma
	Invoke	CheckToken
	jnz	@@4
	mov	al,dl
	lea	bx,CaseLabel
	Invoke	PutJmp
	lea	bx,NextLabel
	Invoke	PutLabel
	jmp	@@1
@@4:	mov	al,dl
	xor	al,1
	lea	bx,NextLabel
	Invoke	PutJmp
	lea	bx,CaseLabel
	Invoke	PutLabel
	mov	al,tColon
	Chain	NeedToken
Case	endp

CaseConstant	proc	near
	lea	di,CaseConst
	Invoke	GetConstExpr
	cmp	bx,BaseType.Offs
	jnz	@@2
	mov	ax,es
	cmp	ax,BaseType.Segm
	jnz	@@2
	mov	al,CaseExpr.exModifier
	mov	ah,[di].exModifier
	Invoke	IntExtension
	cmp	al,CaseExpr.exModifier
	jne	@@3
	test	al,emX
	jz	@@1
	mov	al,3dh			; cmp	ax,
	Invoke	PutByte
	mov	ax,[di].exValue.W0
	Chain	PutWord
@@1:	mov	al,3ch			; cmp	al,
	mov	ah,[di].exValue.B0
	Chain	PutWord
@@2:	mov	ax,74
	Chain	CompileError
@@3:	mov	ax,112
	Chain	CompileError
CaseConstant	endp

CaseStatement	endp

WithStatement	proc	near
	Loc	SaveWithChain,word,1
	Loc	WithVar,byte,<size TExpr>
	Loc	Buffer,word,32
	Entry
	Invoke	GetToken
	mov	ax,WithChain
	mov	SaveWithChain,ax
	mov	Buffer[0],0
@@1:	lea	di,WithVar
	Invoke	GetReference
	les	bx,[di].exType
	cmp	es:[bx].tdType,ttRecord
	je	@@2
	cmp	es:[bx].tdType,ttObject
	je	@@2
	mov	ax,75
	Chain	CompileError
@@2:	sub	sp,size TWithChain
	mov	si,sp
	mov	ax,WithChain
	mov	[si].wcNext,ax
	mov	WithChain,si
	mov	[si].wcOwner.Offs,bx
	mov	[si].wcOwner.Segm,es
	mov	al,[di].exMisc
	test	al,efDS+efSS
	jz	@@3
	test	al,efDI
	jnz	@@3
	mov	[si].wcType,wfNoTempVar
	mov	[si].wcFlags,al
	mov	ax,[di].exOffset
	mov	[si].wcOffset,ax
	mov	ax,[di].exMap
	mov	[si].wcMap,ax
	mov	ax,[di].exSegment
	mov	[si].wcSegment,ax
	jmp	short @@4
@@3:	mov	ax,4
	Invoke	AllocStack
	mov	[si].wcType,wfTempVar
	mov	[si].wcFlags,efSS+efBP
	mov	[si].wcOffset,ax
	xor	ax,ax
	mov	[si].wcMap,ax
	mov	[si].wcSegment,ax
	Invoke	UseExpr
	Invoke	LoadSegDI
	push	ax
	mov	dx,3e89h		; mov	[bp-...],di
	mov	ax,[si].wcOffset
	Invoke	AddOffset
	pop	ax
	mov	dx,68ch			; mov	[bp-...],es
	or	dh,al
	mov	ax,[si].wcOffset
	add	ax,2
	Invoke	AddOffset
	Invoke	DoneGoal
	lea	bx,Buffer
	Invoke	AddGoal
@@4:	mov	al,tComma
	Invoke	CheckToken
	jnz	@@5
	jmp	@@1
@@5:	mov	al,tDo
	Invoke	NeedToken
	call	Statement
	lea	bx,Buffer
	Invoke	AddGoal
	mov	ax,SaveWithChain
	mov	WithChain,ax
	lea	bx,Buffer
	Invoke	FlushGoals
	Invoke	DoneGoal
	Exit
WithStatement	endp

GotoStatement	proc	near
	Invoke	GetToken
	Invoke	Number2Ident
	Invoke	GetSymbol
	mov	al,t_Label
	Invoke	NeedToken
	Invoke	GetHash
	mov	dx,CurrentHash
	cmp	dx,si
	jb	@@1
	mov	ax,8
	Invoke	GetStmtMem
	push	di
	mov	ax,0eb08h
	stosw
	mov	ax,dx
	stosw
	pop	ax
	xchg	ax,LabelChain
	stosw
	Chain	DoneGoal
@@1:	mov	ax,80
	Chain	CompileError
GotoStatement	endp

InlineStatement	proc	near
	Invoke	GetToken
	push	Dictionary.Offs
	call	ProcessInline
	call	PutInline
	pop	Dictionary.Offs
	Chain	DoneGoal
InlineStatement	endp

ProcessInline	proc	near
	Loc	Temp,byte,<size TInlineRecord>
	Entry
	push	Dictionary.Offs
	mov	SlashToken,tInlineSlash
	mov	al,tOParen
	Invoke	NeedToken
@@1:	mov	al,tGreater
	Invoke	CheckToken
	mov	al,itWord
	jz	@@2
	mov	al,tLess
	Invoke	CheckToken
	mov	al,itByte
	jz	@@2
	mov	al,-1
@@2:	mov	Temp.irType,al
	Invoke	GetSymbol
	cmp	CurrentToken,t_Var
	jne	@@7
	les	di,CurrentSymbol
@@3:	test	es:[di].vsFlags,vfAlias
	jz	@@4
	mov	bx,es:[di].vsLink.Segm
	mov	di,es:[di].vsLink.Offs
	mov	es,es:[bx]
	jmp	@@3
@@4:	mov	al,es:[di].vsFlags
	test	al,vfLocal
	jnz	@@5
	cmp	Temp.irType,0
	je	@@6
	and	al,vfConst+vfLocal
	add	al,itDataFixup
	mov	Temp.irType,al
	mov	ax,es:[di].vsScope
	mov	Temp.irFixup.Offs,ax
	mov	dx,es
	Invoke	SearchUnit
	mov	Temp.irFixup.Segm,dx
@@5:	mov	ax,es:[di].vsOffset
	jmp	short @@8
@@6:	mov	ax,105
	Chain	CompileError
@@7:	cmp	CurrentToken,t_Proc
	jne	@@11
	Invoke	GetReturnVar
	jc	@@11
@@8:	mov	Temp.irValue,ax
	cmp	Temp.irType,0
	jge	@@9
	mov	Temp.irType,itWord
@@9:	Invoke	GetToken
	Invoke	GetPlusMinus
	or	al,al
	jz	@@12
	push	ax
	Invoke	GetIntConstExpr
	pop	cx
	cmp	cl,tMinus
	jne	@@10
	neg	ax
@@10:	add	Temp.irValue,ax
	jmp	short @@12
@@11:	Invoke	GetIntConstExpr
	mov	Temp.irValue,ax
@@12:	mov	al,Temp.irType
	cmp	al,-1
	jne	@@14
	mov	al,itByte
	cmp	Temp.irValue.B1,0
	je	@@13
	mov	al,itWord
@@13:	mov	Temp.irType,al
@@14:	mov	cl,al
	add	cl,2
	cmp	al,itDataFixup
	jb	@@15
	mov	cl,7
@@15:	xor	ch,ch
	mov	ax,cx
	Invoke	GetDictMem
	lea	si,Temp
	rep	movsb
	mov	al,tInlineSlash
	Invoke	CheckToken
	jnz	@@16
	jmp	@@1
@@16:	mov	SlashToken,tSlash
	mov	al,tCParen
	Invoke	NeedToken
	pop	di
	les	cx,Dictionary
	sub	cx,di
	Exit
ProcessInline	endp

PutInline	proc	near
	add	cx,di
	jmp	short @@6
@@1:	push	cx
	mov	al,es:[di].irType
	cmp	al,itByte
	je	@@4
	cmp	al,itWord
	je	@@3
	mov	cx,ffData+ffOffs
	cmp	al,itDataFixup
	je	@@2
	mov	cx,ffConst+ffOffs
@@2:	mov	bx,es:[di].irFixup.Segm
	mov	ax,es:[bx]
	mov	bx,es:[di].irFixup.Offs
	mov	dx,es:[di].irValue
	Invoke	PutFixup
	add	di,7
	jmp	short @@5
@@3:	mov	ax,es:[di].irValue
	Invoke	PutWord
	add	di,3
	jmp	short @@5
@@4:	mov	al,es:[di].irValue.B0
	Invoke	PutByte
	inc	di
	inc	di
@@5:	pop	cx
@@6:	cmp	di,cx
	jne	@@1
	ret
PutInline	endp

PortAssignment	proc	near
	Loc	Opcode,byte,2
	Loc	PortNum,byte,<size TExpr>
	Loc	Value,byte,<size TExpr>
	Entry
	Invoke	GetToken
	les	si,CurrentSymbol
	mov	al,0e6h			; out	...,al
	add	al,es:[si]
	mov	Opcode,al
	mov	al,tOBracket
	Invoke	NeedToken
	lea	di,PortNum
	Invoke	GetIntExpr
	Invoke	CastWord
	mov	al,tCBracket
	Invoke	NeedToken
	mov	al,tAssign
	Invoke	NeedToken
	lea	di,Value
	Invoke	GetIntExpr
	test	Opcode,1
	jz	@@1
	Invoke	CastWord
	jmp	short @@2
@@1:	Invoke	CastByte
@@2:	lea	si,PortNum
	cmp	[si].exLocation,elImmediate
	jne	@@3
	cmp	[si].exValue.B1,0
	jne	@@3
	Invoke	UseExpr
	mov	al,lvAX
	Invoke	LoadValue
	mov	al,Opcode
	mov	ah,[si].exValue.B0
	Invoke	PutWord
	jmp	short @@4
@@3:	Invoke	MakePtr
	mov	al,Opcode
	or	al,8
	Invoke	PutByte
@@4:	Invoke	DoneGoal
	Exit
PortAssignment	endp

Assignment	proc	near
	Loc	Left,byte,<size TExpr>
	Loc	Right,byte,<size TExpr>
	Entry
	lea	di,Left
	Invoke	GetLvalue
@@1:	les	bx,[di].exType
	cmp	es:[bx].tdType,ttProc
	jne	@@3
	cmp	[di].exLocation,elCall
	je	@@2
	cmp	CurrentToken,tAssign
	je	@@4
@@2:	Invoke	PutCall
	les	bx,[di].exType
	cmp	es:[bx].ptResult.Offs,0
	je	@@5
	Invoke	ReturnValue
	Invoke	Qualifier
	jz	@@1
	test	GlobalOptions,coExtSyntax
	jz	@@4
	cmp	CurrentToken,tAssign
	je	@@4
	Invoke	DiscardReturn
	jmp	short @@5
@@3:	Invoke	Qualifier
	jz	@@1
@@4:	cmp	[di].exLocation,elMemory
	jne	@@6
	test	[di].exMisc,efReadOnly
	jnz	@@6
	les	bx,[di].exType
	mov	al,es:[bx].tdType
	cmp	al,ttVoid
	je	@@7
	cmp	al,ttFile
	je	@@7
	cmp	al,ttText
	je	@@7
	mov	al,tAssign
	Invoke	NeedToken
	lea	di,Right
	lea	si,Left
	Invoke	GetExpression
	lea	si,Left
	Invoke	AssignmentCast
	Invoke	TypeCompat
	Invoke	CastOrdinal
	xchg	si,di
	Invoke	Store
@@5:	mov	ax,[di].exCode
	Exit
@@6:	mov	ax,122
	Chain	CompileError
@@7:	mov	ax,43
	Chain	CompileError
Assignment	endp

	end
