unit TEdit;

{$F+,S-}

interface

uses Objects, Views, TDos, VMem;

const

  edNop                     = $FF00;
  edGlop                    = $FF01;
  edInsertChar              = $FF02;
  edSetReturnCode           = $FF03;
  edReadFile                = $FF04;
  edWriteFile               = $FF05;
  edReadBlk                 = $FF06;
  edWriteBlk                = $FF07;
  edInvalidateScreen        = $FF08;
  edFullPaintScreen         = $FF09;
  edSmartRefreshScreen      = $FF0A;
  edSearchText              = $FF0B;
  edStorePagesInfo          = $FF0C;
  edCompact                 = $FF0D;
  edClearText               = $FF0E;
  edFindOldLine             = $FF0F;
  edGetNewLineNumber        = $FF10;
  edCursorRight             = $FF11;
  edCursorLeft              = $FF12;
  edCursorCharRight         = $FF13;
  edCursorCharLeft          = $FF14;
  edCursorUp                = $FF15;
  edCursorDown              = $FF16;
  edWordLeft                = $FF17;
  edWordRight               = $FF18;
  edScrollScreenUp          = $FF19;
  edScrollScreenDown        = $FF1A;
  edPageScreenUp            = $FF1B;
  edPageScreenDown          = $FF1C;
  edLeftOfLine              = $FF1D;
  edRightOfLine             = $FF1E;
  edTopOfScreenRaw          = $FF1F;
  edBottomOfScreenRaw       = $FF20;
  edHomeCursorRaw           = $FF21;
  edEndCursorRaw            = $FF22;
  edToggleInsert            = $FF23;
  edSetInsertMode           = $FF24;
  edDeleteLineX             = $FF25;
  edDeleteToEOL             = $FF26;
  edDeleteWord              = $FF27;
  edDeleteChar              = $FF28;
  edBackspaceDelete         = $FF29;
  edRestoreLine             = $FF2A;
  edSetBlockBegRaw          = $FF2B;
  edSetBlockEndRaw          = $FF2C;
  edHighlightBlock          = $FF2D;
  edToggleHideBlock         = $FF2E;
  edMoveToBlockBegRaw       = $FF2F;
  edMoveToBlockEndRaw       = $FF30;
  edCopyBlockRaw            = $FF31;
  edMoveBlockRaw            = $FF32;
  edDeleteBlockRaw          = $FF33;
  edSetPrevPos              = $FF34;
  edSwapPrevPos             = $FF35;
  edMoveToPrevPos           = $FF36;
  edMoveToMark              = $FF37;
  edSetMark                 = $FF38;
  edInsertText              = $FF39;
  edLiteralChar             = $FF3A;
  edSeekPos                 = $FF3B;
  edGetText                 = $FF3C;
  edGetTotalLines           = $FF3D;
  edFixCursorPos            = $FF3E;
  edFixScreenPos            = $FF3F;
  edCenterFixScreenPos      = $FF40;
  edReplaceText             = $FF41;
  edSetTempPos              = $FF42;
  edMoveToTempPos           = $FF43;
  edGetOneChar              = $FF44;
  edInsertBuf               = $FF45;
  edIndentBlock             = $FF46;
  edOutdentBlock            = $FF47;
  edToggleAutoIndent        = $FF48;
  edSetAutoIndent           = $FF49;
  edToggleAutoOutdent       = $FF4A;
  edSetAutoOutdent          = $FF4B;
  edRightOfWord             = $FF4C;
  edMatchPairForward        = $FF4D;
  edMatchPairBackward       = $FF4E;
  edHideBlock               = $FF4F;
  edSetTabbingMode          = $FF50;
  edToggleTabbingMode       = $FF51;
  edSetOptimalFillMode      = $FF52;
  edToggleOptimalFillMode   = $FF53;
  edSmartTab                = $FF54;
  edCursorSwitchedRight     = $FF55;
  edCursorSwitchedLeft      = $FF56;
  edPageUpRaw               = $FF57;
  edPageDownRaw             = $FF58;
  edGetPosOffset            = $FF59;
  edToggleRoamingCursorMode = $FF5A;
  edSetRoamingCursorMode    = $FF5B;
  edPushPos                 = $FF5C;
  edPopPos                  = $FF5D;

  eeLineTooLong  = 0;
  eeTooManyLines = 1;
  eeNoVirtMem    = 2;
  eeHeapFailure  = 3;
  eeReadError    = 4;
  eeFileTooLarge = 5;

  erLineTooLong  = 1 shl eeLineTooLong;
  erTooManyLines = 1 shl eeTooManyLines;
  erNoVirtMem    = 1 shl eeNoVirtMem;
  erHeapFailure  = 1 shl eeHeapFailure;
  erReadError    = 1 shl eeReadError;
  erFileTooLarge = 1 shl eeFileTooLarge;

  emShow   = $01;
  emUpdate = $02;

  eoOverwrite     = $0001;
  eoAutoIndent    = $0002;
  eoUseTab        = $0004;
  eoBlockHidden   = $0008;
  eoAutoOutdent   = $0020;
  eoUndoAllowed   = $0040;
  eoNoTruncate    = $0080;
  eoOptimalFill   = $0100;
  eoRoamingCursor = $0200;

  esBackward       = $01;
  esEntireScope    = $02;
  esSelectedText   = $04;
  esIgnoreCase     = $08;
  esRegularExprs   = $10;
  esWholeWordsOnly = $20;

  MaxBpt = 16;

  hVMem = $FFF0;

type

  PEBpt = ^TEBpt;
  TEBpt = record
    Pos: TPoint;
    Color: Word;
  end;

  PEBptArray = ^TEBptArray;
  TEBptArray = record
    Count: Integer;
    EBpt: array[0..MaxBpt-1] of TEBpt;
    Bpt: array[0..MaxBpt-1] of Pointer;
  end;

  PFileRec = ^TFileRec;

  PEditor = ^TEditor;
  TEditor = record
    EditView: PView;
    CommandTable: Pointer;
    WindowWidth: Integer;
    WindowHeight: Integer;
    PrevScreenRow: Integer;
    PrevScreenCol: Integer;
    Colors: array[0..3] of Byte;
    RedrawFlags: Word;
    Options: Word;
    TabSize: Word;
    Handle: HMem;
    SmartBounds: Word;
    LineLens: array[0..49] of Byte;
    UndoLen: Word;
    UndoPtr: Pointer;
    UndoBufLen: Word;
    ErrorProc: Pointer;
    ScreenPos: TPoint;
    CursorPos: TPoint;
    PrevPos: TPoint;
    BlockBeg: TPoint;
    BlockEnd: TPoint;
    TempPos: TPoint;
    TempPos2: TPoint;
    UndoBeg: TPoint;
    UndoEnd: TPoint;
    Marks: array[0..9] of TPoint;
    FileRec: PFileRec;
    Next: PEditor;
  end;

  PEditSegment = ^TEditSegment;
  TEditSegment = record
    EdStruct: TEditor;
    Modified: Byte;
    T: Byte;
    ExecBar: Integer;
    RedrawLine: Integer;
    PageSize: Word;
    Dummy1: Longint;
    BreakPts: PEBptArray;
    PendingChar: Byte;
    SecondByte: Byte;
    PageTblSize: Word;
    LastPage: Word;
    CurPage: Word;
    CPFirstLine: Integer;
    SearchPos: Integer;
    LockedPage: HMem;
    SubTblPtr: Word;
    ReturnCode: Word;
    Errors: Byte;
    Dummy2: array[0..2] of Byte;
    VFileOffset: Longint;
    VFilePoint: TPoint;
    VFileStack: array[0..7] of Longint;
    EParam: PEditor;
    CParam: Word;
    LParam: Pointer;
    WParam: Word;
    Dummy3: Longint;
    PageTbl: record end;
  end;

  TFileRec = record
    Editor: PEditor;
    Time: Longint;
    Next: PFileRec;
    FileName: PathStr;
    Breakpoints: TEBptArray;
  end;

function FindFile(var Path: PathStr): PFileRec;
function EditFunc(Editor: PEditor; Command: Word; LP: Pointer;
  WP: Word): Integer;

const
  CurEditView: PView = nil;
  LoadedFiles: PFileRec = nil;

implementation

uses VMemUtil;

var
  Line: Byte;
  Dir: Shortint;

function FindFile(var Path: PathStr): PFileRec;
var
  P: PFileRec;
begin
  P := LoadedFiles;
  while P <> nil do
  begin
    if Path = P^.FileName then
    begin
      FindFile := P;
      Exit
    end;
    P := P^.Next;
  end;
  FindFile := nil;
end;

procedure SetLine(ALine, ADir: Byte); assembler;
asm
        MOV     AL,ALine
        DEC     AL
        MOV     Line,AL
        MOV     AL,ADir
        SHL     AL,1
        DEC     AL
        MOV     Dir,AL
end;

procedure WriteOneLine(Width: Byte; var Buf);
begin
  CurEditView^.WriteLine(0, Line, Width, 1, Buf);
  Inc(Line, Dir);
end;

procedure FlushScreen;
begin
end;

function GetCurEditView: PView;
begin
  GetCurEditView := CurEditView;
end;

procedure SetCurEditView(Editor: PView);
begin
  CurEditView := Editor;
end;

function RedrawLocked: Boolean; assembler;
asm
        XOR     AX,AX
end;

procedure SetEditorCursor(X, Y: Integer);
begin
  CurEditView^.SetCursor(X - 1, Y - 1);
end;

function Read(Handle: Word; H: HMem; Size: Integer): Integer;
begin
  if Handle = hVMem then
    Read := GetFromVMem(Ptr(H^, 0)^, Size)
  else
    Read := FRead(Handle, Ptr(H^, 0)^, Size);
end;

function Write(Handle: Word; H: HMem; Size: Integer): Integer;
begin
  if Handle = hVMem then
    Write := PutToVMem(Ptr(H^, 0)^, Size)
  else
    Write := FWrite(Handle, Ptr(H^, 0)^, Size);
end;

function EditFunc(Editor: PEditor; Command: Word; LP: Pointer;
  WP: Word): Integer; external;

const

  CurEd: Pointer = nil;
  EdHandle: HMem = nil;
  SaveBP: Word = 0;

{$L EDMAIN.OBE}
{$L EDPAGES.OBE}
{$L EDCURSOR.OBE}
{$L EDDELETE.OBE}
{$L EDRW.OBE}
{$L EDSEARCH.OBE}
{$L EDMATCH.OBE}
{$L EDCHANGE.OBE}
{$L EDINDENT.OBE}
{$L EDINSERT.OBE}
{$L EDPOS.OBE}
{$L EDTOGGLE.OBE}
{$L EDBLOCK.OBE}
{$L EDREDRAW.OBE}
{$L EDKEYS.OBE}
{$L EDREPL.OBE}
{$L EDUNDO.OBE}
{$L EDLINES.OBE}

end.
