Offs	equ	(word ptr 0)
Segm	equ	(word ptr 2)
X	equ	(word ptr 0)
Y	equ	(word ptr 2)
B0	equ	(byte ptr 0)
B1	equ	(byte ptr 1)
W0	equ	(word ptr 0)
W2	equ	(word ptr 2)

VMemPageSize	equ	4096
VMemLimit	equ	4096

erLineTooLong	equ	1
erTooManyLines	equ	2
erNoVirtMem	equ	4
erHeapFailure	equ	8
erReadError	equ	10h
erFileTooLarge	equ	20h

rfCurLine	equ	4
rfBelowCurLine	equ	8
rfBelowPrevLine	equ	10h
rfFullScreen	equ	20h
rfPageChanged	equ	40h
rfAny		equ	rfCurLine+rfBelowCurLine+rfBelowPrevLine+rfFullScreen

emShow		equ	1
emUpdate	equ	2
emLocked	equ	4

eoOverwrite	equ	1
eoAutoIndent	equ	2
eoUseTab	equ	4
eoBlockHidden	equ	8
eoAutoOutdent	equ	20h
eoUndoDisabled	equ	40h
eoNoTruncate	equ	80h
eoOptimalFill	equ	100h
eoRoamingCursor	equ	200h

esBackward	equ	1
esEntireScope	equ	2
esSelectedText	equ	4
esIgnoreCase	equ	8
esRegularExprs	equ	10h
esWholeWordsOnly	equ	20h

PageInfo	struc
	PageLength	dw	?
	LinesInPage	dw	?
	FirstLineNumber	dw	?
	PageHandle	dd	?
		ends

PageHeader	struc
	CurLineOfs	dw	?
	CurLineNum	dw	?
		ends

LineHeader	struc
	LineLength	dw	?
	LineNumber	dw	?
	LineDummy	db	?
		ends

TEBpt	struc
	Pos	dd	?
	Color	dw	?
	ends

MaxBpt	equ	16

TEBptArray	struc
	Count	dw	?
	EBpt	TEBpt	MaxBpt dup(?)
	Bpt	dd	MaxBpt dup(?)
		ends

TCommandTable	struc
	CTLen		dw	?
	Matches		dw	?
	Delimiters	db	32 dup(?)
	ControlChars	db	32 dup(?)
	Macros		dw	?,?
		ends

TEditor struc
	EditView	dd	?
	CommandTable	dd	?
	WindowWidth	dw	?
	WindowHeight	dw	?
	PrevScreenRow	dw	?
	PrevScreenCol	dw	?
	Colors		db	4 dup(?)
	RedrawFlags	dw	?
	Options		dw	?
	TabSize		dw	?
	Handle		dd	?
	SmartBounds	db	2 dup(?)
	LineLens	db	50 dup(?)
	UndoLen		dw	?
	UndoPtr		dd	?
	UndoBufLen	dw	?
	ErrorProc	dd	?
	ScreenPos	dd	?
	CursorPos	dd	?
	PrevPos		dd	?
	BlockBeg	dd	?
	BlockEnd	dd	?
	TempPos		dd	?
	TempPos2	dd	?
	UndoBeg		dd	?
	UndoEnd		dd	?
	Marks		dd	10 dup(?)
	FileRec		dd	?
	Next		dd	?
	ends

EditSegment     struc
	EdStruct	TEditor	?
	Modified	db	?
	Perverted	db	?
	ExecBar		dw	?
	RedrawLine	dw	?
	PageSize	dw	?
	Dummy1		dd	?
	BreakPts	dd	?
	PendingChar	db	?
	SecondByte	db	?
	PageTblSize	dw	?
	LastPage	dw	?
	CurPage		dw	?
	CPFirstLine	dw	?
	SearchPos	dw	?
	LockedPage	dd	?
	SubTblPtr	dw	?
	ReturnCode	dw	?
	Errors		db	?
	Dummy2		db	3 dup(?)
	VFileOffset	dd	?
	VFilePoint	dd	?
	VFileStack	dd	8 dup(?)
	EParam		dd	?
	CParam		dw	?
	LParam		dd	?
	WParam		dw	?
	Dummy3		dd	?
	PageTbl		db	?
		ends

TFileRec	struc
	Editor		dd	?
	Time		dd	?
	FRNext		dd	?
	FileName	db	80 dup(?)
	Breakpoints	TEBptArray	?
		ends

Argm	macro	Symbol,SType,Count
	local	Offset
	@AP = @AP + SType * Count
	Offset = @AP
Symbol	equ	(SType ptr [bp+@AF-Offset])
	endm

@AP = 0
@AF = 0

Loc	macro	Symbol,SType,Count
	local	Offset,S
	@LP = @LP + SType * Count
	Offset = @LP
Symbol	equ	(SType ptr [bp-Offset])
	endm

@LP = 0

Entry	macro	Name,X
	public	Name
Name	proc	far
	push	bp
	mov	bp,sp
	@AF = @AP + 6
	if	@LP ne 0
		sub	sp,@LP
	endif
	ifb	<X>
		Invoke	SetEditDS
	endif
	endm

Exit	macro	Name,X
	mov	sp,bp
	pop	bp
	retf	@AP
	ifb	<X>
		@AP = 0
		@LP = 0
	endif
	endp	Name
	endm

SetTurboDS	macro
	push	ax
	mov	ax,_data
	mov	ds,ax
	pop	ax
	endm

Invoke	macro	Name
	.data
	global	Name:far
	.code
	call	Name
	endm

InvokeJ	macro	Name
	.data
	global	Name:far
	.code
	jmp	Name
	endm

	model	large,pascal
	locals	@@
