uses Objects, Drivers, Views, Menus, Dialogs, TMenu, TStatus, TVars, Reg,
  TStdDlg, Controls, EvalDlg, WatchWin, BptDlg, CpuWin, OutputWn, CalStkWn,
  CompWind, Help, TColors, Config, Context, StrNames, Utils, CompVars, TEdit;

var

  T: TResourceFile;
  CommandTable: TFCommandTable;
  S: TDosStream;

procedure P(S: string; A: PObject);
begin
  T.Put(A, S);
  Dispose(A, Done);
end;

function FormStrings: PStrListMaker;
var
  S: PStrListMaker;
begin
  S := New(PStrListMaker, Init(32768, 1000));
  S^.Put(sMsgBase + mfWarning, 'Warning');
  S^.Put(sMsgBase + mfError, 'Error');
  S^.Put(sMsgBase + mfInformation, 'Information');

  S^.Put(sOutOfMemory, 'There is not enough memory available to complete operation.');
  S^.Put(sNoResource, 'Resource not found: %s.');
  S^.Put(sValueNotInRange, 'Value not within the valid range. Valid range is:'^M^J^C'%d - %d');
  S^.Put(sInvalidFileName, 'Invalid file name or extension.');
  S^.Put(sTurboTplNotFound, 'TURBO.TPL not found.');
  S^.Put(sInvalidTurboTpl, 'TURBO.TPL is invalid.');
  S^.Put(sInvalidDir, 'Invalid drive or directory.');
  S^.Put(sDosShellPrompt, 'Type EXIT to return to Turbo Pascal...');
  S^.Put(sTerminateDebugging, 'DOS shell will terminate current debugging session.');
  S^.Put(sInvalidAddress, 'Invalid address value. Format is "xxxx:yyyy".');
  S^.Put(sErrorUpdatingTurboExe, 'Error updating TURBO.EXE file.');
  S^.Put(sTurboTpl, 'TURBO.TPL');
  S^.Put(sStartupOptions, 'Changes are written directly to TURBO.EXE and do not take effect until you reload the IDE.');
  S^.Put(sTileError, 'Tile/Cascade area too small to complete request.');
  S^.Put(sNoMemoryForCommandTable, 'Not enough memory to load new editor key bindings. Old bindings retained.');
  S^.Put(sInvalidHeapLimits, 'Low heap limit greater than high heap limit.');
  S^.Put(sNoMemoryForTurboTpl, 'Not enough memory to load TURBO.TPL.');

  S^.Put(sSetInvalidBpt, 'Invalid breakpoint in %s on line %d. Set breakpoint anyway?');
  S^.Put(sTooManyBpts, 'Too many breakpoints.');
  S^.Put(sClearInvalidBpt, 'Invalid breakpoint(s) encountered. Clear all invalid breakpoints?');
  S^.Put(sNoDebugInfo, 'No debug info for program entry point. Run anyway?');
  S^.Put(sNoCodeForLine, 'No code generated for this line.');
  S^.Put(sFatalBreak, 'User break. Program terminated.');
  S^.Put(sUserBreak, 'User break in %s line %d.');
  S^.Put(sLineTooComplex, 'Line too complex for step or trace.');
  S^.Put(sNoMemToRun, 'Not enough memory to run program.');
  S^.Put(sCantLoadExe, 'Cannot load EXE file.');
  S^.Put(sCantRunUnit, 'Cannot run a unit.');
  S^.Put(sInvalidCondition, 'Invalid condition: %s.');
  S^.Put(sConditionTrue, 'Conditional breakpoint "%s" in %s line %d is true.');
  S^.Put(sSourceModified, 'Source has been modified. Rebuild?');
  S^.Put(sProcNotFound, 'Procedure not found.');
  S^.Put(sTooManyBptsInFile, 'Too many breakpoints in file.');
  S^.Put(sPressAnyKeyToReturn, 'Press any key to return...');
  S^.Put(sCantFindSource, 'Cannot find source file. Source position is %s line %d.');
  S^.Put(sErrorAddressNotFound, 'Error address not found.');

  S^.Put(sError, 'Error %d: %s.');
  S^.Put(sErrorParam, 'Error %d: %s (%s).');

  S^.Put(sErrorBase, 'Target address found');
  S^.Put(sErrorBase + 1, 'Out of memory');
  S^.Put(sErrorBase + 2, 'Identifier expected');
  S^.Put(sErrorBase + 3, 'Unknown identifier');
  S^.Put(sErrorBase + 4, 'Duplicate identifier');
  S^.Put(sErrorBase + 5, 'Syntax error');
  S^.Put(sErrorBase + 6, 'Error in real constant');
  S^.Put(sErrorBase + 7, 'Error in integer constant');
  S^.Put(sErrorBase + 8, 'String constant exceeds line');
  S^.Put(sErrorBase + 9, 'Too many nested files');
  S^.Put(sErrorBase + 10, 'Unexpected end of file');
  S^.Put(sErrorBase + 11, 'Line too long');
  S^.Put(sErrorBase + 12, 'Type identifier expected');
  S^.Put(sErrorBase + 13, 'Too many open files');
  S^.Put(sErrorBase + 14, 'Invalid filename');
  S^.Put(sErrorBase + 15, 'File not found');
  S^.Put(sErrorBase + 16, 'Disk full');
  S^.Put(sErrorBase + 17, 'Invalid compiler directive');
  S^.Put(sErrorBase + 18, 'Too many files');
  S^.Put(sErrorBase + 19, 'Undefined type in pointer definition');
  S^.Put(sErrorBase + 20, 'Variable identifier expected');
  S^.Put(sErrorBase + 21, 'Error in type');
  S^.Put(sErrorBase + 22, 'Structure too large');
  S^.Put(sErrorBase + 23, 'Set base type out of range');
  S^.Put(sErrorBase + 24, 'File components may not be files or objects');
  S^.Put(sErrorBase + 25, 'Invalid string length');
  S^.Put(sErrorBase + 26, 'Type mismatch');
  S^.Put(sErrorBase + 27, 'Invalid subrange base type');
  S^.Put(sErrorBase + 28, 'Lower bound greater than upper bound');
  S^.Put(sErrorBase + 29, 'Ordinal type expected');
  S^.Put(sErrorBase + 30, 'Integer constant expected');
  S^.Put(sErrorBase + 31, 'Constant expected');
  S^.Put(sErrorBase + 32, 'Integer or real constant expected');
  S^.Put(sErrorBase + 33, 'Pointer type identifier expected');
  S^.Put(sErrorBase + 34, 'Invalid function result type');
  S^.Put(sErrorBase + 35, 'Label identifier expected');
  S^.Put(sErrorBase + 36, 'BEGIN expected');
  S^.Put(sErrorBase + 37, 'END expected');
  S^.Put(sErrorBase + 38, 'Integer expression expected');
  S^.Put(sErrorBase + 39, 'Ordinal expression expected');
  S^.Put(sErrorBase + 40, 'Boolean expression expected');
  S^.Put(sErrorBase + 41, 'Operand types do not match operator');
  S^.Put(sErrorBase + 42, 'Error in expression');
  S^.Put(sErrorBase + 43, 'Illegal assignment');
  S^.Put(sErrorBase + 44, 'Field identifier expected');
  S^.Put(sErrorBase + 45, 'Object file too large');
  S^.Put(sErrorBase + 46, 'Undefined external');
  S^.Put(sErrorBase + 47, 'Invalid object file record');
  S^.Put(sErrorBase + 48, 'Code segment too large');
  S^.Put(sErrorBase + 49, 'Data segment too large');
  S^.Put(sErrorBase + 50, 'DO expected');
  S^.Put(sErrorBase + 51, 'Invalid PUBLIC definition');
  S^.Put(sErrorBase + 52, 'Invalid EXTRN definition');
  S^.Put(sErrorBase + 53, 'Too many EXTRN definitions');
  S^.Put(sErrorBase + 54, 'OF expected');
  S^.Put(sErrorBase + 55, 'INTERFACE expected');
  S^.Put(sErrorBase + 56, 'Invalid relocatable reference');
  S^.Put(sErrorBase + 57, 'THEN expected');
  S^.Put(sErrorBase + 58, 'TO or DOWNTO expected');
  S^.Put(sErrorBase + 59, 'Undefined forward');
  S^.Put(sErrorBase + 60, 'Cannot be modified');
  S^.Put(sErrorBase + 61, 'Invalid type cast');
  S^.Put(sErrorBase + 62, 'Division by zero');
  S^.Put(sErrorBase + 63, 'Invalid file type');
  S^.Put(sErrorBase + 64, 'Cannot Read or Write variables of this type');
  S^.Put(sErrorBase + 65, 'Pointer variable expected');
  S^.Put(sErrorBase + 66, 'String variable expected');
  S^.Put(sErrorBase + 67, 'String expression expected');
  S^.Put(sErrorBase + 68, 'Circular unit reference');
  S^.Put(sErrorBase + 69, 'Unit name mismatch');
  S^.Put(sErrorBase + 70, 'Unit version mismatch');
  S^.Put(sErrorBase + 71, '');
  S^.Put(sErrorBase + 72, 'Unit file format error');
  S^.Put(sErrorBase + 73, 'IMPLEMENTATION expected');
  S^.Put(sErrorBase + 74, 'Constant and CASE types do not match');
  S^.Put(sErrorBase + 75, 'Record variable expected');
  S^.Put(sErrorBase + 76, 'Constant out of range');
  S^.Put(sErrorBase + 77, 'File variable expected');
  S^.Put(sErrorBase + 78, 'Pointer expression expected');
  S^.Put(sErrorBase + 79, 'Integer or real expression expected');
  S^.Put(sErrorBase + 80, 'Label not within current block');
  S^.Put(sErrorBase + 81, 'Label already defined');
  S^.Put(sErrorBase + 82, 'Undefined label in preceding statement part');
  S^.Put(sErrorBase + 83, 'Invalid @ argument');
  S^.Put(sErrorBase + 84, 'UNIT expected');
  S^.Put(sErrorBase + 85, '";" expected');
  S^.Put(sErrorBase + 86, '":" expected');
  S^.Put(sErrorBase + 87, '"," expected');
  S^.Put(sErrorBase + 88, '"(" expected');
  S^.Put(sErrorBase + 89, '")" expected');
  S^.Put(sErrorBase + 90, '"=" expected');
  S^.Put(sErrorBase + 91, '":=" expected');
  S^.Put(sErrorBase + 92, '"[" or "(." expected');
  S^.Put(sErrorBase + 93, '"]" or ".)" expected');
  S^.Put(sErrorBase + 94, '"." expected');
  S^.Put(sErrorBase + 95, '".." expected');
  S^.Put(sErrorBase + 96, 'Too many variables');
  S^.Put(sErrorBase + 97, 'Invalid FOR control variable');
  S^.Put(sErrorBase + 98, 'Integer variable expected');
  S^.Put(sErrorBase + 99, 'File and procedure types are not allowed here');
  S^.Put(sErrorBase + 100, 'String length mismatch');
  S^.Put(sErrorBase + 101, 'Invalid ordering of fields');
  S^.Put(sErrorBase + 102, 'String constant expected');
  S^.Put(sErrorBase + 103, 'Integer or real variable expected');
  S^.Put(sErrorBase + 104, 'Ordinal variable expected');
  S^.Put(sErrorBase + 105, 'INLINE error');
  S^.Put(sErrorBase + 106, 'Character expression expected');
  S^.Put(sErrorBase + 107, 'Too many relocation items');
  S^.Put(sErrorBase + 108, '');
  S^.Put(sErrorBase + 109, '');
  S^.Put(sErrorBase + 110, '');
  S^.Put(sErrorBase + 111, 'Compilation aborted');
  S^.Put(sErrorBase + 112, 'CASE constant out of range');
  S^.Put(sErrorBase + 113, 'Error in statement');
  S^.Put(sErrorBase + 114, 'Cannot call an interrupt procedure');
  S^.Put(sErrorBase + 115, '');
  S^.Put(sErrorBase + 116, 'Must be in 8087 mode to compile this');
  S^.Put(sErrorBase + 117, 'Target address not found');
  S^.Put(sErrorBase + 118, 'Include files are not allowed here');
  S^.Put(sErrorBase + 119, '');
  S^.Put(sErrorBase + 120, 'NIL expected');
  S^.Put(sErrorBase + 121, 'Invalid qualifier');
  S^.Put(sErrorBase + 122, 'Invalid variable reference');
  S^.Put(sErrorBase + 123, 'Too many symbols');
  S^.Put(sErrorBase + 124, 'Statement part too large');
  S^.Put(sErrorBase + 125, '');
  S^.Put(sErrorBase + 126, 'Files must be var parameters');
  S^.Put(sErrorBase + 127, 'Too many conditional symbols');
  S^.Put(sErrorBase + 128, 'Misplaced conditional directive');
  S^.Put(sErrorBase + 129, 'ENDIF directive missing');
  S^.Put(sErrorBase + 130, 'Error in initial conditional defines');
  S^.Put(sErrorBase + 131, 'Header does not match previous definition');
  S^.Put(sErrorBase + 132, 'Critical disk error');
  S^.Put(sErrorBase + 133, 'Cannot evaluate this expression');
  S^.Put(sErrorBase + 134, 'Expression incorrectly terminated');
  S^.Put(sErrorBase + 135, 'Invalid format specifier');
  S^.Put(sErrorBase + 136, 'Invalid indirect reference');
  S^.Put(sErrorBase + 137, 'Structured variables are not allowed here');
  S^.Put(sErrorBase + 138, 'Cannot evaluate without System unit');
  S^.Put(sErrorBase + 139, 'Cannot access this symbol');
  S^.Put(sErrorBase + 140, 'Invalid floating point operation');
  S^.Put(sErrorBase + 141, 'Cannot compile overlays to memory');
  S^.Put(sErrorBase + 142, 'Procedure or function variable expected');
  S^.Put(sErrorBase + 143, 'Invalid procedure or function reference');
  S^.Put(sErrorBase + 144, 'Cannot overlay this unit');
  S^.Put(sErrorBase + 145, 'Too many nested scopes');
  S^.Put(sErrorBase + 146, 'File access denied');
  S^.Put(sErrorBase + 147, 'Object type expected');
  S^.Put(sErrorBase + 148, 'Local object types are not allowed');
  S^.Put(sErrorBase + 149, 'VIRTUAL expected');
  S^.Put(sErrorBase + 150, 'Method identifier expected');
  S^.Put(sErrorBase + 151, 'Virtual constructors are not allowed');
  S^.Put(sErrorBase + 152, 'Constructor identifier expected');
  S^.Put(sErrorBase + 153, 'Destructor identifier expected');
  S^.Put(sErrorBase + 154, 'Fail only allowed within constructors');
  S^.Put(sErrorBase + 155, 'Invalid combination of opcode and operands');
  S^.Put(sErrorBase + 156, 'Memory reference expected');
  S^.Put(sErrorBase + 157, 'Cannot add or subtract relocatable symbols');
  S^.Put(sErrorBase + 158, 'Invalid register combination');
  S^.Put(sErrorBase + 159, '286/287 instructions are not enabled');
  S^.Put(sErrorBase + 160, 'Invalid symbol reference');
  S^.Put(sErrorBase + 161, 'Code generation error');
  S^.Put(sErrorBase + 162, 'ASM expected');

  S^.Put(sRuntimeErrorBase, 'Runtime error');
  S^.Put(sRuntimeErrorBase + 1, 'Invalid DOS function code');
  S^.Put(sRuntimeErrorBase + 2, 'File not found');
  S^.Put(sRuntimeErrorBase + 3, 'Path not found');
  S^.Put(sRuntimeErrorBase + 4, 'Too many open files');
  S^.Put(sRuntimeErrorBase + 5, 'File access denied');
  S^.Put(sRuntimeErrorBase + 6, 'Invalid file handle');
  S^.Put(sRuntimeErrorBase + 7, '');
  S^.Put(sRuntimeErrorBase + 8, 'Not enough memory');
  S^.Put(sRuntimeErrorBase + 9, '');
  S^.Put(sRuntimeErrorBase + 10, '');
  S^.Put(sRuntimeErrorBase + 11, '');
  S^.Put(sRuntimeErrorBase + 12, 'Invalid file access code');
  S^.Put(sRuntimeErrorBase + 13, '');
  S^.Put(sRuntimeErrorBase + 14, '');
  S^.Put(sRuntimeErrorBase + 15, 'Invalid drive number');
  S^.Put(sRuntimeErrorBase + 16, 'Cannot remove current directory');
  S^.Put(sRuntimeErrorBase + 17, 'Cannot rename across drives');
  S^.Put(sRuntimeErrorBase + 100, 'Disk read error');
  S^.Put(sRuntimeErrorBase + 101, 'Disk write error');
  S^.Put(sRuntimeErrorBase + 102, 'File not assigned');
  S^.Put(sRuntimeErrorBase + 103, 'File not open');
  S^.Put(sRuntimeErrorBase + 104, 'File not open for input');
  S^.Put(sRuntimeErrorBase + 105, 'File not open for output');
  S^.Put(sRuntimeErrorBase + 106, 'Invalid numeric format');
  S^.Put(sRuntimeErrorBase + 150, 'Disk is write-protected');
  S^.Put(sRuntimeErrorBase + 151, '');
  S^.Put(sRuntimeErrorBase + 152, 'Drive not ready');
  S^.Put(sRuntimeErrorBase + 153, '');
  S^.Put(sRuntimeErrorBase + 154, 'CRC error in data');
  S^.Put(sRuntimeErrorBase + 155, '');
  S^.Put(sRuntimeErrorBase + 156, 'Disk seek error');
  S^.Put(sRuntimeErrorBase + 157, '');
  S^.Put(sRuntimeErrorBase + 158, 'Sector not found');
  S^.Put(sRuntimeErrorBase + 159, 'Printer out of paper');
  S^.Put(sRuntimeErrorBase + 160, 'Device write fault');
  S^.Put(sRuntimeErrorBase + 161, 'Device read fault');
  S^.Put(sRuntimeErrorBase + 162, 'Hardware failure');
  S^.Put(sRuntimeErrorBase + 200, 'Division by zero');
  S^.Put(sRuntimeErrorBase + 201, 'Range check error');
  S^.Put(sRuntimeErrorBase + 202, 'Stack overflow error');
  S^.Put(sRuntimeErrorBase + 203, 'Heap overflow error');
  S^.Put(sRuntimeErrorBase + 204, 'Invalid pointer operation');
  S^.Put(sRuntimeErrorBase + 205, 'Floating point overflow');
  S^.Put(sRuntimeErrorBase + 206, 'Floating point underflow');
  S^.Put(sRuntimeErrorBase + 207, 'Invalid floating point operation');
  S^.Put(sRuntimeErrorBase + 208, 'Overlay manager not installed');
  S^.Put(sRuntimeErrorBase + 209, 'Overlay file read error');
  S^.Put(sRuntimeErrorBase + 210, 'Object not initialized');
  S^.Put(sRuntimeErrorBase + 211, 'Call to abstract method');
  S^.Put(sRuntimeErrorBase + 212, 'Stream registration error');
  S^.Put(sRuntimeErrorBase + 213, 'Collection index out of range');
  S^.Put(sRuntimeErrorBase + 214, 'Collection overflow error');

  S^.Put(sProgramStatusBase + psNoProgram, 'No program');
  S^.Put(sProgramStatusBase + psCompiled, '%s compiled');
  S^.Put(sProgramStatusBase + psRunning, '%s running');
  S^.Put(sProgramStatusBase + psTerminated, '%s terminated, exit code %d');

  S^.Put(sMonthBase + 1, 'Jan');
  S^.Put(sMonthBase + 2, 'Feb');
  S^.Put(sMonthBase + 3, 'Mar');
  S^.Put(sMonthBase + 4, 'Apr');
  S^.Put(sMonthBase + 5, 'May');
  S^.Put(sMonthBase + 6, 'Jun');
  S^.Put(sMonthBase + 7, 'Jul');
  S^.Put(sMonthBase + 8, 'Aug');
  S^.Put(sMonthBase + 9, 'Sep');
  S^.Put(sMonthBase + 10, 'Oct');
  S^.Put(sMonthBase + 11, 'Nov');
  S^.Put(sMonthBase + 12, 'Dec');
  S^.Put(sDirectoryLine, ' %-12s %-9d %3s %2d, %4d  %2d:%02d%cm');
  S^.Put(sFileLine, ' %-12s %-9s %3s %2d, %4d  %2d:%02d%cm');
  S^.Put(sDirectory, 'Directory');
  S^.Put(sTooManyFiles, 'Too many files to display.');

  S^.Put(sLoading, 'Loading %s.');
  S^.Put(sSaving, 'Saving %s.');

  S^.Put(sWatchString, '%c%s: %s');
  S^.Put(sTooManyWatches, 'Too many watches.');

  S^.Put(sDestinationBase, 'Memory');
  S^.Put(sDestinationBase + cfDisk, 'Disk');

  S^.Put(sHelpFileName, 'TURBO.HLP');
  S^.Put(sNoHelpFile, 'Cannot locate help file, TURBO.HLP.');
  S^.Put(sInvalidHelpFile, 'Invalid help file, TURBO.HLP.');
  S^.Put(sHelpSign1, 'TURBO PASCAL HELP FILE.');
  S^.Put(sHelpSign2, '$*$* &&&&$*$');

  S^.Put(sClipboard, 'Clipboard');
  S^.Put(sEditorErrorBase + eeLineTooLong, 'Line too long, truncated.');
  S^.Put(sEditorErrorBase + eeTooManyLines, 'Too many lines, ignoring extra.');
  S^.Put(sEditorErrorBase + eeNoVirtMem, 'Not enough virtual memory for operation.');
  S^.Put(sEditorErrorBase + eeHeapFailure, 'Heap failure.');
  S^.Put(sEditorErrorBase + eeReadError, 'Read error, file truncated.');
  S^.Put(sEditorErrorBase + eeFileTooLarge, 'File too large to complete operation.');
  S^.Put(sStringNotFound, 'Search string not found.');
  S^.Put(sQueryReplace, 'Replace this occurrence?');
  S^.Put(sFileModified, '%s has been modified. Save?');
  S^.Put(sFileNotFound, 'File %s not found.');
  S^.Put(sCantCreate, 'File %s could not be created.');
  S^.Put(sReadError, 'Error encountered reading file %s.');
  S^.Put(sUnableOpen, 'Unable to open file %s.');
  S^.Put(sUnableBackup, 'Unable to create backup file for %s.');
  S^.Put(sFileExists, 'File %s already exists. Overwrite?');
  S^.Put(sReadOnly, 'File %s is read only.');

  S^.Put(sConfigFileName, 'TURBO.TP');
  S^.Put(sInvalidConfig, 'Invalid configuration file.');
  S^.Put(sInvalidDesktop, 'Invalid desk top file.');
  S^.Put(sReadingConfig, 'Reading configuration file.');
  S^.Put(sWritingConfig, 'Writing configuration file.');
  S^.Put(sReadingDesktop, 'Reading desk top file.');
  S^.Put(sWritingDesktop, 'Writing desk top file.');
  S^.Put(sCantCreateDesktop, 'Unable to create desk top file.');
  S^.Put(sCantCreateConfig, 'Unable to create configuration file.');
  S^.Put(sDiskFull, 'Disk full.');
  S^.Put(sErrorWritingConfig, 'Error writing configuration file.');
  S^.Put(sErrorReadingConfig, 'Error reading configuration file.');
  S^.Put(sCantOpenConfig, 'Unable to open configuration file.');
  S^.Put(sErrorWritingDesktop, 'Error writing configuration file.');
  S^.Put(sErrorReadingDesktop, 'Error reading desktop file.');

  S^.Put(sStatusBase + hcAboutMenu, 'System commands');
  S^.Put(sStatusBase + hcFileMenu, 'File management commands (Open, New, Save, etc.)');
  S^.Put(sStatusBase + hcEditMenu, 'Cut-and-paste editing commands');
  S^.Put(sStatusBase + hcSearchMenu, 'Text and error search commands');
  S^.Put(sStatusBase + hcRunMenu, 'Execute or single-step through a program');
  S^.Put(sStatusBase + hcCompileMenu, 'Compile to disk or memory');
  S^.Put(sStatusBase + hcDebugMenu, 'Evaluate expressions, modify data, set breakpoints and watches');
  S^.Put(sStatusBase + hcOptionsMenu, 'Set defaults for compiler, editor, mouse, debugger, etc.');
  S^.Put(sStatusBase + hcWindowMenu, 'Open, arrange, and list windows');
  S^.Put(sStatusBase + hcHelpMenu, 'Get online help');
  S^.Put(sStatusBase + hcAboutItem, 'Show version and copyright information');
  S^.Put(sStatusBase + hcRefreshDisplayItem, 'Redraw the screen');
  S^.Put(sStatusBase + hcClearDesktopItem, 'Close all windows on the desktop, clear history lists');
  S^.Put(sStatusBase + hcOpenItem, 'Locate and open a file in an Edit window');
  S^.Put(sStatusBase + hcNewItem, 'Create a new file in a new Edit window');
  S^.Put(sStatusBase + hcSaveItem, 'Save the file in the active Edit window');
  S^.Put(sStatusBase + hcSaveAsItem, 'Save the current file under a different name, directory, or drive');
  S^.Put(sStatusBase + hcSaveAllItem, 'Save all modified files');
  S^.Put(sStatusBase + hcChangeDirItem, 'Choose a new default directory');
  S^.Put(sStatusBase + hcPrintItem, 'Print the contents of the active Edit window');
  S^.Put(sStatusBase + hcGetInfoItem, 'Show status information');
  S^.Put(sStatusBase + hcDosShellItem, 'Temporarily exit to DOS');
  S^.Put(sStatusBase + hcExitItem, 'Exit Turbo Pascal');
  S^.Put(sStatusBase + hcRestoreLineItem, 'Cancel edits to the current line in active Edit window');
  S^.Put(sStatusBase + hcCutItem, 'Remove the selected text and put it in the Clipboard');
  S^.Put(sStatusBase + hcCopyItem, 'Copy the selected text into the Clipboard');
  S^.Put(sStatusBase + hcPasteItem, 'Insert selected text from the Clipboard at the cursor position');
  S^.Put(sStatusBase + hcCopyExampleItem, 'Copy program example from the Help window into the Clipboard');
  S^.Put(sStatusBase + hcShowClipboardItem, 'Open the Clipboard window');
  S^.Put(sStatusBase + hcClearItem, 'Delete the selected text');
  S^.Put(sStatusBase + hcFindItem, 'Search for text');
  S^.Put(sStatusBase + hcReplaceItem, 'Search for text and replace it with new text');
  S^.Put(sStatusBase + hcSearchAgainItem, 'Repeat the last Find or Replace command');
  S^.Put(sStatusBase + hcGotoLineNumberItem, 'Move the cursor to a specified line number');
  S^.Put(sStatusBase + hcFindProcedureItem, 'Search for a procedure or function declaration while debugging');
  S^.Put(sStatusBase + hcFindErrorItem, 'Move the cursor to the position of a runtime error');
  S^.Put(sStatusBase + hcRunItem, 'Run the current program');
  S^.Put(sStatusBase + hcProgramResetItem, 'Halt debugging session and release memory');
  S^.Put(sStatusBase + hcGotoCursorItem, 'Run program from the run bar to the cursor position');
  S^.Put(sStatusBase + hcTraceIntoItem, 'Execute next statement, stopping within the current procedure');
  S^.Put(sStatusBase + hcStepOverItem, 'Execute next statement, skipping over the current procedure');
  S^.Put(sStatusBase + hcParametersItem, 'Set command-line parameters to be passed to program');
  S^.Put(sStatusBase + hcCompileItem, 'Compile source file');
  S^.Put(sStatusBase + hcMakeItem, 'Rebuild source file and all other files that have been modified');
  S^.Put(sStatusBase + hcBuildItem, 'Rebuild source file and all other files');
  S^.Put(sStatusBase + hcDestinationItem, 'Specify whether source file is compiled to memory or to disk');
  S^.Put(sStatusBase + hcPrimaryFileItem, 'Define the file that is the focus of Make and Build');
  S^.Put(sStatusBase + hcEvaluateItem, 'Evaluate a variable or expression and display or modify the value');
  S^.Put(sStatusBase + hcWatchesSubMenu, 'Add, delete, and edit expressions in the watch window');
  S^.Put(sStatusBase + hcToggleBreakpointItem, 'Set or clear an unconditional breakpoint at the cursor position');
  S^.Put(sStatusBase + hcBreakpointsItem, 'Set conditional breakpoints, view and edit breakpoints');
  S^.Put(sStatusBase + hcAddWatchItem, 'Insert a watch expression into the Watch window');
  S^.Put(sStatusBase + hcDeleteWatchItem, 'Remove the current watch expression from the Watch window');
  S^.Put(sStatusBase + hcEditWatchItem, 'Edit the current watch expression in the Watch window');
  S^.Put(sStatusBase + hcRemoveAllWatchesItem, 'Delete all watch expressions from the Watch window');
  S^.Put(sStatusBase + hcCompilerOptionsItem, 'Set default compiler directives and conditional defines');
  S^.Put(sStatusBase + hcMemorySizesItem, 'Set default stack and heap sizes for generated programs');
  S^.Put(sStatusBase + hcLinkerOptionsItem, 'Set linker options (link buffer; .MAP file options)');
  S^.Put(sStatusBase + hcDebuggerOptionsItem, 'Set debugger options (standalone, integrated, display swapping)');
  S^.Put(sStatusBase + hcDirectoriesItem, 'Set paths for units, include files, OBJs, and generated files');
  S^.Put(sStatusBase + hcEnvironmentSubMenu, 'Specify environment settings');
  S^.Put(sStatusBase + hcSaveOptionsItem, 'Save all the settings you''ve made in the Options menu');
  S^.Put(sStatusBase + hcRetrieveOptionsItem, 'Load options file previously created with Save Options');
  S^.Put(sStatusBase + hcPreferencesItem, 'Specify desktop settings');
  S^.Put(sStatusBase + hcEditorItem, 'Specify editor settings');
  S^.Put(sStatusBase + hcMouseItem, 'Specify mouse settings');
  S^.Put(sStatusBase + hcStartupItem, 'Permanently change default startup options');
  S^.Put(sStatusBase + hcColorsItem, 'Customize IDE colors for windows, menus, etc.');
  S^.Put(sStatusBase + hcResizeItem, 'Change the size or position of the active window');
  S^.Put(sStatusBase + hcZoomItem, 'Enlarge or restore the size of the active window');
  S^.Put(sStatusBase + hcTileItem, 'Arrange windows on desktop by tiling');
  S^.Put(sStatusBase + hcCascadeItem, 'Arrange windows on desktop by cascading');
  S^.Put(sStatusBase + hcNextItem, 'Make the next window active');
  S^.Put(sStatusBase + hcPreviousItem, 'Make the previous window active');
  S^.Put(sStatusBase + hcCloseItem, 'Close the active window');
  S^.Put(sStatusBase + hcWatchItem, 'Open the Watch window');
  S^.Put(sStatusBase + hcRegisterItem, 'Open the Register window');
  S^.Put(sStatusBase + hcOutputItem, 'Open the Output window');
  S^.Put(sStatusBase + hcCallStackItem, 'Show the procedures the program called to reach this point');
  S^.Put(sStatusBase + hcUserScreenItem, 'Switch to the full-screen user output');
  S^.Put(sStatusBase + hcWindowListItem, 'Show a list of all open windows');
  S^.Put(sStatusBase + hcContentsItem, 'Show table of contents for online Help');
  S^.Put(sStatusBase + hcIndexItem, 'Show index for online Help');
  S^.Put(sStatusBase + hcTopicSearchItem, 'Display help on the word at the cursor');
  S^.Put(sStatusBase + hcPreviousTopicItem, 'Redisplay the last-viewed online Help screen');
  S^.Put(sStatusBase + hcHelpOnHelpItem, 'How to use online Help');
  S^.Put(sStatusBase + hcOkButton, 'Accept the settings in this dialog box');
  S^.Put(sStatusBase + hcCnlButton, 'Close the dialog box without making any changes');
  S^.Put(sStatusBase + hcAboutDialog, 'Welcome to Turbo Pascal. Press Enter to close this dialog box');
  S^.Put(sStatusBase + hcOpenFileDialogBase, 'Enter directory path and file mask');
  S^.Put(sStatusBase + hcOpenFileDialogBase + 1, 'Type for incremental search: lower for files, upper for directories');
  S^.Put(sStatusBase + hcOpenFileDialogBase + 2, 'Open the specified file into a new editor window');
  S^.Put(sStatusBase + hcOpenFileDialogBase + 3, 'Load the specified file into the active editor window');
  S^.Put(sStatusBase + hcOpenFileDialogBase + 4, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcSaveFileAsDialogBase, 'Enter directory path and file mask');
  S^.Put(sStatusBase + hcSaveFileAsDialogBase + 1, 'Type for incremental search: lower for files, upper for directories');
  S^.Put(sStatusBase + hcSaveFileAsDialogBase + 2, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcDirectoryName, 'Enter drive and/or directory path');
  S^.Put(sStatusBase + hcDirectoryTree, 'Use cursor keys to navigate through directory tree');
  S^.Put(sStatusBase + hcChDirButton, 'Change to the specified directory');
  S^.Put(sStatusBase + hcRevertButton, 'Return to the original directory');
  S^.Put(sStatusBase + hcChDirDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcWriteBlockDialogBase, 'Enter directory path and file mask');
  S^.Put(sStatusBase + hcWriteBlockDialogBase + 1, 'Type for incremental search: lower for files, upper for directories');
  S^.Put(sStatusBase + hcWriteBlockDialogBase + 2, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcReadBlockDialogBase, 'Enter directory path and file mask');
  S^.Put(sStatusBase + hcReadBlockDialogBase + 1, 'Type for incremental search: lower for files, upper for directories');
  S^.Put(sStatusBase + hcReadBlockDialogBase + 2, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcGetInfoDialog, 'Close this dialog box');
  S^.Put(sStatusBase + hcTextToFind, 'Enter literal text or regular expression to search for');
  S^.Put(sStatusBase + hcFindOptions, 'Case of letters is significant during search');
  S^.Put(sStatusBase + hcFindOptions + 1, 'Consider only whole words during search');
  S^.Put(sStatusBase + hcFindOptions + 2, 'Interpret search text as a regular expression');
  S^.Put(sStatusBase + hcFindOptions + 3, 'Prompt before replacing text after every match');
  S^.Put(sStatusBase + hcFindDirection, 'Search forward from origin');
  S^.Put(sStatusBase + hcFindDirection + 1, 'Search backward from origin');
  S^.Put(sStatusBase + hcFindScope, 'Search from origin to the end of the edit buffer');
  S^.Put(sStatusBase + hcFindScope + 1, 'Search current selected block of Edit window');
  S^.Put(sStatusBase + hcFindOrigin, 'Start search from current cursor position');
  S^.Put(sStatusBase + hcFindOrigin + 1, 'Start search at beginning of scope');
  S^.Put(sStatusBase + hcFindDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcNewText, 'Enter text to replace matching text with');
  S^.Put(sStatusBase + hcChangeAllButton, 'Find all occurrences of the search text and replace them');
  S^.Put(sStatusBase + hcReplaceDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcNewLineNumber, 'Move cursor to specified line number in file');
  S^.Put(sStatusBase + hcGotoLineDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcProcedureName, 'Enter name of procedure or function to locate');
  S^.Put(sStatusBase + hcFindProcedureDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcErrorAddress, 'Find source location corresponding to error address');
  S^.Put(sStatusBase + hcFindErrorDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcParameters, 'Enter command line parameters to be passed to your program');
  S^.Put(sStatusBase + hcParametersDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcPrimaryFileDialogBase, 'Enter directory path and file mask');
  S^.Put(sStatusBase + hcPrimaryFileDialogBase + 1, 'Type for incremental search: lower for files, upper for directories');
  S^.Put(sStatusBase + hcPrimaryFileDialogBase + 2, 'Clear the file primary file name');
  S^.Put(sStatusBase + hcPrimaryFileDialogBase + 3, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcExpression, 'Enter expression to evaluate');
  S^.Put(sStatusBase + hcResult, 'Examine result of expression');
  S^.Put(sStatusBase + hcNewValue, 'Enter new value for expression');
  S^.Put(sStatusBase + hcEvaluateButton, 'Evaluate the expression');
  S^.Put(sStatusBase + hcModifyButton, 'Modify expression');
  S^.Put(sStatusBase + hcEvaluateDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcAddWatchExpression, 'Enter expression to add as watch');
  S^.Put(sStatusBase + hcAddWatchDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcEditWatchExpression, 'Enter new expression for watch');
  S^.Put(sStatusBase + hcEditWatchDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcBreakpointList, 'Use cursor keys to examine list of breakpoints');
  S^.Put(sStatusBase + hcEditBreakpoint, 'Edit the currently selected breakpoint');
  S^.Put(sStatusBase + hcDeleteBreakpoint, 'Delete the currently selected breakpoint');
  S^.Put(sStatusBase + hcViewBreakpoint, 'Position cursor at breakpoint in source code');
  S^.Put(sStatusBase + hcClearAllBreakpoints, 'Delete all breakpoints');
  S^.Put(sStatusBase + hcBreakpointsDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcCondition, 'Enter expression which must be TRUE for breakpoint to take effect');
  S^.Put(sStatusBase + hcPassCount, 'Enter number of times BP conditions must be met before breaking');
  S^.Put(sStatusBase + hcFileName, 'Enter name of module to set breakpoint in');
  S^.Put(sStatusBase + hcLineNumber, 'Enter line number in module to set breakpoint on');
  S^.Put(sStatusBase + hcModifyBreakpointButton, 'Modify the existing breakpoint');
  S^.Put(sStatusBase + hcNewBreakpointButton, 'Create a new breakpoint with the given characteristics');
  S^.Put(sStatusBase + hcEditBreakpointDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcCodeGeneration, 'Force all procedures and functions to use far call model');
  S^.Put(sStatusBase + hcCodeGeneration + 1, 'Enable units to be overlaid');
  S^.Put(sStatusBase + hcCodeGeneration + 2, 'Align variables and typed constants on word boundaries');
  S^.Put(sStatusBase + hcCodeGeneration + 3, 'Generate 80286 instructions');
  S^.Put(sStatusBase + hcRuntimeErrors, 'Generate range-checking code');
  S^.Put(sStatusBase + hcRuntimeErrors + 1, 'Check for stack overflow on entry to procedures and functions');
  S^.Put(sStatusBase + hcRuntimeErrors + 2, 'Generate runtime error if I/O operation fails');
  S^.Put(sStatusBase + hcSyntaxOptions, 'Var string parameter type must be identical to formal parameter type');
  S^.Put(sStatusBase + hcSyntaxOptions + 1, 'Always evaluate all boolean expressions in a statement');
  S^.Put(sStatusBase + hcSyntaxOptions + 2, 'Enable syntax extensions');
  S^.Put(sStatusBase + hcDebuggingOptions, 'Generate information to allow debugging');
  S^.Put(sStatusBase + hcDebuggingOptions + 1, 'Include local symbols in generated debug information');
  S^.Put(sStatusBase + hcNumericProcessing, 'Generate 8087 code for use with math coprocessor or emulator');
  S^.Put(sStatusBase + hcNumericProcessing + 1, 'Use 8087 emulator if math coprocessor is not present');
  S^.Put(sStatusBase + hcConditionalDefines, 'Define conditional compilation symbols');
  S^.Put(sStatusBase + hcCompilerOptionsDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcStackSize, 'Size of your program''s stack segment (between 1024 and 65520)');
  S^.Put(sStatusBase + hcLowHeapLimit, 'Minimum size of heap for your program to run (between 0 and 655360)');
  S^.Put(sStatusBase + hcHighHeapLimit, 'Maximum amount of heap your program will need (between 0 and 655360)');
  S^.Put(sStatusBase + hcMemorySizesDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcMapFile, 'Do not generate a .MAP file');
  S^.Put(sStatusBase + hcMapFile + 1, 'Put memory segment information in .MAP file.');
  S^.Put(sStatusBase + hcMapFile + 2, 'Put public symbols in .MAP file');
  S^.Put(sStatusBase + hcMapFile + 3, 'Put segments, symbols and line numbers in .MAP file');
  S^.Put(sStatusBase + hcLinkBuffer + 1, 'Buffer linking on disk to maximize capacity');
  S^.Put(sStatusBase + hcLinkBuffer, 'Buffer linking in memory to maximize speed');
  S^.Put(sStatusBase + hcLinkerDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcDebuggingMode, 'Include debug info for the integrated debugger');
  S^.Put(sStatusBase + hcDebuggingMode + 1, 'Include debug info for Turbo Debugger');
  S^.Put(sStatusBase + hcDisplaySwapping, 'Don''t let debugger change display windows when running a program');
  S^.Put(sStatusBase + hcDisplaySwapping + 1, 'Swap screens only if the code does screen output');
  S^.Put(sStatusBase + hcDisplaySwapping + 2, 'Swap screens every time a statement executes');
  S^.Put(sStatusBase + hcDebuggingDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcExeTpuDirectory, 'The directory that stores your .EXE, .TPU and .MAP files');
  S^.Put(sStatusBase + hcIncludeDirectories, 'The directories that contain your include files');
  S^.Put(sStatusBase + hcUnitDirectories, 'The directories that contain your unit files');
  S^.Put(sStatusBase + hcObjectDirectories, 'The directories that contain your .OBJ files');
  S^.Put(sStatusBase + hcDirectoriesDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcScreenSizes, 'Use a display of 25 lines by 80 columns');
  S^.Put(sStatusBase + hcScreenSizes + 1, 'Display 43 lines by 80 columns (EGA) or 50 lines by 80 columns (VGA)');
  S^.Put(sStatusBase + hcAutoSave, 'Save modified editor files when you DOS shell, run or debug your code');
  S^.Put(sStatusBase + hcAutoSave + 1, 'Save config file when you quit, DOS shell, run or debug your code');
  S^.Put(sStatusBase + hcAutoSave + 2, 'Save desktop when you quit, DOS shell, run or debug your code');
  S^.Put(sStatusBase + hcDesktopFile, 'Do not save desktop file');
  S^.Put(sStatusBase + hcDesktopFile + 1, 'Save desktop file in current directory');
  S^.Put(sStatusBase + hcDesktopFile + 2, 'Save desktop file in same directory as config file');
  S^.Put(sStatusBase + hcSourceTracking, 'Open new window to track source position during debugging');
  S^.Put(sStatusBase + hcSourceTracking + 1, 'During debugging, always track source position in current window');
  S^.Put(sStatusBase + hcPreferencesDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcEditorOptions, 'Create a backup (.BAK) file whenever you save');
  S^.Put(sStatusBase + hcEditorOptions + 1, 'Editor uses insert mode by default');
  S^.Put(sStatusBase + hcEditorOptions + 2, 'Turn auto-indentation on by default');
  S^.Put(sStatusBase + hcEditorOptions + 3, 'Insert actual tab characters into file');
  S^.Put(sStatusBase + hcEditorOptions + 4, 'Optimally replace consecutive spaces with tabs');
  S^.Put(sStatusBase + hcEditorOptions + 5, 'Backspace uninidents based on previous starting columns');
  S^.Put(sStatusBase + hcEditorOptions + 6, 'Allow cursor to move through tabs one column at a time');
  S^.Put(sStatusBase + hcTabSize, 'Change the number of columns to use for tab width');
  S^.Put(sStatusBase + hcEditorOptionsDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcRightMouseButton, 'Right mouse button does nothing');
  S^.Put(sStatusBase + hcRightMouseButton + 1, 'Selects topic search for indicated word in editor or help window');
  S^.Put(sStatusBase + hcRightMouseButton + 2, 'Runs user program to indicated line');
  S^.Put(sStatusBase + hcRightMouseButton + 3, 'Selects enable/disable or breakpoints');
  S^.Put(sStatusBase + hcRightMouseButton + 4, 'Calls up evaluation dialog');
  S^.Put(sStatusBase + hcRightMouseButton + 5, 'Selects adding expression watches');
  S^.Put(sStatusBase + hcReverseMouseButtons, 'Make the active mouse button the rightmost one, not the leftmost');
  S^.Put(sStatusBase + hcMouseDoubleClick, 'Adjust the double-click speed of your mouse');
  S^.Put(sStatusBase + hcMouseOptionsDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcSaveOptionsDialogBase, 'Specify disk file name for saving configuration options');
  S^.Put(sStatusBase + hcSaveOptionsDialogBase + 1, 'Use cursor keys to examine saved configuration files');
  S^.Put(sStatusBase + hcSaveOptionsDialogBase + 2, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcRetrieveOptionsDialogBase, 'Specify disk file name for loading configuration options');
  S^.Put(sStatusBase + hcRetrieveOptionsDialogBase + 1, 'Use cursor keys to selected a configuration file for loading');
  S^.Put(sStatusBase + hcRetrieveOptionsDialogBase + 2, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcWindowListViewer, 'Use cursor keys to examine windows in window list');
  S^.Put(sStatusBase + hcDeleteWindowButton, 'Remove the selected entry from the window list');
  S^.Put(sStatusBase + hcWindowListDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcStartupOptions, 'Use dual monitors to run IDE and user program on separate displays');
  S^.Put(sStatusBase + hcStartupOptions + 1, 'Save and restore all video RAM for debugging graphics programs');
  S^.Put(sStatusBase + hcStartupOptions + 2, 'Save and restore EGA/VGA palette when debugging graphics programs');
  S^.Put(sStatusBase + hcStartupOptions + 3, 'Slow down IDE video output to prevent "snow" on some CGA cards');
  S^.Put(sStatusBase + hcStartupOptions + 4, 'Use LCD colorset in IDE');
  S^.Put(sStatusBase + hcStartupOptions + 5, 'Use expanded memory (EMS) to improve IDE performance and capacity');
  S^.Put(sStatusBase + hcStartupOptions + 6, 'Load TURBO.TPL at startup');
  S^.Put(sStatusBase + hcWindowHeapSize, 'Adjust IDE internal window heap size');
  S^.Put(sStatusBase + hcEditorHeapSize, 'Adjust IDE internal editor heap size');
  S^.Put(sStatusBase + hcOverlayHeapSize, 'Adjust IDE internal overlay heap size');
  S^.Put(sStatusBase + hcSwapFileDirectory, 'Use a RAM disk or fast drive for IDE swap file');
  S^.Put(sStatusBase + hcStartupOptionsDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcColorGroupList, 'Use cursor keys to select an IDE group and customize its colors');
  S^.Put(sStatusBase + hcColorItemList, 'Use cursor keys to select an item and customize its colors');
  S^.Put(sStatusBase + hcForegroundSelector, 'Use cursor keys to change foreground color of selected item');
  S^.Put(sStatusBase + hcBackgroundSelector, 'Use cursor keys to change background color of selected item');
  S^.Put(sStatusBase + hcMonoSelector, 'Select low intensity text on a monochrome system');
  S^.Put(sStatusBase + hcMonoSelector + 1, 'Select high intensity text on a monochrome system');
  S^.Put(sStatusBase + hcMonoSelector + 2, 'Select underscored text on a monochrome system');
  S^.Put(sStatusBase + hcMonoSelector + 3, 'Select inverse video text on a monochrome system');
  S^.Put(sStatusBase + hcColorsDialog, 'View a help screen about this dialog box');
  S^.Put(sStatusBase + hcYesButton, 'Perform the action');
  S^.Put(sStatusBase + hcNoButton, 'Do not perform the action');
  S^.Put(sStatusBase + hcHelPCrossRefButton, 'View help on highlighted cross reference');
  FormStrings := S;
end;

begin
  RegisterAllTypes;
  RegisterType(RStrListMaker);
  T.Init(New(PDosStream, Init('turbo.tvr', stCreate)));
  P('FullMenuBar', New(PTurboMenuBar, Init));
  P('StatusLine', New(PTurboStatusLine, Init));
  P('ChDirDialog', New(PChDirDialog, Init(hlChangeDir)));
  P('FindDialog', FindDialog);
  P('ReplaceDialog', New(PReplaceDialog, Init));
  P('GotoLineDialog', GotoLineDialog);
  P('FindProcDialog', FindProcDialog);
  P('FindErrorDialog', FindErrorDialog);
  P('ParamsDialog', ParamsDialog);
  P('EvalDialog', New(PEvalDialog, Init));
  P('AddWatchDialog', AddWatchDialog);
  P('EditWatchDialog', EditWatchDialog);
  P('BreakPtDialog', New(PBreakDialog, Init));
  P('EditBreakDialog', New(PEditBreakDialog, Init));
  P('CompilerOptionsDialog', CompilerOptionsDialog);
  P('MemorySizesDialog', New(PSizesDialog, Init));
  P('LinkerDialog', LinkerDialog);
  P('DebuggingDialog', DebuggingDialog);
  P('DirectoriesDialog', DirectoriesDialog);
  P('Strings', FormStrings);
  P('PreferencesDialog', PreferencesDialog);
  P('EditorOptionsDialog', EditorOptionsDialog);
  P('MouseOptionsDialog', New(PMouseDialog, Init));
  P('StartupOptionsDialog',StartupOptionsDialog);
  P('OpenFileDialog', New(PFileDialog, Init('*.PAS', 'Open a File',
    '~N~ame', fdOpenButton + fdReplaceButton, hlOpenFile, hcOpenFileDialogBase)));
  P('SaveAsDialog', New(PFileDialog, Init('*.PAS', 'Save File As',
    '~S~ave file as', fdOkButton, hlSaveFileAs, hcSaveFileAsDialogBase)));
  P('WriteBlockDialog', New(PFileDialog, Init('*.PAS', 'Write Block to File',
    '~W~rite block to', fdOkButton, hlWriteBlock, hcWriteBlockDialogBase)));
  P('ReadBlockDialog',New(PFileDialog, Init('*.PAS', 'Read Block from File',
    '~R~ead block from', fdOkButton, hlReadBlock, hcReadBlockDialogBase)));
  P('MainFileDialog', New(PFileDialog, Init('*.PAS', 'Primary File',
    '~P~rimary program file', fdOkButton + fdClearButton, hlPrimaryFile, hcPrimaryFileDialogBase)));
  P('SaveOptionsDialog', New(PFileDialog, Init('*.TP', 'Save Option',
    '~O~ptions file name', fdOkButton, hlSaveOptions, hcSaveOptionsDialogBase)));
  P('RetrieveOptionsDialog', New(PFileDialog, Init('*.TP', 'Retrieve Options',
    '~O~ptions file name', fdOkButton, hlRetrieveOptions, hcRetrieveOptionsDialogBase)));
  P('WindowList', WindowListDialog);
  P('AboutDialog', AboutDialog);
  P('GetInfoDialog', GetInfoDialog);
  P('CPUWindow', CpuWindow);
  P('WatchWindow', WatchWindow);
  P('OutputWindow', OutputWindow);
  P('CallStackWindow', CallStackWindow);
  P('CompileWindow', New(PCompileWindow, Init));
  P('YesBtn',NewButton(0, 0, 10, '~Y~es', cmYes, bfNormal, hcYesButton));
  P('NoBtn', NewButton(0, 0, 10, '~N~o', cmNo, bfNormal, hcNoButton));
  P('OkBtn', NewButton(0, 0, 10, 'O~K~', cmOk, bfNormal, hcOkButton));
  P('CnlBtn', NewButton(0, 0, 10, 'Cancel', cmCancel, bfNormal, hcCnlButton));
  P('HelpWindow', HelpWindow);
  P('HelpDialog', HelpDialog);
  P('ColorDialog', ColorDialog);
  S.Init('TURBO.CMD', stOpenRead);
  CommandTable.Load(S);
  T.Put(@CommandTable, 'CommandTable');
  S.Done;
  T.Done;
end.
