unit TVars;

interface

uses Objects, Drivers, TDos;

type

  PCharSet = ^TCharSet;
  TCharSet = set of Char;

const

  CopyrightStr = '$*$*$*'#0#53#0#1'PASCAL IDE'#0#0 +
    'Turbo Pascal  Version 6.0  Copyright (c) 1983,90 Borland International'^M^J;

  evEditor     = $400;
  evConfig     = $800;
  evDebugger   = $1000;
  evRightClick = $2000;

  cmFind             =  50;
  cmReplace          =  51;
  cmSearchAgain      =  52;

  cmClearDesktop     =  99;

  cmOpen             = 101;
  cmNew              = 102;
  cmSave             = 103;
  cmSaveAs           = 104;
  cmSaveAll          = 105;
  cmChangeDir        = 106;
  cmPrint            = 107;
  cmGetInfo          = 108;
  cmDosShell         = 109;

  cmRestoreLine      = 111;

  cmCopyExample      = 116;
  cmShowClipboard    = 117;

  cmGoToLineNumber   = 124;
  cmFindProcedure    = 125;
  cmFindError        = 126;

  cmRun              = 131;
  cmProgramReset     = 132;
  cmGoToCursor       = 133;
  cmTraceInto        = 134;
  cmStepOver         = 135;
  cmParameters       = 136;

  cmCompile          = 141;
  cmMake             = 142;
  cmBuild            = 143;
  cmDestination      = 144;
  cmPrimaryFile      = 145;

  cmEvaluate         = 151;
  cmCallStackWindow  = 152;

  cmToggleBreakpoint = 154;
  cmBreakpoints      = 155;
  cmRefreshDisplay   = 156;

  cmAddWatch         = 161;
  cmDeleteWatch      = 162;
  cmEditWatch        = 163;
  cmRemoveAllWatches = 164;

  cmCompilerOptions  = 171;
  cmMemorySizes      = 172;
  cmLinkerOptions    = 173;

  cmDebuggerOptions  = 175;
  cmDirectories      = 176;
  cmSaveOptions      = 177;
  cmRetrieveOptions  = 178;

  cmPreferences      = 181;
  cmEditorOptions    = 182;
  cmMouseOptions     = 183;
  cmStartupOptions   = 184;
  cmColors           = 185;

  cmWatchWindow      = 197;
  cmUserScreen       = 198;
  cmRegisterWindow   = 199;

  cmOutputWindow     = 202;
  cmWindowList       = 203;

  cmHelpContents     = 211;
  cmHelpIndex        = 212;
  cmTopicSearch      = 213;
  cmPreviousTopic    = 214;
  cmHelpOnHelp       = 215;
  cmAbout            = 216;
  cmCrossRef         = 217;

  cmViewSource       = 220;

  cmChangeAll           = 1000;

  cmFindEditor          = 2000;
  cmDirChanged          = 2001;
  cmRefreshInfo         = 2002;
  cmFindCpuWindow       = 2003;
  cmFindWatchWindow     = 2004;
  cmFindOutputWindow    = 2005;
  cmFindCallStackWindow = 2006;
  cmFindHelpWindow      = 2007;
  cmFindBottomLimit     = 2008;
  cmMakeDesktop         = 2009;
  cmUpdateCommandTable  = 2010;
  cmUpdateColors        = 2011;
  cmLastError           = 2030;
  cmHelpOnError         = 2031;

  swNone   = 0;
  swSmart  = 1;
  swAlways = 2;

  asEditorFiles = 1;
  asEnvironment = 2;
  asDesktop     = 4;

  soDualMonitor    = $01;
  soGraphicsSwap   = $02;
  soEgaPaletteSave = $04;
  soSnowCheck      = $08;
  soLcdScreen      = $10;
  soUseEms         = $20;
  soLoadTurboTpl   = $40;

  Arrows = [Hi(kbHome), Hi(kbUp), Hi(kbPgUp), Hi(kbLeft),
    Hi(kbRight), Hi(kbEnd), Hi(kbDown), Hi(kbPgDn), Hi(kbCtrlLeft),
    Hi(kbCtrlRight), Hi(kbCtrlEnd), Hi(kbCtrlPgDn), Hi(kbCtrlHome)];

const

  WordChars : TCharSet = ['$', '.', '0'..'9', 'A'..'Z', '_', 'a'..'z'];
  HelpWordChars : TCharSet = ['$', '.', '0'..'9', 'A'..'Z', '_', 'a'..'z'];

  CopyrightNotice : array[0..Length(CopyrightStr) - 1] of Char = CopyrightStr;

  ConfigFile: PathStr = '';
  MainFile: PathStr = '';

  LcdScreen: Boolean = False;
  LoadTurboTpl: Boolean = True;

  SourceModified : Byte = 0;

  EmsResourceStream: PEmsStream = nil;
  EmsEditorStream: PEmsStream = nil;

  ScreenSwapping: Integer = swSmart;

  RBAction: Integer = 1;
  RBActs: array[0..5] of Word = (
    0,
    cmTopicSearch,
    cmGoToCursor,
    cmToggleBreakpoint,
    cmEvaluate,
    cmAddWatch
  );

  Preferences: record
    ScreenSize: Word;
    SourceTracking: Word;
    AutoSave: Word;
    DesktopFile: Word;
  end = (
    ScreenSize: 0;
    SourceTracking: 0;
    AutoSave: 0;
    DesktopFile: 2
  );

  StartupOptions: record
    CmdOptions: Word;
    WindowHeapSz: Longint;
    EditorHeapSz: Longint;
    OverlayHeapSz: Longint;
    SwapDirectory: DirStr;
  end = (
    CmdOptions: soSnowCheck + soUseEms + soLoadTurboTpl;
    WindowHeapSz: 32;
    EditorHeapSz: 28;
    OverlayHeapSz: 112;
    SwapDirectory: ''
  );

  ErrorShown: Boolean = False;
  ErrorPresent: Boolean = False;
  ErrorFileName: PString = nil;
  ErrorPosition: TPoint = ();
  ErrorNumber: Integer = 0;
  ErrorClass: Integer = 0;
  ErrorParam: Pointer = nil;

var

  Resource: TResourceFile;
  Strings: PStringList;
  TurboExe: PathStr;
  TempFile: PathStr;

implementation

end.
