unit VFiles;

{$O+,F+,S-,X+}

interface

uses TDos;

function  VOpen(var Path: PathStr; Mode: Word): Integer;
procedure VClose(H: Integer);
function  VRead(H: Integer; var Buf; Count: Integer): Integer;
function  VSeek(H: Integer; Pos: Longint; Mode: Word): Longint;
function  VTime(H: Integer): Longint;
function  VFTime(var Path: PathStr): Longint;

implementation

uses VMem, TEdit;

const
  VPages: array[4096..4110] of PFileRec =
    (nil, nil, nil, nil, nil, nil, nil, nil,
     nil, nil, nil, nil, nil, nil, nil);

function VFind(var Path: PathStr): PFileRec;
var
  S: PathStr;
begin
  FExpand(Path, S);
  VFind := FindFile(S);
end;

function VOpen(var Path: PathStr; Mode: Word): Integer;
var
  I: Word;
  H: Integer;
  P: PFileRec;
begin
  if Mode = 0 then
  begin
    P := VFind(Path);
    if P <> nil then
    begin
      for I := 4096 to 4110 do
        if VPages[I] = nil then
        begin
          H := EditFunc(P^.editor, edPushPos, nil, 0);
          VOpen := H;
          if H = 0 then
          begin
            VPages[I] := P;
            VSeek(I, 0, 0);
            VOpen := I;
          end;
          Exit;
        end;
        VOpen := -4;
        Exit;
    end;
  end;
  VOpen := FOpen(Path, Mode);
end;

procedure VClose(H: Integer);
begin
  if H >= 4096 then
  begin
    EditFunc(VPages[H]^.Editor, edPopPos, nil, 0);
    VPages[H] := nil;
  end else
    FClose(H);
end;

function VRead(H: Integer; var Buf; Count: Integer): Integer;
begin
  if H >= 4096 then
    VRead := EditFunc(VPages[H]^.Editor, edGetText, @Buf, Count)
  else
    VRead := FRead(H, Buf, Count);
end;

function VSeek(H: Integer; Pos: Longint; Mode: Word): Longint;
begin
  if H >= 4096 then
  begin
    EditFunc(VPages[H]^.Editor, edSeekPos, Pointer(Pos), Mode);
    VSeek := PEditSegment(UseHandle(VPages[H]^.Editor^.Handle))^.VFileOffset;
  end else
    VSeek := FSeek(H, Pos, Mode);
end;

function VTime(H: Integer): Longint;
begin
  if H >= 4096 then
    VTime := VPages[H]^.Time
  else
    VTime := GetFTime(H);
end;

function VFTime(var Path: PathStr): Longint;
var
  P: PFileRec;
begin
  P := VFind(Path);
  if P <> nil then
    VFTime := P^.Time
  else
    VFTime := GetFileTime(Path);
end;

end.
