tOPCODE	equ	41h
tNOT	equ	43h
tOFFSET	equ	44h
tSEG	equ	45h
tTYPE	equ	46h
tOR	equ	48h
tXOR	equ	49h
tAND	equ	4ah
tMOD	equ	4bh
tSHR	equ	4ch
tSHL	equ	4dh
tHIGH	equ	4eh
tLOW	equ	4fh
tPTR	equ	50h
tNUMBER	equ	64h
tREG	equ	65h
tTYP	equ	66h
tMEM	equ	67h
tSYM	equ	6bh

TSymbol	struc
	sScope	dd	?
	sAddr	dd	?
	sValue	dd	?
	sSize	dw	?
	sFlag	dw	?
	sParent	dd	?
	ends

TAsmSymbol	struc
	aValue	dd	?
	aParent	dd	?
	aAddr	dd	?
	aSize	dw	?
	aRegs	db	?
	aSeg	db	?
	aRegNum	dw	?
	aType	db	?
	aHalf	db	?
	ends

TCodeBuffer	struc
	cType	dw	?
	cValue	dd	?
	cAddr	dd	?
	ends

rfInd	equ	40h
rfBX	equ	8
rfBP	equ	4
rfSI	equ	2
rfDI	equ	1

szByte	equ	0
szWord	equ	1
szSreg	equ	2
szST	equ	4
szDword	equ	0ffh
szQword	equ	0feh
szTbyte	equ	0fdh
sz???	equ	0fch

rgAL	equ	0
rgCL	equ	1
rgDL	equ	2
rgBL	equ	3
rgAH	equ	4
rgCH	equ	5
rgDH	equ	6
rgBH	equ	7
rgAX	equ	0
rgCX	equ	1
rgDX	equ	2
rgBX	equ	3
rgSP	equ	4
rgBP	equ	5
rgSI	equ	6
rgDI	equ	7
rgES	equ	0
rgCS	equ	1
rgSS	equ	2
rgDS	equ	3

eByte	equ	0
eFixup	equ	1
eShort	equ	2
eFloat	equ	3

fRel	equ	0
fOffs	equ	1
fSegm	equ	2
fPtr	equ	3

cNop		equ	0
cPushD16	equ	2
cPushD8		equ	4
cLea		equ	6
cOutDX		equ	8
cOutD8		equ	10
cInDX		equ	12
cInD8		equ	14
cXchgRAX	equ	16
cXchgAXR	equ	18
cInt		equ	20
cEnter		equ	22
cArOpRD		equ	24
cMovRD		equ	26
cJmpRM16	equ	28
cJmpFar		equ	30
cJmpRM32	equ	32
cJcc		equ	34
cJmpNear	equ	36
cMovMAcc	equ	38
cMovAccM	equ	40
cRet		equ	42
cRetnD16	equ	44
cPrefix		equ	46
cPushSr		equ	48
cPopSr		equ	50
cIncR16		equ	52
cLgdt		equ	54
cLar		equ	56
cArpl		equ	58
cImul286	equ	60
cMovSrRM	equ	62
cMovRMSr	equ	64
cMovRMR		equ	66
cXchgRMR	equ	68
cPopRM		equ	70
cArOpRMD	equ	72
cMovRMD		equ	74
cIncRM		equ	76
cLds		equ	78
cShift		equ	80
cFoper		equ	82
cFstswAX	equ	84
cF_STi		equ	86
cF_STiST	equ	88
cF_STSTi	equ	90
cF_RM		equ	92
cF_Tbyte	equ	94
cFstsw		equ	96
cFiadd		equ	98
cFild		equ	100
cFstenv		equ	102
cFsave		equ	104
cDB		equ	106

Offs	equ	(word ptr 0)
Segm	equ	(word ptr 2)
W0	equ	(word ptr 0)
W2	equ	(word ptr 2)
B0	equ	(byte ptr 0)
B1	equ	(byte ptr 1)

Argm	macro	Symbol,SType,Count
	local	Offset
	@AP = (@AP + SType * Count + 1) and 0fffeh
	Offset = @AP
Symbol	equ	(SType ptr [bp+@AF-Offset])
	endm

@AP = 0
@AF = 0

Loc	macro	Symbol,SType,Count
	local	Offset,S
	@LP = @LP + SType * Count
	Offset = @LP
Symbol	equ	(SType ptr [bp-Offset])
	endm

@LP = 0

Entry	macro	Name
	public	Name
Name	proc	far
	push	bp
	mov	bp,sp
	@AF = @AP + 6
	if	@LP ne 0
		sub	sp,@LP
	endif
	endm

Exit	macro	Name,X
	if	@LP ne 0
		mov	sp,bp
	endif
	pop	bp
	retf	@AP
	@AP = 0
	@LP = 0
	endp	Name
	endm

Dwc	macro	A,B
	dw	H&A&_&B
endm

Zeroc	macro	A,B
	@H&A&_&B = 0
endm

Peekc	macro	A,B,C
	A = @H&B&_&C
endm

Pokec	macro	 A,B,C
	@H&A&_&B = C
endm

Fixupc	macro	A,B
	H&A&_&B = @H&A&_&B
endm

@HN=0

Hash	macro	NBuck
	local	Nb
	@I = 0
	@Hn = @Hn+1
	@Nb = (NBuck-1) shl 1
	Nb = @Nb
	dw 	Nb
	rept	NBuck
		Dwc	%@Hn,%@I
		Zeroc	%@Hn,%@I
		@I = @I+2
		endm
	endm

HEnt	macro	Nm
	local	A,I
	I = 0
	@Hs = 0
	irpc	@C,<Nm>
		I = I+1
		@Hs = @Hs+'&@C&'-1
		endm
	@Hs = (@Hs*2) and @NB
	Peekc	A,%@Hn,%@Hs
	Pokec	%@Hn,%@Hs,$
	dw	A
	db	I,'&Nm&'
	endm

HEnd	macro
	@I = 0
	rept	(@Nb shr 1)+1
		Fixupc	%@Hn,%@I
		@I = @I+2
		endm
	endm

	model	large Basm_Text,pascal
	locals	@@
