unit CompVars;

interface

uses Objects, TDos;

const

  coIOChk         = 1;
  coRangeChk      = 2;
  coStackChk      = 4;
  coExtSyntax     = 8;
  coVarStringChk  = $10;
  coForceFarCalls = $20;
  coBooleanEval   = $40;
  co8087          = $80;
  coDebugInfo     = $100;
  coLocalSymbols  = $200;
  coEmulation     = $400;
  coOverlayCode   = $800;
  coWordAlign     = $1000;
  co286Code       = $2000;
  coWinFrame      = $4000;

  cfUseUnits    = 1;
  cfDisk        = 2;
  cfBuild       = 4;
  cfMake        = 8;
  cfLinkMap     = $300;
  cfExtDebugger = $400;
  cfIntDebugger = $800;
  cfDiskBuffer  = $1000;
  cfbLinkMap    = 8;
  cfbDiskBuffer = 12;

  psNoProgram  = 0;
  psCompiled   = 1;
  psRunning    = 2;
  psTerminated = 3;

  acTraceInto  = 0;
  acStepOver   = 1;
  acRun        = 2;
  acGotoCursor = 3;

type

  Regs = array[0..13] of Word;

  TSrcPoint = record
    Fn, Ln: Integer;
  end;

  PBreakpoint = ^TBreakpoint;
  TBreakpoint = record
    FileName: PathStr;
    LineNumber: Word;
    Condition: PathStr;
    PassCount: Word;
    CurPassCount: Word;
    Position: TSrcPoint;
    Adr: Pointer;
  end;

  PCompInfo = ^TCompInfo;
  TCompInfo = record
    CurrentFile: PString;
    Status: Word;
    LineNumber: Word;
    TotalLines: Longint;
    FreeMemory: Longint;
  end;

  TInitParams = record
    LibraryName: PString;
    MemPtr: Word;
  end;

  TInitResult = record
    ErrorNum: Word;
    MemPtr: Word;
  end;

  TCompParams = record
    Flags: Word;
    MainFile: PString;
    MemPtr: Word;
    Options: Word;
    StackSize: Word;
    LowHeapLimit: Word;
    HighHeapLimit: Word;
    Defines: PString;
    ExeTpuDir: PString;
    IncDir: PString;
    UnitDir: PString;
    ObjDir: PString;
  end;

  TCompResult = record
    ErrorNum: Integer;
    ProgramLocation: Word;
    ErrorFile: PString;
    ErrorPar: PString;
    ErrorLine: Word;
    ErrorCol: Word;
    CodeSize: Longint;
    DataSize: Word;
    StackSize: Word;
    MinHeapSize: Word;
    MaxHeapSize: Word;
    TotalLines: Longint;
    FreeMemory: Longint;
    ExeName: Longint;
  end;

var

  InitOptions: Word;
  InitDefines: Word;
  TpuListPtr: Word;
  ErrorNum: Word;
  ErrorPar: Word;
  ErrorPos: Word;
  LibraryUnits: Word;
  FileStackPtr: Word;
  SaveFileStack: Word;
  TempBufPtr: Word;
  SourceBufPtr: Word;
  SourceBufEnd: Word;
  ErrorHandler: Word;
  ErrorSP: Word;
  ErrorBP: Word;
  ObjectFileSize: Word;
  ObjectFileSeg: Word;

  ProgramLocation: Word;
  CodeSize: Longint;
  DataSize: Word;
  TotalLines: Longint;
  FirstHeapRec: Word;
  EndHeapRec: Word;
  ExactAlloc: Boolean;
  FirstUnit: Word;
  UsedUnit: Word;
  CurDepth: Word;
  SymbolType: Pointer;
  CompilerOptions: Word;
  ParamsSize: Word;
  ParamsBottom: Word;
  ProcResult: Word;
  LocalsSize: Word;
  LocalsBottom: Word;
  TempLocalsSize: Word;
  WithChain: Word;
  LabelChain: Word;
  LastGoal: Word;
  ExitChain: Word;
  FailChain: Word;
  FirstLineNumber: Word;
  LastLineNumber: Word;
  CurOwner: Word;
  CurProc: Word;
  CurScope: Word;
  InStmtPart: Boolean;
  FileHandle: Word;
  ExeHandle: Word;
  DataStart: Word;
  DebugInfoSize: Longint;
  StackStart: Word;
  DataSegment: Pointer;

  CompilerFlags: Word;
  UnitName: Word;
  StackSize: Word;
  MinHeapSize: Word;
  MaxHeapSize: Word;
  GlobalOptions: Word;
  SavedDepth: Word;
  SavedDepth2: Word;
  Dummy: Word;
  DefinesPtr: Word;
  TextPos: Word;
  SaveDefinesPtr: Word;

  UnitNameLen: Word;
  NextUnit: Word;
  PrevUnit: Word;
  InterfaceEnd: Word;
  CompilingSystem: Boolean;
  SystemUnit: Word;
  CurrentToken: Byte;
  SlashToken: Byte;
  EqualToken: Byte;
  PrivateFlag: Byte;
  ProgramSection: Byte;
  DefUnitFlags: Word;
  IndexModifier: Byte;
  SymbolHash: Byte;
  CurrentSymbol: Pointer;
  CurrentHash: Word;
  CurrentWith: Word;
  CurrentOwner: Pointer;
  VarsSize: Word;
  LastTraceTable: Word;
  CodeSectStart: Word;
  ConstSectStart: Word;
  LastCodeFixup: Word;
  LastConstFixup: Word;
  DataSectStart: Word;
  ConstSectStart2: Word;

  Dictionary, ProcMap, CodeMap, ConstMap, DataMap, DummyMap, UnitList,
  SourceList, TraceTable, TempDict, CompiledCode, CompiledConst,
  CodeFixups, ConstFixups, StmtPart: record
    hrAddress: Pointer;
    hrLimit: Word;
    hrError: Word
  end;

  FileNameBuf: PathStr;
  ExeName: PathStr;
  IdentBuf: string[63];
  SymbolValue: Extended;
  Directories: array[1..5] of Word;
  TempBuffer: array[0..1023] of Byte;
  TpuList: array[0..4095] of Byte;
  DefinesBuf: array[0..1023] of Byte;
  FileStack: array[0..14] of record
    fsTextPos: Word;
    fsLineNumber: Word;
    fsFilePos: Longint;
    fsFileName: Word;
    fsFileHandle: Word;
    fsLineLength: Word;
    fsNameEntry: Word;
    fsCurrentLine: array[0..127] of Char;
    fsNestLevel: Word;
    fsName: array[0..79] of Char;
  end;

  CompMemPtr: Word;
  CompMemTop: Word;
  SourceBuffer: array[0..1023] of Char;
  ProgramSegment: Word;
  DebuggerPSP: Word;
  SourceCount: Word;
  Use8087: Boolean;
  InitMemPtr: Word;
  BptArr: array[0..63] of PBreakpoint;

const

  ProgramStatus: Word = 0;
  ProgErrorCode: Integer = 0;
  ProgErrorAddr: Pointer = nil;
  Rg: Regs = (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
  CurRegs: ^Regs = @Rg;
  CBrkTrace: Boolean = False;
  StopAfterCompiling: Boolean = False;
  DebugSP: Word = Ofs(SourceBuffer) + SizeOf(SourceBuffer);
  BptCount: Integer = 0;
  ExecPos: TSrcPoint = ();
  PrimaryFile: PathStr = '';
  PrimaryFileStr: PathStr = '';
  DefinesStr: string[128] = '';
  CommandLine: string[128] = '';
  Dirs: record
    ExeTpuDir: string[80];
    IncDir: string[128];
    UnitDir: string[128];
    ObjDir: string[128];
  end = ();
  CompParams: TCompParams = (
    Flags: cfUseUnits + cfBuild + cfMake + cfIntDebugger;
    MainFile: @PrimaryFile;
    MemPtr: 0;
    Options: coIOChk + coStackChk + coVarStringChk + coDebugInfo +
      coLocalSymbols + coEmulation + coWordAlign;
    StackSize: 16384;
    LowHeapLimit: 0;
    HighHeapLimit: 40960;
    Defines: @DefinesStr;
    ExeTpuDir: @Dirs.ExeTpuDir;
    IncDir: @Dirs.IncDir;
    UnitDir: @Dirs.UnitDir;
    ObjDir: @Dirs.ObjDir);
  CompResult: TCompResult = ();

implementation

end.
