unit Debug;

{$F+,S-}

interface

const
  MaxDBpt = 64;

type

  DBpt = record
    Adr: Pointer;
    Typ: Byte;
    Oldb: Byte;
  end;
  DBptArr = array[0..MaxDBpt] of DBpt;

function  Step(UserBptCount: Integer; var UserBptBuf: DBptArr;
  Action: Integer): Longint;
procedure OvrDebugHook;
procedure BuildPSP(CmdLine: string);
function  LoadProgram(Path: string): Integer;
procedure EmulateLoad(PID, MemTop: Word; EntryPoint, StackPtr: Pointer);
function  RunProgram: Integer;
function  InitProgram: Word;
procedure ExitProgram;

implementation

uses CompVars, Compiler;

{$L DEBUG}
function Step; external;
procedure OvrDebugHook; external;

{$L DEBUG2}
procedure BuildPSP; external;
function LoadProgram; external;
procedure EmulateLoad; external;
function RunProgram; external;
function InitProgram; external;
procedure ExitProgram; external;

end.
