unit GetOpt;

{$O+,F+,S-,V-}

interface

procedure GetOptions;

implementation

uses Drivers, Mem, Params, TDos, TVars, VSwap;

procedure GetOptions;
var
  I: Integer;
  Str: PathStr;

procedure Error;
var
  P: Pointer;
  ErrStr: string[127];
begin
  P := @Str;
  FormatStr(ErrStr, 'Invalid command line option: "%s"'^M^J, P);
  PrintStr(ErrStr);
  Halt(1);
end;

procedure GetSwitch(Value: Word);
var
  On: Boolean;
begin
  if Length(Str) = 2 then
    On := True
  else if (Length(Str)=3) and ((Str[3] = '+') or (Str[3] = '-')) then
    On := Str[3] = '+'
  else
    Error;
  if On then
    StartupOptions.CmdOptions := StartupOptions.CmdOptions or Value
  else
    StartupOptions.CmdOptions := StartupOptions.CmdOptions and not Value;
end;

function GetNumber(Min, Max: Longint): Longint;
var
  Value: Longint;
  Status: Integer;
begin
  Val(Copy(Str, 3, 255), Value, Status);
  if (Status <> 0) or (Value < Min) or (Value > Max) then
    Error;
  GetNumber := Value;
end;

begin
  for I := 1 to ParCount do
  begin
    Str := ParStr(I);
    if (Length(Str) >= 2) and ((Str[1] = '-') or (Str[1] = '/')) then
      case UpCase(Str[2]) of
        'C': ConfigFile := Copy(Str, 3, 255);
        'D': GetSwitch(soDualMonitor);
        'E': StartupOptions.EditorHeapSz := GetNumber(28, 128);
        'G': GetSwitch(soGraphicsSwap);
        'L': GetSwitch(soLcdScreen);
        'N': GetSwitch(soSnowCheck);
        'O': StartupOptions.OverlayHeapSz := GetNumber(64, 256);
        'P': GetSwitch(soEGAPaletteSave);
        'S': StartupOptions.SwapDirectory := Copy(Str, 3, 255);
        'T': GetSwitch(soLoadTurboTpl);
        'W': StartupOptions.WindowHeapSz := GetNumber(24, 64);
        'X': GetSwitch(soUseEms);
      else
        Error;
      end;
  end;
  DualMonitor := StartupOptions.CmdOptions and soDualMonitor <> 0;
  GraphicsSwap := StartupOptions.CmdOptions and soGraphicsSwap <> 0;
  LcdScreen := StartupOptions.CmdOptions and soLcdScreen <> 0;
  SnowCheck := StartupOptions.CmdOptions and soSnowCheck <> 0;
  EGAPaletteSave := StartupOptions.CmdOptions and soEGAPaletteSave <> 0;
  EmsInUse := StartupOptions.CmdOptions and soUseEms <> 0;
  LoadTurboTpl := StartupOptions.CmdOptions and soLoadTurboTpl <> 0;
  WindowHeapSize := Word(StartupOptions.WindowHeapSz) * 64;
  EditorHeapSize := Word(StartupOptions.EditorHeapSz) * 64;
  OverlayHeapSize := Word(StartupOptions.OverlayHeapSz) * 64;
end;

end.
