unit HelpHist;

{$O+,F+,S-}

interface

uses Objects, HelpUtil;

const

  MaxHistory = 20;

type

  PHelpHistory = ^THelpHistory;
  THelpHistory = object(TObject)
    Items: array[1..MaxHistory] of record
      Topic: Word;
      Pos1, Pos2: TPos;
      Width: Byte
    end;
    Count: Word;
    constructor Init;
    constructor Load(var S: TStream);
    procedure Store(var S: TStream);
    procedure Push(ATopic: Word; APos1, APos2: TPos; AWidth: Word);
    procedure Pop(var ATopic: Word; var APos1, APos2: TPos; var AWidth: Word);
    function  Empty: Boolean;
  end;

const

  RHelpHistory: TStreamRec = (
    ObjType: 10000;
    VmtLink: Ofs(TypeOf(THelpHistory)^);
    Load:    @THelpHistory.Load;
    Store:   @THelpHistory.Store
  );

implementation

constructor THelpHistory.Init;
begin
  Count := 0;
end;

constructor THelpHistory.Load(var S: TStream);
begin
  S.Read(Count, SizeOf(Count));
  S.Read(Items, Count * SizeOf(Items[1]));
end;

procedure THelpHistory.Store(var S: TStream);
begin
  S.Write(Count, SizeOf(Count));
  S.Write(Items, Count * SizeOf(Items[1]));
end;

procedure THelpHistory.Push(ATopic: Word; APos1, APos2: TPos; AWidth: Word);
begin
  if (Count = 0) or (Items[Count].Topic <> ATopic) then
  begin
    if Count = MaxHistory then
      Move(Items[2], Items[1], (MaxHistory - 1) * SizeOf(Items[1]))
    else
      Inc(Count);
    with Items[Count] do
    begin
      Topic := ATopic;
      Pos1 := APos1;
      Pos2 := APos2;
      Width := AWidth;
    end;
  end;
end;

procedure THelpHistory.Pop(var ATopic: Word; var APos1, APos2: TPos;
  var AWidth: Word);
begin
  if Count > 0 then
  begin
    with Items[Count] do
    begin
      ATopic := Topic;
      APos1 := Pos1;
      APos2 := Pos2;
      AWidth := Width;
    end;
    Dec(Count);
  end;
end;

function THelpHistory.Empty: Boolean;
begin
  Empty := Count = 0;
end;

end.
