ProcessCommand	proc	near
@@1:	xor	ax,ax
	mov	CodeCount,ax
	mov	Pending,al
	mov	DirectionBit,al
	mov	DefPrefix,al
	mov	bx,OpcodePtr
	mov	bx,cs:[bx]
	mov	cl,6
	shr	bh,cl
	cmp	bh,OperCount
	jne	@@2
	lea	si,Operand1
	lea	di,Operand2
	mov	ah,[si].aType
	mov	al,[di].aType
	and	bx,7eh
	call	cs:Opcodes[bx]
	jz	@@3
@@2:	call	OpcodeLength
	test	byte ptr cs:[bx],80h
	jz	@@5
	add	ax,2
	add	OpcodePtr,ax
	jmp	@@1
@@3:	mov	bx,OpcodePtr
	test	byte ptr cs:[bx+1],4
	jz	@@4
	test	byte ptr Options,3
	jnz	@@4
	mov	ax,Oper1TextPtr
	mov	SaveTextPtr,ax
	jmp	Not286Err
@@4:	call	PutPending
	ret
@@5:	mov	ax,Oper1TextPtr
	cmp	OperCount,1
	jle	@@6
	mov	ax,Oper2TextPtr
@@6:	mov	SaveTextPtr,ax
	jle	@@7
	mov	ax,Operand1.aSize
	cmp	ax,Operand2.aSize
	je	@@7
	jmp	InvOperErr2
@@7:	jmp	InvOperErr
ProcessCommand	endp

@Nop	proc	near
	call	GetOpcode
	xor	ax,ax
	ret
@Nop	endp

@Invalid	proc	near
	jmp	SyntaxErr
@Invalid	endp

@JmpRM16	proc	near
	call	GetRM16
	jnz	@@1
	call	GetOpcode
	call	PutOperRM
@@1:	ret
@JmpRM16	endp

@JmpRM32	proc	near
	call	GetRM
	jnz	@@1
	cmp	al,szDword
	jne	@@1
	call	GetOpcode
	call	PutOperRM
@@1:	ret
@JmpRM32	endp

@Jcc	proc	near
	cmp	ah,tMEM
	jne	@@1
	cmp	[si].aSize,-3
	jne	@@1
	mov	ax,[si].aValue.W0
	or	ax,[si].aValue.W2
	jnz	@@1
	call	PutPrefixes
	call	OpcodeLength
	mov	cl,cs:[bx+2]
	mov	bx,eShort
	mov	ax,[si].aAddr.Offs
	mov	TempAddr.Offs,ax
	mov	ax,[si].aAddr.Segm
	mov	TempAddr.Segm,ax
	call	Put
@@1:	ret
@Jcc	endp

@JmpNear	proc	near
	mov	bh,fRel
	mov	cx,-3
	cmp	[si].aSize,cx
	je	@@1
	mov	cl,-1
	jmp	short @@1
@JmpFar	label	near
	mov	bh,fPtr
	mov	cx,-2
@@1:	cmp	[si].aSize,cx
	jne	@@2
	cmp	ah,tMEM
	jne	@@2
	cmp	[si].aRegs,rfInd
	jne	@@2
	push	bx
	call	PutPrefixes
	call	OpcodeLength
	mov	cl,cs:[bx+2]
	mov	bl,eByte
	call	Put
	pop	bx
	mov	bl,eFixup
	mov	cx,[si].aValue.W0
	mov	dx,[si].aValue.W2
	mov	ax,[si].aAddr.Offs
	mov	TempAddr.Offs,ax
	mov	ax,[si].aAddr.Segm
	mov	TempAddr.Segm,ax
	call	Put
@@2:	ret
@JmpNear	endp

@Shift	proc	near
	call	GetRM8_16
	jnz	@@4
	call	GetOpcode
	call	ByteOperand
	jnz	@@2
	cmp	al,1
	je	@@3
	test	byte ptr Options,3
	jnz	@@1
	jmp	Not286Err
@@1:	sub	Opcode,10h
	push	ax
	call	PutSizeOperRM
	pop	ax
	call	PutByte
	ret
@@2:	cmp	[di].aType,tREG
	jne	@@4
	cmp	[di].aRegNum,rgCL*256+szByte
	jne	@@4
	add	Opcode,2
@@3:	call	PutSizeOperRM
@@4:	ret
@Shift	endp

@XchgRAX	proc	near
	xchg	al,ah
	xchg	si,di
@XchgAXR	label	near
	cmp	ax,tREG+tREG*256
	jne	@@1
	cmp	[si].aRegNum,rgAX*256+szWord
	jne	@@1
	cmp	[di].aRegNum.B0,szWord
	jne	@@1
	call	GetOpcode
	mov	al,[di].aRegNum.B1
	or	Opcode,al
	xor	ax,ax
@@1:	ret
@XchgRAX	endp

@Enter	proc	near
	xchg	si,di
	call	GetOpcode
	call	PutWordOperand
	jnz	@@1
	xchg	si,di
	call	PutByteOperand
@@1:	ret
@Enter	endp

@Ret	proc	near
	call	GetOpcode
	test	Options,100h
	jz	@@1
	or	Opcode,8
@@1:	cmp	OperCount,0
	jne	@@2
	ret
@RetnD16	label	near
	call	GetOpcode
@@2:	mov	di,si
	or	Opcode,1
	call	ZeroWord
	jnz	@@3
	ret
@@3:	and	Opcode,0feh
	jmp	PutWordOperand
@Ret	endp

@PushD16	proc	near
	call	GetOpcode
	xchg	si,di
	jmp	PutWordOperand
@PushD16	endp

@PushD8	proc	near
	xchg	si,di
	call	GetOpcode
	call	SignedByte
	jnz	@@1
	call	PutByte
@@1:	ret
@PushD8	endp

@Imul286	proc	near
	cmp	ah,tREG
	jne	@@3
	cmp	[si].aRegNum.B0,szWord
	jne	@@3
	xchg	si,di
	call	GetRM16
	jnz	@@3
	call	GetOpcode
	call	PutReg2
	lea	di,Operand3
	call	WordOperand
	jnz	@@3
	call	SignedByte
	pushf
	jnz	@@1
	or	Opcode,2
@@1:	push	ax
	call	PutRegRM
	pop	ax
	popf
	jnz	@@2
	jmp	PutByte
@@2:	call	PutWord
@@3:	ret
@Imul286	endp

@Lea	proc	near
	cmp	ax,tREG*256+tMEM
	jne	@@1
	cmp	[si].aRegNum.B0,szWord
	jne	@@1
	xchg	si,di
	call	GetRM
	xchg	si,di
	jnz	@@1
	mov	DefPrefix,0
	call	GetOpcode
	call	PutReg1
	call	PutRegRM
@@1:	ret
@Lea	endp

@OutD8	proc	near
	xchg	si,di
	xchg	al,ah
@InD8	label	near
	call	CheckALAX
	jnz	@@1
	call	PutByteOperand
@@1:	ret
@OutD8	endp

@OutDX	proc	near
	xchg	si,di
	xchg	al,ah
@InDX	label	near
	cmp	al,tREG
	jne	@@1
	cmp	[di].aRegNum,rgDX*256+szWord
	jne	@@1
	call	CheckALAX
@@1:	ret
@OutDX	endp

CheckALAX	proc	near
	cmp	ah,tREG
	jne	@@1
	cmp	[si].aRegNum.B1,rgAX
	jne	@@1
	call	GetOpcode
	mov	al,[si].aRegNum.B0
	cmp	al,szWord
	ja	@@1
	or	Opcode,al
	xor	ax,ax
@@1:	ret
CheckALAX	endp

@Int	proc	near
	call	GetOpcode
	mov	di,si
	call	ByteOperand
	jnz	@@1
	cmp	al,3
	je	@@1
	inc	Opcode
	call	PutByte
@@1:	ret
@Int	endp

@MovSrRM	proc	near
	xchg	al,ah
	xchg	si,di
	mov	bl,[di].aRegNum.B1
	sub	bl,rgCS
	jnz	@@1
	dec	bx
	ret
@MovRMSr	label	near
@@1:	cmp	al,tREG
	jne	@@3
	cmp	[di].aRegNum.B0,szSreg
	jne	@@3
	call	GetRM
	jnz	@@3
	cmp	al,szWord
	je	@@2
	cmp	[si].aSize,0
	jne	@@3
@@2:	call	GetOpcode
	call	PutReg2
	call	PutRegRM
@@3:	ret
@MovSrRM	endp

@MovRD	proc	near
	cmp	ax,tREG*256+tNUMBER
	jne	@@2
	cmp	[si].aRegNum.B0,szWord
	ja	@@2
	call	GetOpcode
	mov	al,[si].aRegNum.B1
	or	Opcode,al
	cmp	[si].aRegNum.B0,szByte
	je	@@1
	or	Opcode,8
	jmp	PutWordOperand
@@1:	call	PutByteOperand
@@2:	ret
@MovRD	endp

@IncRM	proc	near
	call	GetRM8_16
	jnz	@@1
	call	GetOpcode
	call	PutSizeOperRM
@@1:	ret
@IncRM	endp

@MovAccM	proc	near
	xchg	al,ah
	xchg	si,di
@MovMAcc	label	near
	cmp	ax,tMEM*256+tREG
	jne	@@1
	cmp	[di].aRegNum.B1,rgAX
	jne	@@1
	call	PureMem
	jnz	@@1
	call	GetOpcode
	mov	al,[di].aRegNum.B0
	cmp	al,szWord
	ja	@@1
	cmp	al,SizeBit
	jne	@@1
	or	Opcode,al
	call	PutMemRef
@@1:	ret
@MovAccM	endp

@XchgRMR	proc	near
	push	ax
	call	@@1
	pop	ax
	jz	@@2
	xchg	si,di
	xchg	al,ah
@@1:	cmp	al,tREG
	jne	@@2
	cmp	[di].aRegNum.B0,szWord
	ja	@@2
	call	GetRM8_16
	jnz	@@2
	call	GetOpcode
	call	PutReg2
	mov	al,[di].aRegNum.B0
	cmp	al,SizeBit
	jne	@@2
	call	PutSizeRegRM
@@2:	ret
@XchgRMR	endp

@Lds	proc	near
	cmp	ax,tREG*256+tMEM
	jne	@@2
	cmp	[si].aRegNum.B0,szWord
	jne	@@2
	xchg	si,di
	call	GetRM
	cmp	Oper2Size,0
	je	@@1
	cmp	al,szDword
	jne	@@2
@@1:	call	GetOpcode
	call	PutReg2
	call	PutRegRM
@@2:	ret
@Lds	endp

@Lar	proc	near
	xchg	si,di
	xchg	al,ah
@Arpl	label	near
	cmp	al,tREG
	jne	@@1
	cmp	[di].aRegNum.B0,szWord
	jne	@@1
	call	GetRM16
	jnz	@@1
	call	GetOpcode
	call	PutReg2
	call	PutRegRM
@@1:	ret
@Lar	endp

@Lgdt	proc	near
	call	GetRM
	jnz	@@2
	cmp	[si].aSize,6
	je	@@1
	cmp	[si].aSize,0
	jne	@@2
@@1:	call	GetOpcode
	call	PutOperRM
@@2:	ret
@Lgdt	endp

@MovRMR	proc	near
	cmp	al,tREG
	je	@@1
	cmp	ah,tREG
	jne	@@2
	mov	DirectionBit,2
	xchg	si,di
@@1:	cmp	[di].aRegNum.B0,szWord
	ja	@@2
	call	GetRM8_16
	jnz	@@2
	call	GetOpcode
	call	PutReg2
	mov	al,[di].aRegNum.B0
	cmp	al,SizeBit
	jne	@@2
	call	PutSizeRegRM
@@2:	ret
@MovRMR	endp

@PopRM	proc	near
	call	GetRM16
	jnz	@@1
	call	GetOpcode
	call	PutOperRM
@@1:	ret
@PopRM	endp

@ArOpRMD	proc	near
	call	WordOperand
	jnz	@@3
	call	GetRM8_16
	jnz	@@3
	call	GetOpcode
	cmp	SizeBit,szByte
	je	@@1
	call	SignedByte
	jnz	@@2
	or	Opcode,2
@@1:	call	ByteOperand
	jnz	@@3
	call	PutSizeOperRM
	jnz	@@3
	call	PutByteOperand
	jmp	short @@3
@@2:	call	PutSizeOperRM
	jnz	@@3
	call	PutWordOperand
@@3:	ret
@ArOpRMD	endp

@MovRMD	proc	near
	cmp	al,tNUMBER
	jne	@@2
	call	GetRM8_16
	jnz	@@2
	call	GetOpcode
	call	PutSizeOperRM
	cmp	SizeBit,szWord
	jz	@@1
	jmp	PutByteOperand
@@1:	jmp	PutWordOperand
@@2:	ret
@MovRMD	endp

@ArOpRD	proc	near
	cmp	ax,tREG*256+tNUMBER
	jne	@@2
	call	WordOperand
	jnz	@@2
	cmp	[si].aRegNum.B1,rgAX
	jne	@@2
	cmp	[si].aRegNum.B0,szWord
	ja	@@2
	jne	@@1
	call	GetOpcode
	inc	Opcode
	call	PutWordOperand
	jmp	short @@2
@@1:	call	ByteOperand
	jnz	@@2
	call	GetOpcode
	call	PutByteOperand
@@2:	ret
@ArOpRD	endp

@IncR16	proc	near
	cmp	ah,tREG
	jne	@@1
	cmp	[si].aRegNum.B0,szWord
	jne	@@1
	call	GetOpcode
	mov	al,[si].aRegNum.B1
	or	Opcode,al
	xor	ax,ax
@@1:	ret
@IncR16	endp

@PopSr	proc	near
	mov	cl,rgCS
	jmp	short @@1
@PushSr	label	near
	mov	cl,-1
@@1:	cmp	ah,tREG
	jne	@@2
	cmp	[si].aRegNum.B0,szSreg
	jne	@@2
	cmp	[si].aRegNum.B1,cl
	je	@@3
	call	GetOpcode
	mov	al,[si].aRegNum.B1
	mov	cl,3
	shl	al,cl
	or	Opcode,al
	xor	ax,ax
@@2:	ret
@@3:	inc	ax
	ret
@PopSr	endp

@FstswAX	proc	near
	cmp	ah,tREG
	jne	@@4
	cmp	[si].aRegNum,rgAX*256+szWord
	jne	@@4
@Foper	label	near
	mov	al,0
_Foper	label	near
	xchg	ax,dx
	call	PutPrefixes
	call	OpcodeLength
	mov	dh,0
	test	byte ptr Options,3
	jnz	@@1
	mov	dh,1
@@1:	mov	cx,cs:[bx+2]
	cmp	cl,1
	ja	@@2
	mov	dh,cl
	inc	bx
	dec	ax
	jmp	@@1
@@2:	cmp	cl,9bh
	jne	@@3
	xor	dh,dh
@@3:	or	cl,dl
	mov	ah,ch
	mov	bl,eFloat
	mov	bh,DefPrefix
	mov	DefPrefix,0
	or	bh,dh
	call	Put
	dec	ax
	mov	Pending,al
	mov	Opcode,ah
	xor	ax,ax
@@4:	ret
@FstswAX	endp

@F_Tbyte	proc	near
	mov	cx,szTbyte*256+szTbyte
	jmp	short @@2
@Fild	label	near
	mov	cx,szQword*256+szQword
	jmp	short @@2
@Fiadd	label	near
	mov	cx,szDword*256+szWord
	jmp	short @@2
@Fstsw	label	near
	cmp	[si].aSize,0
	jne	@@1
	mov	[si].aSize,2
@@1:	mov	cx,szWord*256+szWord
	jmp	short @@2
@F_RM	label	near
	mov	cx,szDword*256+szQword
@@2:	cmp	ah,tMEM
	jne	@@4
	push	cx
	call	GetRM
	pop	cx
	jnz	@@4
	mov	al,0
	cmp	SizeBit,ch
	je	@@3
	cmp	SizeBit,cl
	jne	@@4
	or	al,4
@@3:	call	_Foper
	call	PutOperRM
@@4:	ret
@F_Tbyte	endp

@Fstenv	proc	near
	mov	cx,14
	jmp	short @@1
@Fsave	label	near
	mov	cx,94
@@1:	cmp	[si].aSize,cx
	je	@@2
	cmp	[si].aSize,0
	jne	@@3
@@2:	cmp	ah,tMEM
	jnz	@@3
	call	GetRM
	jnz	@@3
	call	@Foper
	call	PutOperRM
@@3:	ret
@Fstenv	endp

@F_STi	proc	near
	mov	al,tREG
	jmp	short @@1
@F_STSTi	label	near
	xchg	si,di
	xchg	al,ah
@F_STiST	label	near
	cmp	[di].aRegNum,0*256+szST
	jne	@@2
@@1:	cmp	ax,tREG*256+tREG
	jne	@@2
	cmp	[si].aRegNum.B0,szST
	jne	@@2
	call	@Foper
	mov	al,[si].aRegNum.B1
	or	Opcode,al
	xor	ax,ax
@@2:	ret
@F_STi	endp

PureMem	proc	near
	call	GetRM
	jnz	@@1
	cmp	PureMemFlag,1
@@1:	ret
PureMem	endp

GetRM8_16	proc	near
	call	GetRM
	jnz	@@1
	test	al,not szWord
@@1:	ret
GetRM8_16	endp

GetRM16	proc	near
	call	GetRM
	jnz	@@1
	cmp	al,szWord
@@1:	ret
GetRM16	endp

GetRM	proc	near
	mov	ax,[si].aAddr.Offs
	mov	FixupAddr.Offs,ax
	mov	ax,[si].aAddr.Segm
	mov	FixupAddr.Segm,ax
	mov	FixupOffs,0
	mov	DefPrefix,0
	cmp	[si].aType,tREG
	je	@@6
	cmp	[si].aType,tMEM
	jne	@@8
	mov	al,[si].aHalf
	or	al,al
	jnz	@@1
	inc	ax
@@1:	mov	DwordFixup,al
	mov	ax,6*256+1
	mov	bl,[si].aRegs
	and	bx,rfBX+rfBP+rfSI+rfDI
	jz	@@3
	mov	ah,cs:@@9[bx-1]
	or	ah,ah
	jns	@@2
	jmp	InvRegErr
@@2:	dec	ax
@@3:	mov	PureMemFlag,al
	mov	cx,[si].aValue.W0
	mov	FixupOffs,cx
	mov	cl,sz???
	mov	bx,[si].aSize
	cmp	bx,10
	ja	@@4
	mov	cl,cs:@@10[bx]
@@4:	mov	SizeBit,cl
	mov	RMBits,ah
	mov	ah,[si].aSeg
	or	ah,ah
	jz	@@7
	mov	al,3eh
	cmp	PureMemFlag,1
	je	@@5
	test	[si].aRegs,rfBP
	jz	@@5
	mov	al,36h
@@5:	cmp	al,ah
	je	@@7
	mov	DefPrefix,ah
	jmp	short @@7
@@6:	mov	PureMemFlag,0
	mov	ax,[si].aRegNum
	or	ah,0c0h
	mov	RMBits,ah
	cmp	al,szWord
	ja	@@8
	mov	SizeBit,al
@@7:	xor	ax,ax
@@8:	mov	al,SizeBit
	ret
@@9	db	5,4,-1,6,3,2,-1,7,1,0,-1,-1,-1,-1,-1
@@10	db	sz???,szByte,szWord,sz???
	db	szDword,sz???,sz???,sz???
	db	szQword,sz???,szTbyte
GetRM	endp

SignedByte	proc	near
	cmp	[di].aType,tNUMBER
	jne	@@1
	cmp	[di].aHalf,0
	jne	@@1
	mov	al,[di].aValue.B0
	cbw
	cwd
	cmp	ah,[di].aValue.B1
	jne	@@1
	cmp	dx,[di].aValue.W2
@@1:	ret
SignedByte	endp

ByteOperand	proc	near
	call	WordOperand
	jnz	@@2
	cmp	[di].aHalf,0
	jne	@@2
	or	dx,dx
	js	@@1
	or	ah,ah
	ret
@@1:	mov	dx,ax
	cbw
	cmp	ax,dx
@@2:	ret
ByteOperand	endp

WordOperand	proc	near
	cmp	[di].aType,tNUMBER
	jne	@@1
	mov	ax,[di].aValue.W0
	cwd
	cmp	[di].aValue.W2,dx
	je	@@1
	xor	dx,dx
	cmp	[di].aValue.W2,dx
	je	@@1
	jmp	OutOfRangeErr
@@1:	ret
WordOperand	endp

PutReg1	proc	near
	mov	al,[si].aRegNum.B1
	jmp	short @@1
PutReg2	label	near
	mov	al,[di].aRegNum.B1
@@1:	shl	al,1
	shl	al,1
	shl	al,1
	or	RMBits,al
	ret
PutReg1	endp

GetOpcode	proc	near
	call	PutPrefixes
	mov	al,DefPrefix
	or	al,al
	jz	@@1
	call	PutByte
@@1:	call	_GetOpcode
	inc	Pending
	mov	Opcode,al
	ret
GetOpcode	endp

_GetOpcode	proc	near
	call	OpcodeLength
	xchg	ax,cx
	dec	cx
	jz	@@2
	js	@@2
@@1:	call	@@2
	call	PutByte
	loop	@@1
@@2:	mov	al,cs:[bx+2]
	inc	bx
	ret
_GetOpcode	endp

PutPrefixes	proc	near
	lea	bx,Prefixes
@@1:	xor	ax,ax
	add	al,ss:[bx]
	jz	@@2
	call	PutByte
	inc	bx
	jmp	@@1
@@2:	ret
PutPrefixes	endp

PutPending	proc	near
	push	ax
	xor	ax,ax
	xchg	al,Pending
	or	al,al
	jz	@@1
	mov	al,Opcode
	call	PutByte
@@1:	pop	ax
	ret
PutPending	endp

ZeroWord	proc	near
	cmp	[di].aHalf,0
	jne	@@1
	call	WordOperand
	jnz	@@1
	or	ax,ax
@@1:	ret
ZeroWord	endp

PutWordOperand	proc	near
	mov	bh,[di].aHalf
	or	bh,bh
	jnz	@@1
	call	WordOperand
	jz	PutWord
	ret
@@1:	mov	bl,eFixup
	mov	cx,[di].aValue.W0
	mov	dx,[di].aValue.W2
	mov	ax,[di].aAddr.Offs
	mov	TempAddr.Offs,ax
	mov	ax,[di].aAddr.Segm
	mov	TempAddr.Segm,ax
	call	Put
	ret
PutWordOperand	endp

PutByteOperand	proc	near
	call	ByteOperand
	jz	PutByte
	ret
PutByteOperand	endp

PutWord	proc	near
	call	PutByte
	xchg	al,ah
PutByte	label	near
	call	PutPending
	push	bx
	push	cx
	mov	bl,eByte
	mov	cx,ax
	call	Put
	pop	cx
	pop	bx
	ret
PutWord	endp

Put	proc	near
	call	PutPending
	push	si
	mov	si,CodeCount
	cmp	si,11*size TCodeBuffer
	jne	@@1
	jmp	SyntaxErr
@@1:	mov	CodeBuffer[si].cType,bx
	mov	CodeBuffer[si].cValue.W0,cx
	mov	CodeBuffer[si].cValue.W2,dx
	push	TempAddr.Offs
	pop	CodeBuffer[si].cAddr.Offs
	push	TempAddr.Segm
	pop	CodeBuffer[si].cAddr.Segm
	add	CodeCount,size TCodeBuffer
	pop	si
	cmp	ax,ax
	ret
Put	endp

PutMemRef	proc	near
	mov	ax,FixupOffs
	mov	cx,FixupAddr.Offs
	or	cx,FixupAddr.Segm
	jz	PutWord
	xchg	ax,cx
	xor	dx,dx
	mov	bl,eFixup
	mov	bh,DwordFixup
	mov	ax,FixupAddr.Offs
	mov	TempAddr.Offs,ax
	mov	ax,FixupAddr.Segm
	mov	TempAddr.Segm,ax
	jmp	Put
PutMemRef	endp

PutOperRM	proc	near
	mov	SizeBit,szByte
PutSizeOperRM	label	near
	call	OpcodeAttrs
	and	al,38h
	or	RMBits,al
	cmp	DirectionBit,0
	je	PutSizeRegRM
	ret
PutOperRM	endp

PutRegRM	proc	near
	mov	SizeBit,szByte
PutSizeRegRM	label	near
	mov	al,SizeBit
	or	al,DirectionBit
	or	Opcode,al
	mov	al,RMBits
	mov	ah,al
	and	ax,0c7c0h
	cmp	al,0c0h
	je	@@5
	cmp	PureMemFlag,1
	je	@@3
	mov	cx,FixupAddr.Offs
	or	cx,FixupAddr.Segm
	jnz	@@2
	mov	cx,FixupOffs
	cmp	ah,6
	je	@@1
	jcxz	@@5
@@1:	mov	ax,cx
	cbw
	cmp	ax,cx
	je	@@4
@@2:	or	RMBits,80h
@@3:	call	@@5
	call	PutMemRef
	jmp	short @@7
@@4:	or	RMBits,40h
	call	@@5
	mov	ax,FixupOffs
	jmp	short @@6
@@5:	mov	al,RMBits
@@6:	call	PutByte
@@7:	cmp	SizeBit,szTbyte
	ja	@@8
	xor	ax,ax
@@8:	ret
PutRegRM	endp

OpcodeLength	proc	near
	call	OpcodeAttrs
	and	ax,3
	inc	ax
	ret
OpcodeLength	endp

OpcodeAttrs	proc	near
	mov	bx,OpcodePtr
	mov	al,cs:[bx+1]
	ret
OpcodeAttrs	endp

	even

Opcodes	dw	@Nop,@PushD16,@PushD8,@Lea
	dw	@OutDX,@OutD8,@InDX,@InD8
	dw	@XchgRAX,@XchgAXR,@Int,@Enter
	dw	@ArOpRD,@MovRD,@JmpRM16,@JmpFar
	dw	@JmpRM32,@Jcc,@JmpNear,@MovMAcc
	dw	@MovAccM,@Ret,@RetnD16,@Invalid
	dw	@PushSr,@PopSr,@IncR16,@Lgdt
	dw	@Lar,@Arpl,@Imul286,@MovSrRM
	dw	@MovRMSr,@MovRMR,@XchgRMR,@PopRM
	dw	@ArOpRMD,@MovRMD,@IncRM,@Lds
	dw	@Shift,@Foper,@FstswAX,@F_STi
	dw	@F_STiST,@F_STSTi,@F_RM,@F_Tbyte
	dw	@Fstsw,@Fiadd,@Fild,@Fstenv
	dw	@Fsave,@Invalid
