unit CpuWin;

{$O+,F+,S-}

interface

uses Objects, Drivers, Views;

const

  CRegisterViewer = #6;

type

  PRegisterViewer = ^TRegisterViewer;
  TRegisterViewer = object(TView)
    constructor Init(var R: TRect);
    procedure Draw; virtual;
    function  GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

const

  RRegisterViewer: TStreamRec = (
    ObjType: 3011;
    VmtLink: Ofs(TypeOf(TRegisterViewer)^);
    Load:    @TRegisterViewer.Load;
    Store:   @TRegisterViewer.Store
  );

function CpuWindow: PWindow;

implementation

uses TVars, TWindows, CompVars, Context;

constructor TRegisterViewer.Init(var R: TRect);
begin
  TView.Init(R);
  EventMask := evDebugger;
end;

procedure TRegisterViewer.Draw;
var
  Color: Byte;
  I, J: Integer;
  B: array[0..14] of Word;
  L: array[0..20] of Longint;
  S: string;
const
  RegNum: array[0..12] of Byte = (0, 3, 2, 1, 9, 10, 5, 7, 6, 8, 12, 13, 4);
  FlagNum: array[0..7] of Word = ($1, $40, $80, $800, $4, $200, $10, $400);
begin
  for I := 0 to 12 do
    L[I] := Rg[RegNum[I]];
  for I := 0 to 7 do
    L[I+13] := Longint(Rg[11] and FlagNum[I] <> 0);
  FormatStr(S, 'AX %04X DX %04X' +
               'CX %04X BX %04X' +
               'IP %04X CS %04X' +
               'SI %04X DS %04X' +
               'DI %04X ES %04X' +
               'SP %04X SS %04X' +
               'BP %04X        ' +
               'c=%D z=%D s=%D o=%D' +
               'p=%D i=%D a=%D d=%D', L);
  Color := GetColor(1);
  I := 1;
  for J := 0 to 8 do
  begin
    MoveBuf(B, S[I], Color, 15);
    WriteBuf(0, J, 15, 1, B);
    Inc(I, 15);
  end;
end;

function TRegisterViewer.GetPalette: PPalette;
const
  P: string[Length(CRegisterViewer)] = CRegisterViewer;
begin
  GetPalette := @P;
end;

procedure TRegisterViewer.HandleEvent(var Event: TEvent);
begin
  TView.HandleEvent(Event);
  if Event.What and evMessage <> 0 then
    case Event.Command of
      cmRefreshInfo:
        DrawView;
      cmFindCpuWindow:
        ClearEvent(Event);
  end;
end;

function CpuWindow: PWindow;
var
  R: TRect;
  Window: PWindow;
begin
  R.Assign(61, 0, 80, 11);
  Window := New(PTurboWindow, Init(R, 'CPU', wnNoNumber, wpCpuWindow));
  with Window^ do
  begin
    GrowMode := 0;
    HelpCtx := hcCpuWindow;
    Flags := Flags and not (wfGrow + wfZoom) or wfSaveable;
    GetExtent(R);
    R.Grow(-2, -1);
    Insert(New(PRegisterViewer, Init(R)));
  end;
  CpuWindow := Window;
end;

end.
