unit Extend;

{$O+,F+,S-}

interface

procedure ExtAdd(var A, B: Extended);
procedure ExtSub(var A, B: Extended);
procedure ExtMul(var A, B: Extended);
procedure ExtDiv(var A, B: Extended);
function  ExtCmp(var A, B: Extended): Integer;
procedure Ext2Double(var Src: Extended; var Dst: Double);
procedure Ext2Single(var Src: Extended; var Dst: Single);
procedure Double2Ext(var Src: Double; var Dst: Extended);
procedure Single2Ext(var Src: Single; var Dst: Extended);
procedure Ext2Comp(var Src: Extended; var Dst: Comp);
function  Ext2Long(var Src: Extended): Longint;
function  Ext2Ulong(var Src: Extended): Longint;
procedure Comp2Ext(var Src: Comp; var Dst: Extended);
procedure Long2Ext(Src: Longint; var Dst: Extended);
procedure Ulong2Ext(Src: Longint; var Dst: Extended);
procedure Ext2Real(var Src: Extended; var Dst: Real);
procedure Real2Ext(var Src: Real; var Dst: Extended);
procedure ExtPow10(N: Integer; var A: Extended);
function  Str2Ext(Src: string; var Dst: Extended): Integer;
function  Ext2Str(var Src: Extended; W: Integer; var Sign: Integer;
  var Dst: string): Integer;

implementation

{$L EXTARITH}
procedure ExtAdd(var A, B: Extended); external;
procedure ExtSub(var A, B: Extended); external;
procedure ExtMul(var A, B: Extended); external;
procedure ExtDiv(var A, B: Extended); external;
function  ExtCmp(var A, B: Extended): Integer; external;

{$L EXTCONV}
procedure Ext2Double(var Src: Extended; var Dst: Double); external;
procedure Ext2Single(var Src: Extended; var Dst: Single); external;
procedure Double2Ext(var Src: Double; var Dst: Extended); external;
procedure Single2Ext(var Src: Single; var Dst: Extended); external;
procedure Ext2Comp(var Src: Extended; var Dst: Comp); external;
function  Ext2Long(var Src: Extended): Longint; external;
function  Ext2Ulong(var Src: Extended): Longint; external;
procedure Comp2Ext(var Src: Comp; var Dst: Extended); external;
procedure Long2Ext(Src: Longint; var Dst: Extended); external;
procedure Ulong2Ext(Src: Longint; var Dst: Extended); external;
procedure Ext2Real(var Src: Extended; var Dst: Real); external;
procedure Real2Ext(var Src: Real; var Dst: Extended); external;

{$L EXTPOW10}
procedure ExtPow10(N: Integer; var A: Extended); external;

{$L EXTSTR}
function  Str2Ext(Src: string; var Dst: Extended): Integer; external;
function  Ext2Str(var Src: Extended; W: Integer; var Sign: Integer;
  var Dst: string): Integer; external;

end.
