unit CompOpt;

{$O+,F+,S-}

interface

procedure CompOptions(var S: string);

implementation

uses Drivers, CompVars;

procedure CompOptions(var S: string);
var
  L: array[0..16] of Longint;
  I: Integer;
const
  Options: array[0..13] of Word =
    (coWordAlign,
     coBooleanEval,
     coDebugInfo,
     coEmulation,
     coForceFarCalls,
     co286Code,
     coIOChk,
     coLocalSymbols,
     co8087,
     coOverlayCode,
     coRangeChk,
     coStackChk,
     coVarStringChk,
     coExtSyntax);
begin
  for I := 0 to 13 do
    if CompParams.Options and Options[I] <> 0 then
      L[I] := Longint('+')
    else
      L[I] := Longint('-');
  Inc(I);
  L[I] := CompParams.StackSize;
  Inc(I);
  L[I] := Longint(CompParams.LowHeapLimit) * 16;
  Inc(I);
  L[I] := Longint(CompParams.HighHeapLimit) * 16;
  FormatStr(S, '{$A%c,B%c,D%c,E%c,F%c,G%c,I%c,L%c,N%c,O%c,R%c,S%c,V%c,X%c}'^M
    + '{$M %d,%d,%d}'^M, L);
end;

end.
