unit Shell;

{$F+,S-,X+,V-}

interface

uses Dos;

procedure Run(var Path: PathStr; var CmdLine: ComStr; Amount: Word);
procedure DosShell(Amount: Word);

implementation

uses TVars, Overlay, Drivers, VideoIO;

function SetMemTop(I: Word): Word; assembler;
asm
        MOV     BX,I
        MOV     AX,PrefixSeg
        MOV     ES,AX
        MOV     AH,4AH
        INT     21H
        MOV     AX,BX
end;

procedure Run(var Path: PathStr; var CmdLine: ComStr; Amount: Word);
begin
  OvrClearBuf;
  DoneSysError;
  DoneVideoIO;
  SetMemTop(Amount);
  SwapVectors;
  Exec(Path, CmdLine);
  SwapVectors;
  SetMemTop(SetMemTop($FFFF));
  InitVideoIO;
  InitSysError;
end;

procedure DosShell(Amount: Word);
const
  Empty: string[1] = '';
var
  S: PathStr;
begin
  S := GetEnv('COMSPEC');
  if S <> '' then
    Run(S, Empty, Amount);
end;

end.
