//  : aim.
// ,        Options 
//      .

unit u_options;
{$mode objfpc}

interface

uses
	inifiles, sysutils, Direct3D9;

type
	TOptionSection = class
		constructor Create(IniFile: TIniFile); virtual; abstract;
	end;

	//  .
	TApplicationO = class(TOptionSection)
		constructor Create(IniFile: TIniFile); override;
	end;

	//  ,   .
	TPathsO = class(TOptionSection)
		Textures: AnsiString;        // .
		Cursor: AnsiString;          //  .
		constructor Create(IniFile: TIniFile); override;
	end;

	//  .
	TGraphicO = class(TOptionSection)
		Fullscreen: Boolean;    //  ?
		Mode: string;           //  .
		DepthBits: Integer;     //  Z-.
		StencilBits: Integer;   //   .
		Frequency: Integer;     //   .
		DeviceType: D3DDEVTYPE;
		RequestedVP: DWORD;
		constructor Create(IniFile: TIniFile); override;
	end;

	//  .
	TSoundO = class(TOptionSection)
		constructor Create(IniFile: TIniFile); override;
	end;

	//   (, ).
	TControlsO = class(TOptionSection)
		constructor Create(IniFile: TIniFile); override;
	end;

	//   .
	TGameO = class(TOptionSection)
		constructor Create(IniFile: TIniFile); override;
	end;

	//         .
	TOptions = class
	private
		FApplication: TApplicationO;
		FPaths: TPathsO;
		FGraphic: TGraphicO;
		FSound: TSoundO;
		FControls: TControlsO;
		FGame: TGameO;
	public
		constructor Create(const FileName: string);
		destructor Destroy; override;
		//   :
		property Application: TApplicationO read FApplication;
		property Paths: TPathsO read FPaths;
		property Graphic: TGraphicO read FGraphic;
		property Sound: TSoundO read FSound;
		property Controls: TControlsO read FControls;
		property Game: TGameO read FGame;
	end;

var
	Options: TOptions;

implementation

// TApplicationO -----

constructor TApplicationO.Create(IniFile: TIniFile);
const
	section = 'Application';
begin
	//  .
end;

// TPathsO -----

constructor TPathsO.Create(IniFile: TIniFile);
const
	section = 'Paths';
begin
	Textures := IniFile.ReadString(section, 'Textures', 'data\textures\');
	Cursor := IniFile.ReadString(section, 'Cursor', 'data\cursors\Cursor1.ani');
end;

// TGraphicO -----

constructor TGraphicO.Create(IniFile: TIniFile);
const
	section = 'Graphic';
begin
	Fullscreen := IniFile.ReadBool(section, 'Fullscreen', true);
	Mode := IniFile.ReadString(section, 'ScreenMode', '800x600x32');
	DepthBits := IniFile.ReadInteger(section, 'DepthBits', 16);
	StencilBits := IniFile.ReadInteger(section, 'StencilBits', 0);
	Frequency := IniFile.ReadInteger(section, 'Frequency', 60);
	DeviceType := D3DDEVTYPE_HAL;
	RequestedVP := D3DCREATE_HARDWARE_VERTEXPROCESSING;
end;

// TSoundO -----

constructor TSoundO.Create(IniFile: TIniFile);
const
	section = '';
begin
	//  .
end;

// TControlsO -----

constructor TControlsO.Create(IniFile: TIniFile);
const
	section = '';
begin
	//  .
end;

// TGameO -----

constructor TGameO.Create(IniFile: TIniFile);
const
	section = '';
begin
	//  .
end;

// TOptions -----

constructor TOptions.Create(const FileName: string);
var
	IniFile: TIniFile;
begin
	IniFile := TIniFile.Create(FileName);

	FApplication := TApplicationO.Create(IniFile);
	FPaths := TPathsO.Create(IniFile);
	FGraphic := TGraphicO.Create(IniFile);
	FSound := TSoundO.Create(IniFile);
	FControls := TControlsO.Create(IniFile);
	FGame := TGameO.Create(IniFile);

	IniFile.Destroy;
end;

destructor TOptions.Destroy;
begin
	FApplication.Destroy;
	FPaths.Destroy;
	FGraphic.Destroy;
	FSound.Destroy;
	FControls.Destroy;
	FGame.Destroy;
end;

end.
