//  : aim.
//  .

unit u_testgame;
{$mode objfpc}

interface

uses
	u_log, u_options, u_graphics, u_textures, u_sprites;

type
	TTestGame = class
	private
		Texture: TTexture;
		Sprite: TSprite;
		Angle: Single;
	public
		constructor Create;
		destructor Destroy; override;
		procedure Update;
	end;

var
	TestGame: TTestGame = nil;

implementation

// TTestGame -----

// public

constructor TTestGame.Create;
begin
	Texture := Textures.New(Options.Paths.Textures + 'ani00.jpg');
	Sprite := Sprites.NewSprite(Texture, 326, 729);
	Sprite.SetMode(0, 0, 3, Sprite.Width div 2, Sprite.Height div 2, 1000, true);
	Sprite.SetParams(0, 0, 0, 0, 1, 1);
	Angle := 0;
end;

destructor TTestGame.Destroy;
begin
	Texture.Destroy;
	Sprite.Destroy;
end;

procedure TTestGame.Update;
begin
	Angle := Angle + 0.002;
	Sprite.SetParams(0, 0, 0, Angle, 1, 1);
end;

end.
