//  : aim.
//       .

unit u_fonts;
{$mode objfpc}

interface

uses
	u_log, u_options, u_window,
	Direct3D9, D3DX9, windows;

type
	//  
	TFont = class
	private
		Font: ID3DXFont;
	public
		constructor Create(const FontName: AnsiString; AHeight, AWidth, AWeight: Integer; AItalic: Boolean);
	end;

implementation

// TFont -----

// public

constructor TFont.Create(const FontName: AnsiString; AHeight, AWidth, AWeight: Integer; AItalic: Boolean);
var
	hr: HResult;
	FontDescriptor: D3DXFONT_DESC;
begin
	with FontDescriptor do begin
		Height := AHeight;
		Width := AWidth;
		Weight := AWeight;
		MipLevels := 1;
		Italic := AItalic;
		CharSet := DEFAULT_CHARSET;
		OutputPrecision := OUT_DEFAULT_PRECIS;
		Quality := DEFAULT_QUALITY;
		PitchAndFamily := DEFAULT_PITCH or FF_DONTCARE;
		FaceName := PChar(FontName);
	end;
	hr := D3DXCreateFontIndirect(Window.Device, FontDescriptor, Font);
	if FAILED(hr) then
		Log.Fatal('Graphics', 'Can''t load font.');
end;

end.
