//  : aim.
// :       .

unit u_textures;
{$mode objfpc}

interface

uses
	u_log, u_options, u_window,
	Direct3D9, D3DX9, windows, contnrs;

type
	//  .
	TTexture = class
	private
		FFileName: AnsiString;
		FFrames: IDirect3DTexture9;
	public
		// :    .
		constructor Create(const AFileName: AnsiString);
		//        Sprites.
		destructor Destroy; override;
		property Frames: IDirect3DTexture9 read FFrames;
		property FileName: AnsiString read FFileName;
	end;
	
	//     .
	TTextures = class
	private
		HashTable: TFPHashTable;
		//  ,      .
		procedure Delete(const FileName: string);
	public
		constructor Create;
		destructor Destroy; override;
		//       .   
		//  ,    .
		function New(const FileName: string): TTexture;
		//   .
		procedure Clear;
	end;

var
	Textures: TTextures = nil;

implementation

// TTexture -----

// public

constructor TTexture.Create(const AFileName: AnsiString);
var
	hr: HResult;
begin
	FFileName := AFileName;
	hr := D3DXCreateTextureFromFile(Window.Device, PChar(AFileName), FFrames);
	if FAILED(hr) then
		Log.Fatal('Graphics', 'Can''t load image.');
end;

destructor TTexture.Destroy;
begin
	if Textures <> nil then Textures.Delete(FFileName);
end;

// TTextures -----

// private

procedure TTextures.Delete(const FileName: string);
begin
	HashTable.Delete(FileName);
end;

// public

constructor TTextures.Create;
begin
	inherited;
	HashTable := TFPHashTable.Create;
end;

destructor TTextures.Destroy;
begin
	Clear;
	HashTable.Destroy;
	inherited;
end;

function TTextures.New(const FileName: string): TTexture;
begin
	Result := TTexture(HashTable[FileName]);
	if Result = nil then begin
		Result := TTexture.Create(FileName);
		HashTable[FileName] := Result;
	end;
end;

procedure TTextures.Clear;
var
	i, j: Integer;
	Temp: TFPObjectList;
begin
	for i := 0 to HashTable.HashTable.Count - 1 do begin
		Temp := HashTable.HashTable[i] as TFPObjectList;
		if Temp <> nil then
			for j := 0 to Temp.Count - 1 do
				if Temp[j] <> nil then
					TObject((Temp[j] as THTNode).Data).Destroy;
	end;
	HashTable.Clear;
end;

end.
