#ifndef USR_DIV_POLICY_H_INCLUDED
#define USR_DIV_POLICY_H_INCLUDED

#include"coord.h"
#include<vector>
#include<math.h>

class u_div_policy
{
public :
    u_div_policy() ;
    const coord_math::v_paircoord div_l(const coord_math::coord& u_fcoord, const coord_math::coord& u_scoord, int n_rec, int max_l) ;

private :
    typedef std::vector<std::pair<double, double> > m_v_coord ;
    typedef m_v_coord::iterator cit ;
    m_v_coord m_p ;

};

u_div_policy::u_div_policy()
{
    const int r = 2;
    int i (0);
    coord_math::coord a = std::make_pair(getmaxx()/3, getmaxy()/2);
    coord_math::coord b = std::make_pair(getmaxx()/3*2, getmaxy()/2);
    coord_math::coord m ;
    arc(a.first, a.second, 0, 360, r);
    arc(b.first, b.second, 0, 360, r);
    //  moveto(a.first, a.second);
    clearmouseclick(WM_LBUTTONDOWN);
    do
    {
        if (ismouseclick(WM_LBUTTONDOWN))
        {
            ++i ;
            m = std::make_pair(mousex(), mousey());
            if (i == 1)
            {
                moveto( m.first, m.second);
                arc( m.first, m.second, 0, 360, r);
            }
            lineto( m.first, m.second);
            arc( m.first, m.second, 0, 360, r);
            std::pair<double, double> p =
                std::make_pair(coord_math::get_angle(a, m)-coord_math::get_angle(a, b), coord_math::get_len(a, m)/coord_math::get_len(a, b));
            m_p.push_back(p);
            clearmouseclick(WM_LBUTTONDOWN);
        }


    }
    while (!ismouseclick(WM_RBUTTONDOWN));
    clearviewport();
}

const coord_math::v_paircoord u_div_policy::div_l(const coord_math::coord& u_fcoord, const coord_math::coord& u_scoord, int n_rec, int max_l)
{
    coord_math::v_paircoord v_c ;
    if (m_p.size() != 0)
    {
        coord_math::coord c, d ;
        coord_math::coord a = u_fcoord ;
        coord_math::coord b = u_scoord ;
        double l = coord_math::get_len(a, b);
        coord_math::pair_coord f ;
        double ang = coord_math::get_angle(a, b);
        c.first  = cos(ang + (*m_p.begin()).first)*(*m_p.begin()).second*l + a.first ;
        c.second = -sin(ang + (*m_p.begin()).first)*(*m_p.begin()).second*l + a.second ;

        for (cit it = ++m_p.begin(), end = m_p.end() ; it != end; ++it)
        {
            d.first = cos(ang + (*it).first) *(*it).second*l + a.first ;
            d.second = -sin(ang + (*it).first)*(*it).second*l + a.second ;

            f = std::make_pair(c, d);
            v_c.push_back(f);

            c.first = cos(ang + (*it).first)*(*it).second*l + a.first ;
            c.second = -sin(ang + (*it).first)*(*it).second*l + a.second ;

        }
    }
    return v_c ;

}
#endif // USR_DIV_POLICY_H_INCLUDED
