unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, Menus;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    OpenDialog1: TOpenDialog;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    procedure StringGrid1KeyPress(Sender: TObject; var Key: Char);
    procedure FormShow(Sender: TObject);
    procedure StringGrid1DrawCell(Sender: TObject; Col, Row: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure N3Click(Sender: TObject);
    procedure N2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  TMatrix = array[0..9] of array[0..9] of string[1];

var
  Form1: TForm1;
  cPath: string;
  fFile: text;
  aMatrix: TMatrix;

implementation

{$R *.DFM}

procedure TForm1.StringGrid1KeyPress(Sender: TObject; var Key: Char);
begin
  if key <> #13 then
     begin
       StringGrid1.Cells[StringGrid1.Col,StringGrid1.Row] := Key;
       Key := #13;
       StringGrid1.OnKeyPress(Sender,key);
     end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  StringGrid1.RowCount := 10;
  StringGrid1.ColCount := 10;

  cPath := ExtractFilePath(Application.ExeName);
end;

procedure TForm1.StringGrid1DrawCell(Sender: TObject; Col, Row: Integer;
  Rect: TRect; State: TGridDrawState);
begin
  if aMatrix[Col,Row] = '' then
     begin
       StringGrid1.Canvas.Brush.Color := clBlack;
       StringGrid1.Canvas.FillRect(Rect);
     end
  else
     begin
       if aMatrix[Col,Row] = StringGrid1.Cells[Col,Row]
          then
             StringGrid1.Canvas.Font.Color := clBlack
          else
             begin
               StringGrid1.Canvas.Font.Color := clRed;
               StringGrid1.Canvas.Brush.Color := clWhite;
               StringGrid1.Canvas.FillRect(Rect);
             end;

          StringGrid1.Canvas.TextOut(Rect.Left+2,Rect.Top+2,StringGrid1.Cells[Col,Row]);
     end;
end;

procedure TForm1.N3Click(Sender: TObject);
begin
Application.Terminate;
end;

procedure TForm1.N2Click(Sender: TObject);
Var i,j: integer;
begin

OpenDialog1.InitialDir := cPath;   // New!

if OpenDialog1.Execute then
  begin
    // AssignFile(fFile,cPath+'crosword.dat');  // old!

    AssignFile(fFile,OpenDialog1.FileName);     // New!
    Reset(fFile);

    for i:=0 to StringGrid1.ColCount-1 do
    for j:=0 to StringGrid1.RowCount-1 do
        begin
          Readln(fFile,aMatrix[i,j]);
          StringGrid1.Cells[i,j] := ''; // new!
        end;

    CloseFile(fFile);

    StringGrid1.Repaint;
  end;
end;

end.
