Unit WindowUnit;

Interface
Uses mouseUnit;

Type
  PTSquare = ^TSquare;
  TSquare =
    Object

    Private
      ClrActive, ClrPassive : Word;
      next : PTSquare;

    Public
      xSt, ySt, xFn, yFn : Word;

      Function OwnWidth : Word;
      Function OwnHeight : Word;

      Constructor Init( pxSt, pySt, pxFn, pyFn : Word;
                  pcActive, pcPassive : Word );
      Destructor Done; Virtual;

      Function IsClicked( Var Event : TEvent ) : Boolean;
      Procedure SetColors( pActive, pPassive : Word );

      Procedure Show; Virtual;
      Procedure Clear; Virtual;

      Function HandleEvent( Var Event : TEvent ) : Boolean;
               Virtual;

      Function GetActive : Word;
      Function GetPassive : Word;
    End;

Type
  ActionType = Procedure;

  PShortStr = ^ShortStr;
  ShortStr = String[ 64 ];

  menuStrType = String[ 32 ];

Const
  btnStandard = 10;
  btnWindowed = 4;

Type
  PTButton = ^TButton;
  TButton =
    Object( TSquare )

      Title : PShortStr;
      Key : Word;
      Action : ActionType;

      Constructor Init( pxSt, pySt : Word; Var pxFn, pyFn : Word;
                  Const s : String; pKey : Word; Const Delta : Byte;
                  pAction : ActionType );
      Destructor Done; Virtual;

      Procedure Show; Virtual;
      Procedure PressIt;

      Function HandleEvent( Var Event : TEvent ) : Boolean;
               Virtual;

    Private
      Procedure Draw( Active : Boolean );
    End;

Type
  PTGroup = ^TGroup;
  TGroup =
    Object
      First, Last : PTSquare;

      Constructor Init;
      Destructor Done; Virtual;

      Procedure Show;
      Procedure Insert( p : PTSquare );

      Function HandleEvent( Var Event : TEvent ) : Boolean;
    End;

Type
  PTButtonBar = ^TButtonBar;
  TButtonBar =
    Object( TSquare )

      arr : TGroup;

      Constructor Init( pxSt, pySt, pxFn, pyFn : Word );
      Destructor Done; Virtual;

      Procedure Show; Virtual;
      Function Process( Var Event : TEvent ) : Boolean;

      Function Insert( p : PTButton ) : Boolean;
    End;

Procedure noneAction;



Type
  PTWindow = ^TWindow;
  TWindow =
    Object( TSquare )
      Constructor Init( pxSt, pySt, pxFn, pyFn : Word;
                  Const s : String; isPopup : Boolean );
      Destructor Done; Virtual;

      Procedure Show; Virtual;
      Function HandleEvent( Var Event : TEvent ) : Boolean;
               Virtual;

      Procedure PrintStr( pLine : Word; Const s : String );
      Function TopLine( pLine : Word ) : Word;

      Function GetWidth : Word;

    Private
      Header : PShortStr;
      Size : Word;
      Buffer : Pointer;
    End;

Type
  menuArrType =
    Array[ 1 .. maxInt Div SizeOf(menuStrType) ] Of menuStrType;

Type
  PTMenuWindow = ^TMenuWindow;
  TMenuWindow =
    Object( TWindow )

      infoArr : Pointer;
      Line, Count : Word;

      Constructor Init( pxSt, pySt : Word; Const s : String;
                        Var pArr; pSize, pLine : Word );
      Destructor Done; Virtual;

      Procedure Show; Virtual;
      Function GetMenu : Integer;

    Private
      Procedure PrintStr( pLine : Word; Const s : String );
                Virtual;
      Procedure ShowLine( indx : Word; isSelected : Boolean );
                Virtual;
    End;


Implementation
Uses Crt, Graph, Keyboard;

Constructor TSquare.Init( pxSt, pySt, pxFn, pyFn : Word;
            pcActive, pcPassive : Word );
  Begin
    xSt := pxSt; ySt := pySt; xFn := pxFn; yFn := pyFn;
    ClrActive := pcActive; ClrPassive := pcPassive;
    next := nil
  End;
Destructor TSquare.Done;
  Begin End;

Function TSquare.OwnWidth : Word;
  Begin OwnWidth := xFn - xSt End;
Function TSquare.OwnHeight : Word;
  Begin OwnHeight := yFn - ySt End;

Procedure TSquare.Show;
  Begin
    Clear;
    SetColor( ClrActive );
    Rectangle( xSt, ySt, xFn, yFn )
  End;
Procedure TSquare.Clear;
  Begin
    SetFillStyle( SolidFill, ClrPassive );
    Bar( xSt, ySt, xFn, yFn )
  End;

Function TSquare.IsClicked( Var Event : TEvent ) : Boolean;
  Begin
    IsClicked := False;
    With Event Do
      If buttClicked in [msbLeft .. msbMidd] Then
          IsClicked := ((xMouse >= xSt) And (xMouse <= xFn) And
                        (yMouse >= ySt) And (yMouse <= yFn))
  End;

Function TSquare.HandleEvent( Var Event : TEvent ) : Boolean;
  Begin HandleEvent := False End;
Procedure TSquare.SetColors( pActive, pPassive : Word );
  Begin
    ClrActive := pActive; ClrPassive := pPassive
  End;

Function TSquare.GetActive : Word;
  Begin GetActive := ClrActive End;
Function TSquare.GetPassive : Word;
  Begin GetPassive := ClrPassive; End;



Constructor TButton.Init( pxSt, pySt : Word; Var pxFn, pyFn : Word;
            Const s : String; pKey : Word; Const Delta : Byte;
            pAction : ActionType );
  Begin
    SetTextStyle( SmallFont, HorizDir, 4 );

    pxFn := pxSt + TextWidth( s ) + Delta;
    pyFn := pySt + TextHeight( s ) + Delta;

    TSquare.Init( pxSt, pySt, pxFn, pyFn, White, LightGray );

    New( Title ); Title^ := s;
    Action := pAction; Key := pKey
  End;

Destructor TButton.Done;
  Begin
    Dispose( Title );
    TSquare.Done
  End;

Procedure TButton.Show;
  Begin Draw( False ) End;

Procedure TButton.Draw( Active : Boolean );
  Begin
    mouse.msOff;

    TSquare.Show;
    SetColor( Byte(Active) * Red + Byte(not Active) * White );
    SetTextStyle( SmallFont, HorizDir, 4 );
    SetTextJustify( CenterText, CenterText );
    OutTextXY( xSt + (xFn - xSt) Div 2,
               ySt + (yFn - ySt) Div 2, Title^ );

    mouse.msOn
  End;

Procedure TButton.PressIt;
  Const
    DelayTime = 300;
  Begin
    Draw( True );
    Delay( DelayTime );
    Draw( False );
    Action
  End;

Function TButton.HandleEvent( Var Event : TEvent ) : Boolean;
  Var WasClick : Boolean;
  Begin
    WasClick := False;

    With Event Do
      If not mousePressed Then
        WasClick := (keyPressed = Key)
      Else WasClick := TSquare.IsClicked( Event );

    If WasClick Then PressIt;
    HandleEvent := WasClick;
  End;




Constructor TGroup.Init;
  Begin
    First := nil; Last := nil
  End;
Destructor TGroup.Done;
  Var p, nxt : PTSquare;
  Begin
    p := First;
    While p <> nil Do
      Begin
        nxt := p^.next;
        Dispose( p, Done );
        p := nxt
      End
  End;

Procedure TGroup.Show;
  Var p : PTSquare;
  Begin
    p := First;
    While p <> nil Do
      Begin p^.Show; p := p^.next End
  End;

Procedure TGroup.Insert( p : PTSquare );
  Begin
    If First = nil Then First := p
    Else Last^.next := p; Last := p
  End;

Function TGroup.HandleEvent( Var Event : TEvent ) : Boolean;
  Var p : PTSquare;
  Begin
    p := First;
    While p <> nil Do
      Begin
        If p^.HandleEvent( Event ) Then
          Begin HandleEvent := True; Exit End;
        p := p^.next
      End;
    HandleEvent := False
  End;

Constructor TButtonBar.Init( pxSt, pySt, pxFn, pyFn : Word );
  Var i : Word;
  Begin
    TSquare.Init( pxSt, pySt, pxFn, pyFn, DarkGray, Black );
    arr.Init
  End;

Destructor TButtonBar.Done;
  Begin
    arr.Done;
    TSquare.Done
  End;

Procedure TButtonBar.Show;
  Begin
    TSquare.Show;
    arr.Show;
  End;

Function TButtonBar.Process( Var Event : TEvent ) : Boolean;
  Begin
    Process := arr.HandleEvent( Event )
  End;

Function TButtonBar.Insert( p : PTButton ) : Boolean;
  Begin
    Insert := True;
    arr.Insert( p )
  End;

Procedure noneAction;
  Begin End;




Constructor TWindow.Init( pxSt, pySt, pxFn, pyFn : Word;
            Const s : String; isPopup : Boolean );
  Begin
    TSquare.Init( pxSt, pySt, pxFn, pyFn, White, Green );
    New( Header ); Header^ := s;

    Size := 0; Buffer := nil;
    If isPopup Then
      Begin
        mouse.msOff;
        Size := ImageSize( xSt, ySt, xFn, yFn );
        GetMem( Buffer, Size );
        GetImage( xSt, ySt, xFn, yFn, Buffer^ );
        mouse.msOn;
      End;

    If s = '' Then Exit;
  End;

Destructor TWindow.Done;
  Begin
    If Buffer <> nil Then
      Begin
        mouse.msOff;
        PutImage( xSt, ySt, Buffer^, CopyPut );
        FreeMem( Buffer, Size ); Buffer := nil;
        mouse.msOn
      End;

    Dispose( Header );
    TSquare.Done
  End;

Procedure TWindow.Show;
  Begin
    mouse.msOff;
    TSquare.Show;

    SetTextStyle( SmallFont, HorizDir, 4 );
    SetTextJustify( RightText, TopText );

    SetFillStyle( SolidFill, Blue );
    Bar( xSt + 1, ySt + 1, xFn - 1, ySt + 7 + TextHeight(Header^) );
    SetColor( White ); OutTextXY( xFn - 3, ySt + 2, Header^ );
    Rectangle( xSt, ySt, xFn, ySt + Succ(7) + TextHeight(Header^));

    mouse.msOn
  End;

Function TWindow.HandleEvent( Var Event : TEvent ) : Boolean;
  Begin
    HandleEvent := False;
  End;

Function TWindow.GetWidth : Word;
  Begin GetWidth := xFn - xSt - 20 End;

Function TWindow.TopLine( pLine : Word ) : Word;
  Begin
    TopLine := ySt + TextHeight(Header^) + 9 +
               Pred(pLine) * (TextHeight('W') + 2)
  End;

Procedure TWindow.PrintStr( pLine : Word; Const s : String );
  Begin
    SetTextJustify( LeftText, TopText );
    SetColor( Black ); OutTextXY( xSt + 10, TopLine(pLine), s )
  End;


Const
  maxOfStrings = 'This is a maximal string';

Constructor TMenuWindow.Init( pxSt, pySt : Word;
            Const s : String; Var pArr; pSize, pLine : Word );
  Begin
    SetTextStyle( SmallFont, HorizDir, 4 );

    Line := pLine; Count := pSize;
    GetMem( infoArr, Count * SizeOf(menuStrType) );
    Move( pArr, infoArr^, Count * SizeOf(menuStrType) );

    TWindow.Init( pxSt, pySt, pxSt + (TextWidth( maxOfStrings ) + 10),
                  pySt + (Succ(Line) * (TextHeight('W') + 2) + 12), s, True )
  End;

Destructor TMenuWindow.Done;
  Begin
    FreeMem( infoArr, Count * SizeOf(menuStrType) );
    TWindow.Done
  End;

Procedure TMenuWindow.PrintStr( pLine : Word; Const s : String );
  Begin
    SetTextJustify( LeftText, TopText );
    OutTextXY( xSt + 10, TopLine(pLine), s )
  End;

Procedure TMenuWindow.ShowLine( indx : Word; isSelected : Boolean );
  Begin
    mouse.msOff;
    SetColor( Byte(isSelected) * Red + Byte(not isSelected) * White );
    PrintStr( indx, menuArrType(infoArr^)[indx] );
    mouse.msOn
  End;

Procedure TMenuWindow.Show;
  Var i : Word;
  Begin
    SetColors( White, LightGray );
    TWindow.Show;
    For i := 1 To Line Do ShowLine( i, (i = 1) )
  End;

Function TMenuWindow.GetMenu : Integer;

  Var currItem : Word;

  Function moveLineUp : Boolean;
    Begin
      moveLineUp := False;
      If currItem > 1 Then
        Begin
          ShowLine( currItem, False );
          Dec( currItem );
          ShowLine( currItem, True );
          moveLineUp := True
        End
    End;

  Function moveLineDown : Boolean;
    Begin
      moveLineDown := False;
      If currItem < Line Then
        Begin
          ShowLine( currItem, False );
          Inc( currItem );
          ShowLine( currItem, True );
          moveLineDown := True
        End
    End;

  Var nextCh : Word;
      Ch : Char;
  Begin
    Show; currItem := 1;
    Repeat

      nextCh := GetKey( Ch );
      Case nextCh Of
        kbdUpArrow   :
          moveLineUp;
        kbdDownArrow :
          moveLineDown;
        kbdHome      :
          While moveLineUp Do;
        kbdEnd       :
          While moveLineDown Do;
        kbdEnter     :
          Begin
            GetMenu := currItem; Exit
          End;
        kbdEscape    :
          Begin
            GetMenu := -1; Exit
          End
      End

    Until False;
  End;

END.
