{--------------------------------------------------------------}
{$O+} {$F+}
unit Lex;  { ᪮ }
interface


{ Constant Declarations }
const TAB = ^I;
      CR  = ^M;
      LF  = ^J;
{--------------------------------------------------------------}
{ Type Declarations  }
type Symbol = string[8];
     SpSymbol = string[2];
     SymTab = array[1..1000] of Symbol;
     SymSpSymbol = array[1..1000] of SpSymbol;
     TabPtr = ^SymTab;
     TabSpSymbo = ^SymSpSymbol;
{--------------------------------------------------------------}
{ Variable Declarations }
var Look  : char;              { ࠭ ᨬ ⠭  䠩 }
    Token : integer;           { ࠭ ⨯ ᥬ }
    Value : string[16];        { 祭 ᥬ }
    Hash: integer;             { -祭 䨪 }
    f: file of char; {text;                    { 室 䠩 }
    LineError:integer;         { ࠭  ⠭ ப }
    restart1,restart2:longint;
    nowraz:integer;
{--------------------------------------------------------------}
{ Definition of Keywords and Token Types }
{  १ࢨ஢ ᫮ }
const KWlist: array [1..20] of Symbol =
              ('PROGRAM', 'VAR', 'IF', 'THEN', 'ELSE', 'BEGIN', 'INTEGER',
              'END', 'READ', 'WRITE', 'STRING', 'WHILE', 'DO', 'FOR', 'TO', 'REPEAT', 'UNTIL','AND','OR','NOT');

{  ᯥ樠 ᨬ }
const SpecSymbol: array [1..18] of SpSymbol =
                  ('+', '-', '*', '/','=', '<', '>', ',', ';', ':',
                  ':=', '(', ')', '''', '<=', '>=', '<>', '.');

{ 楤  㭪樨 室騩   ᪮  }
procedure OpenFileIn;
procedure CloseFileIn;
{procedure Error(s: string);
procedure Abort(s: string);
procedure Expected(s: string);}
Procedure GetChar;
procedure Komentarii;
function  IsAlpha(c: char): boolean;
function  IsDigit(c: char): boolean;
function  IsAlNum(c: char): boolean;
function  IsOp(c:char):boolean;
function  IsWhite(c: char): boolean;
function  IsPerevodKar(c: char): boolean;
procedure SkipWhite;
procedure ToHash;
function  Lookup(T: TabPtr; s: string; n: integer): integer;
function  LookSp(T:TabSpSymbo ; s: string; n: integer): integer;
procedure GetName;
procedure GetNum;
procedure GetOp;
procedure Scan;

implementation
uses sin;
{--------------------------------------------------------------}
{ Report an Error }
{procedure Error(s: string);
begin
   WriteLn;
   WriteLn(^G, 'Error: ', s, '.');
end;
{--------------------------------------------------------------}
{ Report Error and Halt }
{procedure Abort(s: string);
begin
   Error(s);
   close(f);
   close(output);
   Halt;
end;
{--------------------------------------------------------------}
{ Report What Was Expected }
{procedure Expected(s: string);
begin
   Abort(s + ' Expected');
end;

{--------------------------------------------------------------}
{ 楤 ࠡ⪨  }
procedure Komentarii;
begin
 While Look <> '}' do {     ᨬ  }
  begin
   GetChar;    { 뢠 ᨬ 室 ⮪}
   { ஢塞: ⨣  䠩}
   if Eof(f) then Expected('਩  : }');
  end;
 GetChar; {뢠 ᨬ 室 ⮪}
end;
{--------------------------------------------------------------}
{ 楤 뢠  ᨬ 室 ⮪  䠩  ६ Look}
procedure GetChar;
begin
   if eof(f) then LineError:=LineError+1; { ᫨ ᨬ ॢ ப  㢥稢 ६ LineError  1}
   if not Eof(f) then Read(f, Look) {᫨   䠩  ᨬ}
   else Look:=#0;  {  ᢠ Look ᨬ  䠩}
   restart1:=restart1+1;
   if Look = '{' then Komentarii;  { ᫨ ᨬ 砫 , 뢠 楤 ࠡ⪨ }

end;
{--------------------------------------------------------------}
{㭪 ஢   ᨬ 㪢}
function IsAlpha(c: char): boolean;
begin
   IsAlpha := UpCase(c) in ['A'..'Z'];
end;
{--------------------------------------------------------------}
{㭪 ஢   ᨬ ன}
function IsDigit(c: char): boolean;
begin
   IsDigit := c in ['0'..'9'];
end;
{--------------------------------------------------------------}
{㭪 ஢   ᨬ 㪢  ன}
function IsAlNum(c: char): boolean;
begin
   IsAlNum := IsAlpha(c) or IsDigit(c);
end;
{--------------------------------------------------------------}
{㭪 ஢   ᨬ  ࠧ⥫}
function IsOp(c:char):boolean;
begin
 IsOp:=c in ['+', '-','*', '/','<', '>', ':', '=', '.', '(', ')', ',', ';' ,''''];
end;
{--------------------------------------------------------------}
{㭪 ஢   ᨬ ஡  ⠡樥}
function IsWhite(c: char): boolean;
begin
   IsWhite := c in [' ', TAB];
end;
{--------------------------------------------------------------}
{㭪 ஢   ᨬ ७ᮬ ப  ⮬ ⪨}
function IsPerevodKar(c: char): boolean;
begin
   IsPerevodKar := c in [#10,#13];
end;
{--------------------------------------------------------------}
{㭪 ࠡ⪨ ஡  ७ᮢ ப}
procedure SkipWhite;
begin
{뢠 ᨬ  室 ⮪,    ᨬ ⫨  ᨬ ஡  ७ ப}
   while (IsWhite(Look)) or (IsPerevodKar(Look))  do
      GetChar;
end;

{--------------------------------------------------------------}
{楤 ८ࠧ  䨪  -祭}
procedure ToHash;
var r,s,k,i:integer;
c:char;
begin
k:=0;
s:=length(value);  {祬  }
 for i:=1 to s do begin {  ࢮ ᨬ  ᫥}
  c:=UpCase(value[i]); {砥 ᨬ  䨪}
  case c of
   '0': k:=k+48;
   '1': k:=k+49;
   '2': k:=k+50;
   '3': k:=k+51;
   '4': k:=k+52;
   '5': k:=k+53;
   '6': k:=k+54;
   '7': k:=k+55;
   '8': k:=k+56;
   '9': k:=k+57;
   'A': k:=k+65;
   'B': k:=k+66;
   'C': k:=k+67;
   'D': k:=k+68;
   'E': k:=k+69;
   'F': k:=k+70;
   'G': k:=k+71;
   'H': k:=k+72;
   'I': k:=k+73;
   'J': k:=k+74;
   'K': k:=k+75;
   'L': k:=k+76;
   'M': k:=k+77;
   'N': k:=k+78;
   'O': k:=k+79;
   'P': k:=k+80;
   'Q': k:=k+81;
   'R': k:=k+82;
   'S': k:=k+83;
   'T': k:=k+84;
   'U': k:=k+85;
   'V': k:=k+86;
   'W': k:=k+87;
   'X': k:=k+88;
   'Y': k:=k+89;
   'Z': k:=k+90;
  end;
 end;
r:= k mod 211; { 祭 㬬   211, 砥 -祭}
Hash:=r;
end;
{--------------------------------------------------------------}
{㭪 ⢫   ⠡ १ࢨ஢ ᫮}
{室 ࠬ: ⥫  ⠡, ᥬ, ᫮ ⮢  ⠡}
{㭪 頥     ⠡}
function Lookup(T: TabPtr; s: string; n: integer): integer;
var i: integer;
    found: boolean;
begin
   found := false;
   i := n;
   {஢塞,       ⨣  ⠡}
   while (i > 0) and not found do
      if s = T^[i] then
         found := true
      else
         dec(i);
   Lookup := i; {ᢠ     ⠡}
end;
{--------------------------------------------------------------}
{㭪 ⢫   ⠡ ᯥ樠 ᨬ}
{室 ࠬ: ⥫  ⠡, ᥬ, ᫮ ⮢  ⠡}
{㭪 頥     ⠡}
function LookSp(T:TabSpSymbo ; s: string; n: integer): integer;
var i: integer;
    found: boolean;
begin
   found := false;
   i := n;
   {஢塞,       ⨣  ⠡}
   while (i > 0) and not found do
      if s = T^[i] then
         found := true
      else
         dec(i);
   LookSp := i; {ᢠ     ⠡}
end;

{--------------------------------------------------------------}
{ 楤 ନ஢ 䨪 }
procedure GetName;
begin
   Value := '';
   {   室 ⮪   ᨬ ⫨  㪢  }
   while IsAlNum(Look) do begin
     Value := Value + UpCase(Look); {ନ㥬 ᥬ}
     GetChar;
   end;
   {뢠 㭪 ⢫   ⠡}
   Token := Lookup(Addr(KWlist), Value, 20) + 2;
   {᫨ ᥬ 䨪 뢠 此 ନ஢ -祭}
   if Token = 2 then ToHash;
   SkipWhite;
  end;
{--------------------------------------------------------------}
{ 楤 ନ஢ ᫠ }
procedure GetNum;
begin
   Value := '';
   {   室 ⮪   ᨬ ⫨  }
   while IsDigit(Look) do begin
     Value := Value + Look; {ନ㥬 ᥬ}
     GetChar;
   end;
   Token :=1; { ᥬ ࠢ 1}
   SkipWhite;
end;
{--------------------------------------------------------------}
{ 楤 ନ஢ ࠧ⥫ }
procedure GetOp;
begin
 Value:='';
 Value:=Value + Look; { ନ㥬 ࠧ⥫}
 if IsOp(Look) then begin
  case look of {᫨ ᨬ ࠧ⥫ ᮮ⢥ ᫥騬 ᨬ: :, <, >, 뢠  䠩 ᫥騩 ᨬ}
   ':', '<', '>' : begin
                     GetChar;
                     if IsOp(Look) then begin
                         Value:=Value + Look;
                         GetChar;
                     end;
                   end;
  else GetChar;
  end;
 end;
 Token := LookSp(Addr(SpecSymbol), Value, 18)+30;
 SkipWhite;
end;
{--------------------------------------------------------------}
{楤 ஢    ᮢ ஢ ᮮ⢥ ᨬ}
procedure Scan;
begin
   if IsWhite(look) then SkipWhite
   else if IsAlpha(Look) then GetName
   else if IsDigit(Look) then GetNum
   else if IsOp(Look) then GetOp
   else if IsPerevodKar(Look) then SkipWhite
   else if Look = '{' then Komentarii
   else Expected(' ᨬ:'+ Look);
end;
{-----------------------------------------------}
{ 楤  䠩 }
procedure OpenFileIn;
begin
  assign(f, Paramstr(1));          {ParamStr(1));}
  reset(f);
end;
{-----------------------------------------------}
{ 楤  䠩 }
procedure  CloseFileIn;
begin
   Close(f);
end;

end.























