#include "controller.h"

Controller::Controller(View * view, Model * model)
{
    this->view=view;
    this->model=model;
    this->connectionsForClustersModel();
    connect(this,SIGNAL(connectionsForSpanningMatrixConnected()),this,SLOT(connectionsForVisualResult()));
    connect(this,SIGNAL(connectionForMiscConnected()),this,SLOT(connectionsForDataMatrix()));
    connect(this,SIGNAL(connectionsForDataMatrixConnected()),this,SLOT(connectionsForDistanceMatrix()));
    connect(this,SIGNAL(connectionsForDistanceMatrixConnected()),this,SLOT(connectionsForSpanningMatrix()));
    this->connectMisc();
    this->connectionsForThresHoldClose();
}

void Controller::connectMisc()
{
    connect(view->exitButton,SIGNAL(clicked()),view,SLOT(close()));
    connect(model,SIGNAL(dataFailedToRead(QFile*)),view,SLOT(showFileErrorMessage(QFile*)));
    connect(model,SIGNAL(dataReaded(QStringList*)),view,SLOT(setParameterSwitcherBar(QStringList*)));
    connect(model,SIGNAL(dataReaded()),view,SLOT(setEnabledViewCountSpinBox()));
    connect(model,SIGNAL(dataReaded()),view,SLOT(setEnabledViewColumnSpinBox()));
     this->model->readData();
    emit this->connectionForMiscConnected();
}

void Controller::connectionsForDataMatrix()
{
    connect(model,SIGNAL(dataMatrixModelReady(QStandardItemModel*)),
            view,SLOT(setDataMatrixModel(QStandardItemModel*)));
    this->model->setUpDataMatrixModel();
    emit this->connectionsForDataMatrixConnected();
}

void Controller::connectionsForDistanceMatrix()
{
connect(model,SIGNAL(distanceMatrixModelReady(QStandardItemModel*)),
            view,SLOT(setDistanceMatrixModel(QStandardItemModel*)));
connect(model,SIGNAL(distanceMatrixCalculated(QStandardItemModel*)),view,SLOT(updateDistanceMatrixModel(QStandardItemModel*)));
connect(view->parametersSwithcerBar, SIGNAL(currentChanged(int)),view,SLOT(prepareData(int)));
connect(view,SIGNAL(dataPrepared(int,int)),model,SLOT(calculateNewDistanceMatrixModel(int,int)));
connect(view->viewCountColumsSpinBox,SIGNAL(valueChanged(int)),view,SLOT(setViewCountColumns(int)));
connect(view->viewCountSpinBox,SIGNAL(valueChanged(int)),view,SLOT(setViewCount(int)));
this->model->setUpDistanceMatrixModel();
this->model->calculateNewDistanceMatrixModel(0,model->distanceMatrixItems.size());
emit this->connectionsForDistanceMatrixConnected();
}

void Controller::connectionsForSpanningMatrix()
{
 connect(model,SIGNAL(spaningMatrixModelReady(QStandardItemModel*)),
            view,SLOT(setSpaningMatrixModel(QStandardItemModel*)));
 connect(this->view->viewCountSpinBox,SIGNAL(valueChanged(int)),this->model,SLOT(calculateNewSpaningMatrixModel(int)));// 
 connect(this->view,SIGNAL(spaningMatrixModelSet(int)),this->view,SLOT(setViewCount(int)));
 connect(this->model,SIGNAL(distanceMatrixCalculated(int)),this->model,SLOT(calculateNewSpaningMatrixModel(int)));
 connect(this->model,SIGNAL(spanningMatrixCalculated(QStandardItemModel*)),this->view,SLOT(updateSpaningMatrixModel(QStandardItemModel*)));
 connect(this->model,SIGNAL(spanningMatrixCalculated(QStandardItemModel*)),this->view,SLOT(setUpThresholdControllers(QStandardItemModel*)));
 this->model->setUpSpaningMatrixModel();
 this->model->calculateNewSpaningMatrixModel(view->viewCountSpinBox->value());
emit this->connectionsForSpanningMatrixConnected();
}

void Controller::connectionsForThresHoldClose()
{
    connect(this->view->thresholdCloseSpinBox,SIGNAL(valueChanged(int)),this->model,SLOT(changeThresholdLinePos(int)));
}

void Controller::connectionsForVisualResult()
{
    connect(this->view,SIGNAL(spaningMatrixModelSet(int)),this->model,SLOT(setUpVisualModel()));
    connect(this->model,SIGNAL(visualModelReady(QGraphicsScene*)),this->view,SLOT(setVisualModel(QGraphicsScene*)));
    connect(this->model,SIGNAL(spanningMatrixCalculated(QStandardItemModel*)),this->model,SLOT(calculateNewVisualResult(QStandardItemModel*)));
    this->model->setUpVisualModel();
    this->model->_calculateVisualResult();
}

void Controller::connectionsForClustersModel()
{
    connect(this->model,SIGNAL(clustersModelReady(QStringListModel*)),this->view,SLOT(setClustersModel(QStringListModel*)));
    connect(this->model,SIGNAL(spanningMatrixCalculated_(QStandardItemModel*)),this->model,SLOT(calculateNewClustersModel(QStandardItemModel*)));
    this->model->setUpClustersModel();
}
