#include <QtGui/QApplication>
#include <QCleanlooksStyle>
#include <qtextcodec.h>
#include "view.h"
#include "model.h"
#include "controller.h"

int main(int argc, char *argv[])
{
  QApplication::setStyle(new QCleanlooksStyle);
  QApplication a(argc, argv);
  QTextCodec *codec = QTextCodec::codecForName("CP1251");
  QTextCodec::setCodecForCStrings(codec);
    View * view = new View();
    Model * model = new Model();
    view->show();
    view->setWindowState(Qt::WindowMaximized);
    Controller controller(view, model);
    return a.exec();
}
