#include "model.h"
using namespace std;

bool IsEnabled(const MyCluster& cluster)
{
    return (cluster.disabled == false); //   
}

Model::Model()
{
}

void Model::readData()
{

    QFile *file1 = new QFile("hHeader.txt");
    QFile *file2 = new QFile("vHeader.txt");
    QFile *file3= new QFile("rows_data.txt");
    QStringList strl;
    QString str;
    QList <QStandardItem * >  buf;
    if  (!file1->open(QIODevice::ReadOnly))
     emit dataFailedToRead(file1);
    else
     if  (!file2->open(QIODevice::ReadOnly))
      emit dataFailedToRead(file2);
     else
      if  (!file3->open(QIODevice::ReadOnly))
       emit dataFailedToRead(file3);
      else {
            QTextStream *fileStream = new QTextStream(file1);
        while(!fileStream->atEnd())
         hHeaderData.push_back(fileStream->readLine());
        fileStream->flush();
        fileStream->setDevice(file2);
        while(!fileStream->atEnd())
         vHeaderData.push_back(fileStream->readLine());
        fileStream->flush();
        fileStream->setDevice(file3);
        while(!fileStream->atEnd())
        {
         str = fileStream->readLine();
         strl = str.split(" ",QString::SkipEmptyParts);
         for(int i=0;i<strl.size();i++)
         {
            buf.push_back(new QStandardItem(strl.at(i)));
         }
         rowData.push_back(buf);
         str.clear();
         strl.clear();
         buf.clear();
        }
       emit dataReaded();
       emit dataReaded(&hHeaderData);
        }
}

void Model::setUpDataMatrixModel()
{
 dataMatrixModel = new QStandardItemModel;
 for(int row = 0;row < rowData.size(); ++row)
     dataMatrixModel->insertRow(row,rowData.at(row));
 dataMatrixModel->setHorizontalHeaderLabels(hHeaderData);
 dataMatrixModel->setVerticalHeaderLabels(vHeaderData);
 emit dataMatrixModelReady(dataMatrixModel);
}

void Model::setUpDistanceMatrixModel()
{
    distanceMatrixModel= new QStandardItemModel();
 emit distanceMatrixModelReady(distanceMatrixModel);
}

void Model::setUpSpaningMatrixModel()
{
    spanningMatrixModel = new QStandardItemModel();
    emit spaningMatrixModelReady(spanningMatrixModel);
}

void Model::setUpVisualModel()
{
    visualResultModel = new QGraphicsScene();
    emit visualModelReady(visualResultModel);
    thresholdLine = new QGraphicsLineItem();
}

void Model::setUpClustersModel()
{
    clustersModel = new QStringListModel();
    emit clustersModelReady(clustersModel);
}

void Model::calculateNewDistanceMatrixModel(int parNum,int size)
{
    bool isNum;
    QString * buf= new QString;
    QList < QStandardItem * > lst;
    distanceMatrixItems.clear();
    distanceMatrixModel->clear();
    for ( int i=0;i< rowData.size();++i )
    {
      for ( int j=0;j<rowData.size();++j)
      {
          buf->setNum(
                   (rowData.at(i).at(parNum)->text().toInt(&isNum,10))
                           - //minus
                        (rowData.at(j).at(parNum)->text().toInt(&isNum,10))

                  ,10);
          if (0 > buf->toInt(&isNum,10))
              buf->setNum((buf->toInt(&isNum,10) * -1),10);
          lst.push_back(new QStandardItem(*buf));
          buf->clear();
      }
       distanceMatrixItems.push_back(lst);
       lst.clear();
     }
   for (int i=0;i< distanceMatrixItems.size();++i)
    distanceMatrixModel->insertRow(i,distanceMatrixItems.at(i));
   lst.~QList();
   buf->~QString();
   distanceMatrixModel->setHorizontalHeaderLabels(vHeaderData);
   distanceMatrixModel->setVerticalHeaderLabels(vHeaderData);
 emit distanceMatrixCalculated(distanceMatrixModel);
 emit distanceMatrixCalculated(size);
}

void Model::calculateNewSpaningMatrixModel(int  matrixSize)
{
 int distanceMatrix [matrixSize][matrixSize];
 int spanningMatrix[matrixSize][matrixSize];
 int used[matrixSize];
 int count=0;
 bool * isNum = new bool;
 int min ;
 QList < QStandardItem *> buf;
 QString bufstring;

 for (int i=0;i< matrixSize;++i)
     for(int j=0;j< matrixSize;++j)
         distanceMatrix[j][i]=distanceMatrixItems.at(j).at(i)->text().toInt(isNum,10);

 for (int i=0; i< matrixSize; ++i)
  {
   used[i]=0;
    for(int j=0;j< matrixSize;++j)
       spanningMatrix[i][j]=0;
  }

 used[0]=1;
 do {
     min=numeric_limits<int>::max();
     for(int i=0;i<matrixSize;++i)
     {
        if (used[i])
         {
            for(int j=0;j<matrixSize;++j)
                if ( (distanceMatrix[j][i] < min) && (distanceMatrix[j][i]!=0) && (used[j])==0)
                    min=distanceMatrix[j][i];
          }
     }
 for(int i=0;i < matrixSize;++i)
   for(int j=0;j<matrixSize;++j)
        if( (distanceMatrix[j][i]== min) && (used[j]==0) && (used[ i ] == 1))
            {
                used[j] =1;
                spanningMatrix[j][i]= spanningMatrix[i][j] = min;
                count++;
                i=matrixSize;
                break;
            }
       }while(count  < matrixSize-1);

 spanningMatrixModel->clear ();
 for(int i=0;i<matrixSize;++i)
  {
    for (int j=0;j<matrixSize;++j)
         if(spanningMatrix[i][j] == 0 && i!=j)
              buf.push_back(new QStandardItem("*"));
    else
          buf.push_back(new QStandardItem (bufstring.setNum(spanningMatrix[i][j],10)));
    spanningMatrixModel->insertRow(i,buf);
    buf.clear();
   }
 buf.~QList();
 int max=spanningMatrix[0][0];
 int min2=numeric_limits<int>::max();
 for (int i=0;i<matrixSize;++i)
     for (int j=0;j<matrixSize;++j)
     {
         if (spanningMatrix[i][j] > max)
              max= spanningMatrix[i][j];
         if (spanningMatrix[i][j] < min2 && spanningMatrix[i][j] != 0 )
              min2 = spanningMatrix[i][j];
     }
 for(int i=0;i<matrixSize;++i)
 {
     spanningMatrixModel->setHorizontalHeaderItem(i,new QStandardItem(vHeaderData.at(i)));
     spanningMatrixModel->setVerticalHeaderItem(i,new QStandardItem(vHeaderData.at(i)));
 }
 emit spanningMatrixCalculated(max,min2);
 emit spanningMatrixCalculated(spanningMatrixModel);
}



void Model::calculateNewVisualResult(QStandardItemModel *model)
{
    graphicsItems.clear();
    visualResultModel->clear();
    static QFont font("Times",9);
    static QFontMetrics fn (font);
    static QPen pen  (*(new QBrush(Qt::blue,Qt::SolidPattern)),0.5,Qt::DashLine, Qt::SquareCap,Qt::MiterJoin);
    static QPen pen2 (*(new QBrush(Qt::black,Qt::SolidPattern)),3,Qt::SolidLine, Qt::SquareCap,Qt::MiterJoin);
    QGraphicsLineItem *line;
    static qreal x = -1;
    qreal y= -5;
    static qreal yGrow = fn.height()-1.2;
//    qreal itemsSpaceHeight= (fn.height() )* model->rowCount();
//    qreal freespaceHeight = (fn.height()*19 ) - itemsSpaceHeight;
//    yGrow = freespaceHeight/ (model->rowCount() -2);
    static int maxSize =0;
    graphicsItems.push_back(qMakePair(QPointF(fn.width(model->horizontalHeaderItem(0)->text()),fn.height()/2)
                                      ,visualResultModel->addText(model->horizontalHeaderItem(0)->text(),font)));
    graphicsItems[0].second->setPos(x,y);
    maxSize = fn.width(graphicsItems.at(0).second->toPlainText());
    for(int i=1;i<model->rowCount();++i)
    {
        graphicsItems.push_back(qMakePair(QPointF(0,0),
                                visualResultModel->addText(model->horizontalHeaderItem(i)->text(),font)));
        graphicsItems[i].second->setPos(x,y+yGrow);
        y=graphicsItems.at(i).second->pos().y();
        graphicsItems[i].first.setX(fn.width(graphicsItems[i].second->toPlainText()));
        graphicsItems[i].first.setY(y+(yGrow-1.6));
        if (maxSize < fn.width(graphicsItems.at(i).second->toPlainText()))
             maxSize = fn.width(graphicsItems.at(i).second->toPlainText());
    }
    line = visualResultModel->addLine(maxSize+8,0,maxSize+8,visualResultModel->height()+400,pen2);
    thresholdLine->setLine(maxSize+12,0,maxSize+12,visualResultModel->height());
    thresholdLine = visualResultModel->addLine(thresholdLine->line(),pen);
    for(int i=0;i<graphicsItems.size();++i)
    {
        visualResultModel->addLine(graphicsItems.at(i).first.x()+3,
                                   graphicsItems.at(i).first.y(),
                                   maxSize+8,
                                   graphicsItems.at(i).first.y());
        graphicsItems[i].first.setX(maxSize+8);
    }

 emit spanningMatrixCalculated_(model);
}

void Model::_calculateVisualResult()
{
    graphicsItems.clear();
    visualResultModel->clear();
    static QFont font("Times",9);
    static QFontMetrics fn (font);
    static QPen pen  (*(new QBrush(Qt::blue,Qt::SolidPattern)),0.5,Qt::DashLine, Qt::SquareCap,Qt::MiterJoin);
    static QPen pen2 (*(new QBrush(Qt::black,Qt::SolidPattern)),3,Qt::SolidLine, Qt::SquareCap,Qt::MiterJoin);
    static qreal x = -1;
    qreal y= -5;
    static qreal yGrow = fn.height()-1.2;
    static int maxSize =0;
    graphicsItems.push_back(qMakePair(QPointF(fn.width(spanningMatrixModel->horizontalHeaderItem(0)->text()),fn.height()/2)
                                      ,visualResultModel->addText(spanningMatrixModel->horizontalHeaderItem(0)->text(),font)));
    graphicsItems[0].second->setPos(x,y);
    maxSize = fn.width(graphicsItems.at(0).second->toPlainText());
    for(int i=1;i<spanningMatrixModel->rowCount();++i)
    {
        graphicsItems.push_back(qMakePair(QPointF(0,0),
                                visualResultModel->addText(spanningMatrixModel->horizontalHeaderItem(i)->text(),font)));
        graphicsItems[i].second->setPos(x,y+yGrow);
        y=graphicsItems.at(i).second->pos().y();
        graphicsItems[i].first.setX(fn.width(graphicsItems[i].second->toPlainText()));
        graphicsItems[i].first.setY(y+ (yGrow-1.6));
        if (maxSize < fn.width(graphicsItems.at(i).second->toPlainText()))
             maxSize = fn.width(graphicsItems.at(i).second->toPlainText());
    }
    visualResultModel->addLine(maxSize+8,0,maxSize+8,visualResultModel->height(),pen2);
    thresholdLine->setLine(maxSize+12,0,maxSize+12,visualResultModel->height());
    thresholdLine = visualResultModel->addLine(thresholdLine->line(),pen);
    for(int i=0;i<graphicsItems.size();++i)
    {
        visualResultModel->addLine(graphicsItems.at(i).first.x()+3,
                                   graphicsItems.at(i).first.y(),
                                   maxSize+8,
                                   graphicsItems.at(i).first.y());
        graphicsItems[i].first.setX(maxSize+8);
    }
 emit spanningMatrixCalculated_(spanningMatrixModel);
}

void Model::calculateNewClustersModel(QStandardItemModel * spanningMatrixModel)
{
        space=10;
        prevCut=0;
        clustersCuts.clear();
        values.clear();
        values.push_back(qMakePair(0L,thresholdLine->line().p1().x()));//0L - long int
        static bool *isNum = new bool;
        long int min=0;
        const int matrixSize = spanningMatrixModel->rowCount();
        int sm[matrixSize][matrixSize];
        vector<MyCluster> clusters; //  /
        vector<MyCluster> res; //   

        for (int i=0;i<matrixSize;++i)
            for (int j=0;j<matrixSize;++j)
              sm[i][j]=spanningMatrixModel->item(i,j)->text().toInt(isNum,10);

        for(int i = 0; i < matrixSize; i++)
            clusters.push_back(MyCluster(i,graphicsItems.at(i).first)); // .

        clustersCuts.insert(prevCut,(QVector<MyCluster>::fromStdVector(clusters)));// 0 

        for(int i = 0; i < matrixSize; i++)
            for(int j = 0; j < matrixSize; j++)
                if(sm[i][j] > 0)
                    clusters[i].addEdge(make_pair(j, sm[i][j]));// 

        int counter=0;//  
        do
        {
            int ii = -1, jj = -1;//  (gcc -wall)
            min = numeric_limits<int>::max();
            for(int i = 0; i < matrixSize; i++)// . 
            {
                if(clusters[i].disabled) continue;//  ,   
                for(unsigned j = 0; j < clusters[i].Edges.size(); j++)
                {
                    if((clusters[i].Edges[j].second < min) && (clusters[clusters[i].Edges[j].first].disabled == false))
                    /*
                            min (..,    
                    ),   ,     ,  ...
                    */
                    {
                        ii = i; jj = clusters[i].Edges[j].first; min = clusters[i].Edges[j].second;

                        /* ...  ii   ,     , 
                        jj -        (    ?
                        ,  ,        ii
                          jj),      */
                    }
                }

            }
            createCut(min,clusters[ii],clusters[jj]);
            // 
            clusters[ii] += clusters[jj];
            /*  : clusters[ii]  clusters[jj] */
            clusters[ii].setPos(drawClamp(clusters[ii].pos(),clusters[jj].pos(),min));
            // 
            clusters[ii].sr = min;
            /*    */
            values.push_back(qMakePair(min,clusters[ii].pos().x()));
            //         .
            for_each(clusters.begin(), clusters.end(), Updator(make_pair(jj, ii)));

            /*
               ,       ,   Updator-,  :
              ,    ,    JJ     II,
                   JJ,      ,   
             .
            */

            clusters[jj].disabled = true; // jj  
            res.push_back(clusters[ii]); //     ii
            counter = count_if(clusters.begin(), clusters.end(), IsEnabled);//   
        }
        while(counter > 1);//  ,      1
        QPen pen (*(new QBrush(Qt::black,Qt::SolidPattern)),3,Qt::SolidLine, Qt::SquareCap,Qt::MiterJoin);
        QPointF p = res.back().pos();
        visualResultModel->addLine(p.x(),p.y(),p.x()+900,p.y(),pen);//  .
        for(int i=0;i<values.size();++i)
//            qDebug() << values.at(i).second;
        setTextModel(0);
        emit clustersModelCalculated();
}

void Model::changeThresholdLinePos(int value)
{
    thresholdLine->setLine(values.at(value).second+2,thresholdLine->line().p1().y(),values.at(value).second+2,400);
    setTextModel(values.at(value).first);
    visualResultModel->update();
}

void Model::createCut(int cut, MyCluster old1, MyCluster old2)
{
    QVector <MyCluster> bufvec (clustersCuts.value(prevCut));

    for(int i=0;i<bufvec.size();++i)
        if (bufvec[i] == old2)
        {
           bufvec.remove(i);
        }

    for(int i=0;i<bufvec.size();++i)
        if (bufvec[i]== old1)
        {
            old1+=old2;
            bufvec.replace(i,old1);
        }

    clustersCuts.insert(cut,bufvec);
    prevCut=cut;
}

QPointF Model::drawClamp(const QPointF &from, const QPointF &to, long int cut)
{
  QPointF ptr;
  qreal x1,y1,x2,y2;
  if (from.x() > to.x())
  {
      x2 = from.x()+3;
      y2 = from.y();
      x1 = to.x()+3;
      y1 = to.y();
  }
   else
  {
        x1 = from.x()+3;
        y1 = from.y();
        x2 = to.x()+3;
        y2 = to.y();
   }
   space = cut;
//   if (cut > 100)
//        space = cut/10;
//    else
//     if (cut > 1000)
//        space = cut/100;
//     else
//      if(cut > 5000)
//        space = cut /500;
//      else
//       if (cut > 1000)
//        space = cut/1000;
  visualResultModel->addLine(x1,y1,x2+space,y1);
  visualResultModel->addLine(x2+space,y1,x2+space,y2);
  visualResultModel->addLine(x2+space,y2,x2,y2);
  ptr.setX(x2+space);
  ptr.setY((y1+y2)/2);
  visualResultModel->addEllipse(ptr.x(),ptr.y()-2,3,3,QPen(Qt::red),*(new QBrush(Qt::red,Qt::SolidPattern)));
  space+=3.6;
  return ptr;
}

void Model::setTextModel(int value)
{
    if(clustersCuts.contains(value))
    {
        QStringList * lst = new QStringList();
        QString bufstr("C : "), bufstrnum;
        bufstr.append(bufstrnum.setNum(value));
        *lst << bufstr;
        QVector <MyCluster> vec(clustersCuts.value(value));
        bufstr= "  : ";
        bufstr.append(bufstrnum.setNum(vec.size()));
        *lst << bufstr;
        bufstr = " %-  : ";
        for(int i=0;i<vec.size();++i)
        {
            bufstr.replace(QString("%"),bufstrnum.setNum(i+1));
            bufstr.append(vec[i].toString(&vHeaderData));
            *lst << bufstr;
            bufstr = " %-  : ";
        }
        clustersModel->setStringList(*lst);
        delete lst;
    }
}
