#ifndef MODEL_H
#define MODEL_H
#include <QtCore/QObject>
#include <QtGui/QStandardItemModel>
#include <QtGui/QStringListModel>
#include <QtCore/QFile>
#include <QtCore/QTextStream>
#include <QtCore/QStringList>
#include <QtCore/QList>
#include <QtGui/QGraphicsScene>
#include <QtGui/QFont>
#include <QtGui/QGraphicsView>
#include <QDebug>
#include <limits>
#include <QGraphicsItem>
#include <QFontMetrics>
#include <QtGui/QBrush>
#include <QPoint>
#include <QPointF>
#include <QHash>
#include <algorithm>
#include "mycluster.h"
#include "Updator.h"

class Model : public QObject
{
    Q_OBJECT

private :
    QStandardItemModel *dataMatrixModel;
    QStandardItemModel *distanceMatrixModel;
    QStandardItemModel *spanningMatrixModel;
    QStringListModel   *clustersModel;
    QStringList hHeaderData;
    QStringList vHeaderData;
    QVector < QList <QStandardItem * > > rowData;
    QGraphicsScene      *visualResultModel;
    QVector < QPair < QPointF, QGraphicsTextItem *> >  graphicsItems;
    QGraphicsLineItem * thresholdLine;
    QPointF drawClamp (const QPointF &from, const QPointF &to, long int cut );
    QVector < QPair < long int, qreal > > values;
    int prevCut;

 public :
        Model();
        qreal space;
        void _calculateVisualResult();
        void createCut(int cut, MyCluster old1, MyCluster old2);
        QVector < QList <QStandardItem * > > distanceMatrixItems;
        QHash <int, QVector<MyCluster> > clustersCuts;

public slots :
            void setUpDataMatrixModel();
            void setUpDistanceMatrixModel();
            void setUpSpaningMatrixModel();
            void setUpVisualModel();
            void setUpClustersModel();
            void calculateNewDistanceMatrixModel(int parNum,int size);
            void calculateNewSpaningMatrixModel(int matrixSize);
            void calculateNewVisualResult(QStandardItemModel * model);
            void calculateNewClustersModel(QStandardItemModel * spanningMatrixModel);
            void readData();//  
            void changeThresholdLinePos(int value);
            void setTextModel(int value);

 signals :
         void dataMatrixModelReady(QStandardItemModel *);
         void distanceMatrixModelReady(QStandardItemModel *);
         void spanningMatrixCalculated_(QStandardItemModel*);
         void spaningMatrixModelReady(QStandardItemModel *);
         void visualModelReady(QGraphicsScene *);
         void clustersModelReady(QStringListModel *);
         void dataReaded();
         void dataReaded(QStringList *);
         void dataFailedToRead(QFile * file);
         void distanceMatrixCalculated (QStandardItemModel * );
         void distanceMatrixCalculated(int);
         void spanningMatrixCalculated (QStandardItemModel * );
         void spanningMatrixCalculated (int,int );
         void clustersModelCalculated();
   };


#endif // MODEL_H