#include "mycluster.h"
#include "edgeupdate.h"
#include "Xist.h"
#include "finder.h"
#include <QVariant>
using namespace std;

void MyCluster::updateEdge(Rec myPair)
{
    for_each(Edges.begin(), Edges.end(), EdgeUpdate(myPair)); //    , edgeupdate   
}

void MyCluster :: operator += (MyCluster& cL)//  .
{
    // 0     cL.vx  this->vx
    remove_copy_if(cL.vx.begin(), cL.vx.end(), back_inserter(vx), bind2nd(Xists(), vx));
    // 1  cL.Edges   Edges
    copy(cL.Edges.begin(), cL.Edges.end(), back_inserter(Edges));
    // 2      Edges,  
    // ,   finder
    Edges.erase(remove_if(Edges.begin(), Edges.end(), bind2nd(finder(), vx)),
                Edges.end());
}

void MyCluster::addEdge(Rec where)//  
{
    Edges.push_back(where);
}

QString MyCluster::toString(QStringList *list)
{
    QString str;
    vector<int>::iterator it;
    str.append("{ ");
    for(it=vx.begin();it != vx.end();it++)
        if (it==vx.end()-1)
            str.append((list->at(*it)+" }"));
    else
        str.append((list->at(*it)+" , "));
    return str;
}