#ifndef MYCLUSTER_H
#define MYCLUSTER_H
#include <vector>
#include <algorithm>
#include <QString>
#include <QStringList>
#include <QPointF>

using namespace std;

typedef pair<int, int> Rec; //    ,  -  .

class MyCluster
{
    vector <int> vx; // ,       
public:
    int sr; //  
    QPointF pos_;
    bool disabled; //     
    vector<Rec> Edges; // 
    int cut() {return sr;};
    const QPointF& pos() const {return pos_;};
    const int & cut() const {return sr;};
    const vector<int> getVertexes() const {return vx;};
    MyCluster () {};//empty
    void setPos(const QPointF & newPos)
    {
        pos_.setX(newPos.x());
        pos_.setY(newPos.y());
    };

    MyCluster(int vertex , QPointF position): sr(0), disabled(false)
    {
        pos_.setX(position.x());
        pos_.setY(position.y());
        vx.push_back(vertex); //      
    }

    MyCluster(int vertex ): sr(0), disabled(false)
    {
        vx.push_back(vertex); //      
    }
    void updateEdge(Rec);
    void addEdge(Rec where);//  
    QString toString(QStringList * list);
    void operator += (MyCluster&);
    inline bool operator==(const MyCluster &other)
    {
        bool b;
           if  (vx.size() == other.getVertexes().size())
        {
               for(unsigned int i=0;i<vx.size();++i)
                   b= (vx.at(i)== other.getVertexes().at(i));
               return b;
        }
        return false;
    }
};

#endif // MYCLUSTER_H
