#include "view.h"
#include <QDebug>
View::View(QWidget *parent)
    : QWidget(parent)
{
    createWidgets();
    layoutWidgets();
}

View::~View()
{

}

void View::createWidgets()
{
    mainLayout = new QVBoxLayout(this);
    dataControlLayout = new QHBoxLayout();
    calcLayout = new QHBoxLayout();
    controlLayout = new QVBoxLayout();
    dataMatrixLayout = new QVBoxLayout();
    resultLayout = new QVBoxLayout();
    distanceMatrixLayout = new QVBoxLayout();
    spanningMatrixLayout = new QVBoxLayout();
    thresholdCloseLayout = new QGridLayout();
    dataMatrixLabel = new QLabel(" ");
    distanceMatrixLabel = new QLabel(" ");
    thresholdCloseLabel = new QLabel(" ");
    resultLabel = new QLabel("  ");
    spanningMatrixLabel = new QLabel("  ");
    viewCountLabel = new QLabel("\n ");
    viewCountColumnsLabel= new QLabel("\n ");
    exitButton = new QPushButton("");
    dataMatrixView = new QTableView();
    distanceMatrixView = new QTableView();
    spanningMatrixView = new QTableView();
    clustersView = new QListView();
    visualClustersView = new QGraphicsView();
    viewCountSpinBox = new QSpinBox();
    viewCountColumsSpinBox = new QSpinBox();
    thresholdCloseSpinBox = new QSpinBox();
    parametersSwithcerBar = new QTabBar();
}

void View::layoutWidgets()
{
 dataMatrixLayout->addWidget(dataMatrixLabel);
 dataMatrixLayout->addWidget(dataMatrixView);

 resultLayout->addWidget(resultLabel);
 resultLayout->addWidget(clustersView);

 controlLayout->addItem(new QSpacerItem(20, 40, QSizePolicy::Fixed, QSizePolicy::Fixed));
 controlLayout->addWidget(viewCountLabel);
 controlLayout->addWidget(viewCountSpinBox);
 controlLayout->addWidget(viewCountColumnsLabel);
 controlLayout->addWidget(viewCountColumsSpinBox);
 controlLayout->addWidget(exitButton);
 controlLayout->addItem(new QSpacerItem(20, 100, QSizePolicy::Fixed, QSizePolicy::Fixed));

 thresholdCloseLayout->addWidget(thresholdCloseLabel,0,0,1,2);
 thresholdCloseLayout->addWidget(visualClustersView,3,0,1,1);
 thresholdCloseLayout->addWidget(thresholdCloseSpinBox,1,0,1,2);

 dataControlLayout->addLayout(dataMatrixLayout);
 dataControlLayout->addLayout(thresholdCloseLayout);
 dataControlLayout->addLayout(controlLayout);

 distanceMatrixLayout->addWidget(distanceMatrixLabel);
 distanceMatrixLayout->addWidget(distanceMatrixView);

 spanningMatrixLayout->addWidget(spanningMatrixLabel);
 spanningMatrixLayout->addWidget(spanningMatrixView);

 calcLayout->addLayout(distanceMatrixLayout);
 calcLayout->addLayout(spanningMatrixLayout);
 calcLayout->addLayout(resultLayout);

 mainLayout->addLayout(dataControlLayout);
 mainLayout->addWidget(parametersSwithcerBar);
 mainLayout->addLayout(calcLayout);
 viewCountSpinBox->setEnabled(false);
 viewCountColumsSpinBox->setEnabled(false);
 visualClustersView->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
 visualClustersView->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
 setLayout(mainLayout);
}

void View::setDataMatrixModel(QStandardItemModel* dataMatrixModel)
{
    dataMatrixView->setModel(dataMatrixModel);
    for (int i=0;i<dataMatrixModel->rowCount();++i)
         dataMatrixView->setRowHeight(i,18);
    for(int i=0;i<dataMatrixModel->columnCount();++i)
           dataMatrixView->setColumnWidth(i,100);
    dataMatrixView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    dataMatrixView->clearSpans();
    viewCountSpinBox->setMinimum( 2 );
    viewCountSpinBox->setMaximum(dataMatrixModel->rowCount());
    viewCountSpinBox->setValue(dataMatrixModel->rowCount());
    viewCountColumsSpinBox->setMinimum(1);
    viewCountColumsSpinBox->setMaximum(dataMatrixModel->columnCount());
    viewCountColumsSpinBox->setValue(viewCountColumsSpinBox->maximum());
    emit dataMatrixModelSet();
}

void View::showFileErrorMessage(QFile * file)
{
QMessageBox::critical(this, tr("Clusters"),
                              tr("Unable to open file: %1.\nProgram will be closed")
                              .arg(file->fileName()));
close();
}

void View::setEnabledViewCountSpinBox()
{
  viewCountSpinBox->setEnabled(true);
}

void View::setParameterSwitcherBar(QStringList * lst)
{
    for(int i=0;i<lst->size();++i)
    parametersSwithcerBar->addTab(lst->at(i));
}

void View::setDistanceMatrixModel(QStandardItemModel * distanceMatrixModel)
{
    distanceMatrixView->setModel(distanceMatrixModel);
    for(int i=0;i<distanceMatrixModel->rowCount();++i)
    {
        distanceMatrixView->setRowHeight(i,18);
        distanceMatrixView->setColumnWidth(i,100);
    }
    distanceMatrixView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    distanceMatrixView->clearSpans();
    distanceMatrixView->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    emit distanceMatrixModelSet();
}

void View::updateDistanceMatrixModel(QStandardItemModel * newDistanceMatrixModel)
{
        for(int i=0;i<newDistanceMatrixModel->rowCount();++i)
    {
        distanceMatrixView->setRowHeight(i,18);
        distanceMatrixView->setColumnWidth(i,100);
    }
        emit(distanceMatrixModelSet(viewCountSpinBox->value()));
}

void View::setSpaningMatrixModel(QStandardItemModel * spaningMatrixModel)
{
  spanningMatrixView->setModel(spaningMatrixModel);
    for(int i=0;i<spaningMatrixModel->rowCount();++i)
    {
        spanningMatrixView->setRowHeight(i,18);
        spanningMatrixView->setColumnWidth(i,100);
    }
    spanningMatrixView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    spanningMatrixView->clearSpans();
    spanningMatrixView->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    emit spaningMatrixModelSet();
}

void View::updateSpaningMatrixModel(QStandardItemModel * newSpaningMatrixModel)
{
    for (int i =0;i<newSpaningMatrixModel->rowCount();++i)
    {
        spanningMatrixView->setRowHeight(i,18);
        spanningMatrixView->setColumnWidth(i,100);
    }
    emit spaningMatrixModelSet(viewCountSpinBox->value());
}

void View::setViewCount(int i)
{
    for(int j=0;j<dataMatrixView->model()->rowCount();++j)
    {
        dataMatrixView->setRowHidden(j,true);
        distanceMatrixView->setRowHidden(j,true);
        distanceMatrixView->setColumnHidden(j,true);
        spanningMatrixView->setColumnHidden(j,true);
        spanningMatrixView->setRowHidden(j,true);
    }
    for (int j=0;j<i;++j)
    {
        dataMatrixView->setRowHidden(j,false);
        distanceMatrixView->setRowHidden(j,false);
        distanceMatrixView->setColumnHidden(j,false);
        spanningMatrixView->setRowHidden(j,false);
        spanningMatrixView->setColumnHidden(j,false);
    }
}

void View::setEnabledViewColumnSpinBox()
{
    viewCountColumsSpinBox->setEnabled(true);
}

void View::setViewCountColumns(int i)
{
    for (int j=0;j<dataMatrixView->model()->columnCount();++j)
         dataMatrixView->setColumnHidden(j,true);
    for(int j=0;j<i;++j)
        dataMatrixView->setColumnHidden(j,false);
    static int prev=parametersSwithcerBar->count();
    if (prev > viewCountColumsSpinBox->value())
            parametersSwithcerBar->removeTab(viewCountColumsSpinBox->value());
    else
     if ( prev < viewCountColumsSpinBox->value())
        parametersSwithcerBar->addTab(dataMatrixView->horizontalHeader()->model()->headerData(viewCountColumsSpinBox->value()-1,Qt::Horizontal).toString());
    prev = viewCountColumsSpinBox->value();
}

void View::prepareData(int parNum)
{
    emit dataPrepared(parNum,(distanceMatrixView->horizontalHeader()->count() - distanceMatrixView->horizontalHeader()->hiddenSectionCount()));
}

void View::setUpThresholdControllers(QStandardItemModel * model)
{
    thresholdCloseSpinBox->setRange(0,model->rowCount()-1);
    thresholdCloseSpinBox->setValue(thresholdCloseSpinBox->minimum());
    thresholdCloseSpinBox->setPrefix("   ");
    thresholdCloseSpinBox->setSuffix(" ");
    thresholdCloseSpinBox->setSpecialValueText(" ");
    thresholdCloseSpinBox->setSingleStep(1);
}

void View::setVisualModel(QGraphicsScene * model)
{
        visualClustersView->setScene(model);
        visualClustersView->setSceneRect(0,0,visualClustersView->width(),visualClustersView->height()-7);
}

void View::setClustersModel(QStringListModel *model)
{
    clustersView->setModel(model);
    clustersView->setWordWrap(true);
    clustersView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    emit clustersModelSet();
}
