#ifndef VIEW_H
#define VIEW_H

#include <QtGui/QWidget>
#include <QtGui/QGraphicsView>
#include <QtGui/QGraphicsScene>
#include <QtGui/QGridLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QLabel>
#include <QtGui/QListView>
#include <QtGui/QPushButton>
#include <QtGui/QSlider>
#include <QtGui/QSpinBox>
#include <QtGui/QTableView>
#include <QtGui/QVBoxLayout>
#include <QtGui/QStandardItemModel>
#include <QtGui/QMessageBox>
#include <QtGui/QHeaderView>
#include <QtCore/QFile>
#include <QtCore/QStringList>
#include <QtGui/QScrollBar>
#include <QtGui/QSpacerItem>
#include <QtGui/QStringListModel>

class View : public QWidget
{
    Q_OBJECT

public:
    View(QWidget *parent = 0);
    ~View();

QPushButton     *exitButton;// ""
QTableView      *dataMatrixView;//   
QTableView      *distanceMatrixView;//   
QTableView      *spanningMatrixView;//    
QListView       *clustersView;//   . 
QGraphicsView   *visualClustersView;//    
QSpinBox        *viewCountSpinBox;//    
QSpinBox        *viewCountColumsSpinBox;//    
QSpinBox        *thresholdCloseSpinBox;//    
QTabBar         *parametersSwithcerBar;//  ..

public slots :

        void showFileErrorMessage(QFile * file);//     
        void setDataMatrixModel(QStandardItemModel * dataMatrixModel);
        void setDistanceMatrixModel(QStandardItemModel * distanceMatrixModel);
        void setSpaningMatrixModel(QStandardItemModel * spaningMatrixModel);
        void setVisualModel(QGraphicsScene * model);
        void setClustersModel(QStringListModel *model);
        void updateDistanceMatrixModel(QStandardItemModel * newDistanceMatrixModel);
        void updateSpaningMatrixModel(QStandardItemModel * newSpaningMatrixModel);
        void setParameterSwitcherBar(QStringList * lst);
        void setEnabledViewCountSpinBox();
        void setEnabledViewColumnSpinBox();
        void setViewCount(int i);
        void setViewCountColumns(int i);
        void prepareData(int parNum);
        void setUpThresholdControllers(QStandardItemModel * model);

private :

void createWidgets();
void layoutWidgets();

QVBoxLayout     *mainLayout;// 
QHBoxLayout     *dataControlLayout;//   ,    
QHBoxLayout     *calcLayout;//         
QVBoxLayout     *controlLayout;//   
QVBoxLayout     *dataMatrixLayout;//   
QVBoxLayout     *resultLayout;//    
QVBoxLayout     *distanceMatrixLayout;//   
QVBoxLayout     *spanningMatrixLayout;//    
QGridLayout     *thresholdCloseLayout;//   
QLabel          *dataMatrixLabel;//   
QLabel          *resultLabel;//   
QLabel          *viewCountLabel;//    
QLabel          *viewCountColumnsLabel;//    
QLabel          *distanceMatrixLabel;//   
QLabel          *spanningMatrixLabel;//    
QLabel          *thresholdCloseLabel;//   

signals :
        void dataMatrixModelSet();
        void distanceMatrixModelSet();
        void distanceMatrixModelSet(int);
        void spaningMatrixModelSet();
        void spaningMatrixModelSet(int);
        void visualModelSet();
        void clustersModelSet();
        void dataPrepared(int, int);

};
#endif // VIEW_H
