#include "recognizer.h"
#include "ui_recognizer.h"
#include <QDebug>
#include <QRect>
#include <iostream>
using namespace std;
recognizer::recognizer(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::recognizer)
{
    ui->setupUi(this);
   // 
    getButtons();
    //  
    setConnections();
    // 
    painter = new QPainter();
    etalonSymbolPixmap = new QPixmap(ui->etalonSymbol->size());
    etalonPixelsNetPixmap = new QPixmap(ui->etalonPixelsNet->size());
    inputSymbolPixmap = new QPixmap(ui->inputSymbolFiled->size());
    inputPixelsNetPixmap = new QPixmap(ui->inputSymbolPixelsNet->size());
    ui->inputSymbolFiled->installEventFilter(this);
    // 
    font.setFamily("Comic Sans MS");
    font.setPointSize(130);
    // 
    drawPen.setColor(Qt::black);
    drawPen.setCapStyle(Qt::RoundCap);
    drawPen.setBrush(Qt::SolidPattern);
    drawPen.setWidth(17);
    drawPen.setStyle(Qt::SolidLine);
    drawPen.setJoinStyle(Qt::RoundJoin);
    //    
    this->clearPixmaps();
    // 
    this->setFixedSize(891,513);
}

recognizer::~recognizer()
{
    delete ui;
}

void recognizer::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void recognizer::clearPixmaps()
{
    //   
    etalonSymbolPixmap->fill();
    etalonPixelsNetPixmap->fill();
    inputPixelsNetPixmap->fill();
    inputSymbolPixmap->fill();
    //   2 
    painter->begin(etalonPixelsNetPixmap);
    painter->fillRect(etalonPixelsNetPixmap->rect(),QBrush(Qt::gray,Qt::CrossPattern));
    painter->end();
    painter->begin(inputPixelsNetPixmap);
    painter->fillRect(inputPixelsNetPixmap->rect(),QBrush(Qt::gray,Qt::CrossPattern));
    painter->end();
    // 
    ui->etalonSymbol->setPixmap(*etalonSymbolPixmap);
    ui->etalonPixelsNet->setPixmap(*etalonPixelsNetPixmap);
    ui->inputSymbolFiled->setPixmap(*inputSymbolPixmap);
    ui->inputSymbolPixelsNet->setPixmap(*inputPixelsNetPixmap);
}

void recognizer::drawLetter()
{
    // 
    QString letter ((qobject_cast<QPushButton*>(sender()))->text());
    etalonSymbolPixmap->fill();
    painter->begin(etalonSymbolPixmap);
    painter->setFont(font);
    painter->drawText(etalonSymbolPixmap->rect(),Qt::AlignCenter,letter);
    painter->end();
    ui->etalonSymbol->setPixmap(*etalonSymbolPixmap);
    getArray(etalonSymbolPixmap->toImage());
}

void recognizer::getArray(QImage image)
{
    QString str;
    QStringList arrayList;
    int h=image.height();
    int w=image.width();
    int matrix[30][30]={0};
    int value = 32;
    for(int i=0;i<w;++i)
        for(int j=0;j<h;++j)
            matrix[i/8][j/8]+=(image.pixel(i,j)==Qt::black)? 1 : 0;
    for(int i = 0; i < 30; i++)
    {
        for(int j = 0; j < 30; j++)
        {
            matrix[i][j] /= value;
            str.append(QString::number(matrix[i][j]));
        }
        arrayList << str;
        str.clear();
    }
    etalonArrayModel.setStringList(arrayList);
    ui->etalonArray->setModel(&etalonArrayModel);
}

void recognizer::drawEtalonPixelsMap()
{
}

bool recognizer::eventFilter(QObject *o, QEvent *e)
{//  
    QMouseEvent me = *(static_cast<QMouseEvent*> (e));
    if (o == ui->inputSymbolFiled)
    {
        if (me.type()== QEvent::MouseButtonPress)
           {
               if(me.button() == Qt::LeftButton)
                {
                   painter->begin(inputSymbolPixmap);
                   painter->setRenderHint(QPainter::HighQualityAntialiasing,true);
                   painter->setPen(drawPen);
                   painter->drawLine(me.pos(),me.pos());
                   painter->end();
                   lastpoint=me.pos();
                   ui->inputSymbolFiled->setPixmap(*inputSymbolPixmap);
                   return true;
                }
           }else
               if (me.type() == QEvent::MouseMove)
               {
                 painter->begin(inputSymbolPixmap);
                 painter->setRenderHint(QPainter::HighQualityAntialiasing,true);
                 painter->setPen(drawPen);
                 painter->drawLine(lastpoint,me.pos());
                 painter->end();
                 lastpoint=me.pos();
                 ui->inputSymbolFiled->setPixmap(*inputSymbolPixmap);
                 return true;
                }
    }
    return QWidget::eventFilter(o,e);
}

void recognizer::setConnections()
{
    connect(ui->clearButton,SIGNAL(clicked()),this,SLOT(clearPixmaps()));
    for(int i=0;i<buttons.size();++i)
    {
        connect(buttons[i],SIGNAL(clicked()),this,SLOT(drawLetter()));
        connect(buttons[i],SIGNAL(clicked()),this,SLOT(clearInputField()));
    }
}

void recognizer::clearInputField()
{
    //    
    inputSymbolPixmap->fill();
    ui->inputSymbolFiled->setPixmap(*inputSymbolPixmap);
}

void recognizer::getButtons()
{
    // 
    buttons.push_back(ui->letterButtonA);
    buttons.push_back(ui->letterButtonB);
    buttons.push_back(ui->letterButtonC);
    buttons.push_back(ui->letterButtonD);
    buttons.push_back(ui->letterButtonE);
    buttons.push_back(ui->letterButtonF);
    buttons.push_back(ui->letterButtonG);
    buttons.push_back(ui->letterButtonH);
    buttons.push_back(ui->letterButtonI);
    buttons.push_back(ui->letterButtonJ);
    buttons.push_back(ui->letterButtonK);
    buttons.push_back(ui->letterButtonL);
    buttons.push_back(ui->letterButtonM);
    buttons.push_back(ui->letterButtonN);
    buttons.push_back(ui->letterButtonO);
    buttons.push_back(ui->letterButtonP);
    buttons.push_back(ui->letterButtonQ);
    buttons.push_back(ui->letterButtonR);
    buttons.push_back(ui->letterButtonS);
    buttons.push_back(ui->letterButtonT);
    buttons.push_back(ui->letterButtonU);
    buttons.push_back(ui->letterButtonV);
    buttons.push_back(ui->letterButtonW);
    buttons.push_back(ui->letterButtonX);
    buttons.push_back(ui->letterButtonY);
    buttons.push_back(ui->letterButtonZ);
}
