unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OpenGL, StdCtrls, Buttons, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    TTT1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure DrawScene;
    procedure TTT1Click(Sender: TObject);
    procedure SetDCPixelFormat;
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
    DC : HDC; //  
    hrc : HGLRC; //     OpenGL
   // procedure SetDCPixelFormat;              //   
  public
    { Public declarations }
    pfd: TPixelFormatDescriptor;
  end;
var
  Form1: TForm1;
  Sin_, Cos_:array of single;
  n,sizeP,WidthL:integer;
  red,green,blue,redL,greenL,blueL:glfloat;
implementation

uses Unit2;


{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  SizeP:=1;
  WidthL:=10;
  DC := GetDC(Handle);         //    Windows
  SetDCPixelFormat;            //   
  hrc := wglCreateContext(DC); //    OpenGL
  wglMakeCurrent(DC, hrc);     //   
end;

//   
procedure TForm1.SetDCPixelFormat;
var
  nPixelFormat: Integer;
  pfd: TPixelFormatDescriptor; //   

begin
  FillChar(pfd, SizeOf(pfd), 0);

  with pfd do begin
    nSize     := sizeof(pfd);          //  
    nVersion  := 1;                    //  
    dwFlags   := PFD_DOUBLEBUFFER;  //  
    iPixelType:= PFD_TYPE_RGBA;        //    
    cColorBits:= 16;                   //       
    cDepthBits:= 32;                   //    ( z)
    iLayerType:= PFD_MAIN_PLANE;       //  
  end;

  //   -     
  nPixelFormat := ChoosePixelFormat(DC, @pfd);
  //      
  SetPixelFormat(DC, nPixelFormat, @pfd);

  DescribePixelFormat(DC, nPixelFormat, sizeof(TPixelFormatDescriptor), pfd);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  wglMakeCurrent (0, 0);
  wglDeleteContext (hrc);
  ReleaseDC (Handle, DC);
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
glViewPort(0,0,ClientWidth,ClientHeight);
wglMakeCurrent ( Canvas.Handle , hrc );
glClearColor ( 0.9 , 0.9 , 1, 1.0 );
glClear ( GL_COLOR_BUFFER_BIT );
DrawScene;
wglMakeCurrent ( 0 , 0 );
  SwapBuffers(Canvas.Handle);
end;

procedure TForm1.DrawScene;
var
  i, j: Integer;
begin
glViewPort(0,0,ClientWidth,ClientHeight);
  glPointSize(SizeP);
  glColor3f(red, green, blue);
  glBegin(GL_POINTS);
   for i := 0 to 500 do
    begin
      for j := 0 to i do
      begin
        glVertex2f(- i / 15, j / 15);
      end;
    end;
  glEnd;
glDisable(GL_POINT_SMOOTH);

  glLineWidth(WidthL);
  glColor3f(redL, greenL, blueL);

  {  6- }
  glBegin(GL_LINE_STRIP);
  for i:=0 to 2 do
  begin
 glVertex(i/2,i*sin(pi));
  glVertex2f(0.5,0.5);
  end;
  for i:=0 to 2 do
  begin
  glVertex(i/2,i*cos(pi/2)+1);
   glVertex2f(0.5,0.5);
  end;
  glEnd;
end;


procedure TForm1.TTT1Click(Sender: TObject);
begin
Form2.ShowModal;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
Form1.OnPaint(Form1);
end;

end.

