{$mode objfpc}
unit uSnow;

interface
uses graph, uList;

type
  ptsnowlist = ^tsnowlist;

  ptsnow = ^tsnow;
  tsnow = object
    x, y: integer;
    Vx, Vy: double;

    active: boolean;

    constructor init;
    constructor falling(px, py: integer; pmass: integer);
    destructor done; virtual;

    procedure show; virtual;
    procedure hide; virtual;
    procedure recalc(const branches: array of Pointer;
                     psL: ptsnowlist); virtual;

  private
    mass: integer;
    under: integer;
  public
    fall: boolean;
  end;

  tsnowlist = specialize tlist<ptsnow>;

const
  snow_color = white;
  snow_count: longint = 0;

procedure refresh(p: ptsnow);
function snow_item_compare(const a, b: ptsnow): boolean;

operator = (const left, right: TSnow): boolean;
procedure destroy_snow(p: ptsnow);


implementation
uses uEqua, uScene;

const
  VScale = 1.25;
  wind_probability = 0.01;

procedure destroy_snow(p: ptsnow);
begin
  dispose(p, done);
end;


procedure refresh(p: ptsnow);
{$ifndef FPC} far; {$endif}
type
  ArrBranches = array[0 .. pred(max_branches)] of Pointer;
begin
  with p^ do
    if active then begin
      hide; recalc(ArrBranches(scene.branches), @(scene.snowlist)); show;
    end;
end;

function snow_item_compare(const a, b: ptsnow): boolean;
{$ifndef FPC} far; {$endif}
begin
  snow_item_compare := a^ = b^;
    // (a^.active = b^.active) and (a^.fall = b^.fall)
end;

operator = (const left, right: TSnow): boolean;
begin
  result := (left.active = right.active) and (left.fall = right.fall);
end;




constructor tsnow.init;
const
  every = 2000;
begin
  inherited;
  fall := false;

  inc(snow_count);
  if snow_count = every then begin

    snow_count := 0;
    ground.DecreaseLevel;

  end;

  active := true;
  mass := random(5) + 1;

  x := random(getmaxx);
  y := random(getmaxy div 4);

  Vx := random(5) - 2;
  Vy := mass * VScale;

  show;
end;
constructor tsnow.falling(px, py: integer; pmass: integer);
begin
  fall := true;

  mass := pmass;
  x := px; y := py;

  Vx := 0;
  Vy := mass * VScale;
  active := true;

  show;
end;


destructor tsnow.done;
begin
  // ...
end;

procedure tsnow.show;
begin
  under := getpixel(x, y);
  if under = snow_color then under := -1
  else putpixel(x, y, white);
end;
procedure tsnow.hide;
begin
  if under <> -1 then
    putpixel(x, y, under);
end;

procedure append_fall(var sl: tsnowlist;
          count: integer; left, height, width, speed: integer);
{$ifndef FPC} far; {$endif}
var i: integer;
begin
  for i := 1 to count do
    sl.append( new(ptsnow, falling(left + random(width),
                           height, speed + random(5))) );

end;

procedure tsnow.recalc(const branches: array of Pointer;
                       psL: ptsnowlist);
var
  i: integer;
  range_out: boolean;
  stop_calc: boolean;
const
  fall_count: integer = 0;
  fall_max = 10;
begin
  if random < wind_probability then Vx := - Vx;

  x := trunc(x + vx);
  y := trunc(y + vy);

  stop_calc := false;
  for i := 0 to pred(branches_count) do
    with PTBranch(branches[i])^ do
    begin

      if (x >= GetLeft) and (x < GetRight) and
         (y <= GetHeight) and (y >= GetHeight - arr^[x - GetLeft]) then
      begin
        update(x, mass, psL^, @append_fall);
        hide;

        active := false;
        stop_calc := true;

        break;
      end;

    end;

  if not stop_calc then
    if y >= ground.GetValue(x, range_out) then begin

      if not range_out then begin

        if not fall then ground.update(x)
        else begin

          if fall_count = 0 then begin
            ground.update(x); inc(fall_count);
          end
          else begin
            inc(fall_count);
            if fall_count > fall_max then fall_count := 0;
          end;

        end

      end;
      active := false;

    end;
end;

end.
