{$mode objfpc}

{.$define FROM_FILE}
{$define TEST_BASS}

{.$define DEBUG_IT}


uses
  {$ifdef DEBUG_IT}
    heaptrc, lineinfo,
  {$endif}

  crt, graph,
  {$ifdef FPC}
    sysutils, mmsystem,
  {$endif}
  {$ifdef TEST_BASS}
    classes, lbass,
  {$endif}
  uList, uEqua, uSnow, uLight, uScene;

{$ifndef FROM_FILE}
  {$ifndef TEST_BASS}
    {$INFO Compilation time will be a little bit longer than usual}
    {$I song.pp}
  {$else}
    {$I elka_01.pas}
  {$endif}
{$endif}

{$ifdef FROM_FILE}
const
  FileName = 'gg_final.wav';
{$endif}
{$ifdef TEST_BASS}
const
  FileName = 'elka.mp3';
var
  sound: TBass;
  ms: TMemoryStream;
{$endif}

begin
  scene.init;

  {$ifdef FROM_FILE}
    PlaySound(Filename, 0, SND_ASYNC Or SND_LOOP);
  {$else}
    {$ifdef TEST_BASS}
      // ***
      ms := TMemoryStream.create;
      try
        ms.Write(ArrByte[0], ArrLen);
        ms.SaveToFile(ExtractFilePath(ParamStr(0)) + FileName);
      finally
        ms.Free;
      end;
      // ***
      sound.InitBass;
      sound.Load(FileName, 1);
      sound.Play(1, True);
    {$else}
      PlaySound(@song, 0, SND_ASYNC or SND_LOOP or SND_MEMORY);
    {$endif}
  {$endif}

  scene.run;

  {$ifdef TEST_BASS}
    sound.DoneBass;
    DeleteFile(ExtractFilePath(ParamStr(0)) + FileName);
  {$else}
    PlaySound(nil, 0, 0);
  {$endif}
  scene.done;
end.
