{$mode objfpc}
unit uFern;

interface
uses uLight, uEqua;

procedure DrawFern(level: integer; lst: PTLightList;
          var branches: array of PTBranch; x, y: integer; l, u: real);

implementation
uses graph, uFuncs;

function CheckLine(xst, yst, xfn, yfn: integer;
         var len: integer): boolean;
begin
  len := Trunc(sqrt(sqr(xfn - xst) + sqr(yfn - yst)));
  CheckLine :=
    (len > 10) and (sqr(xfn - xst) > sqr(yfn - yst));
end;


procedure MakeLineTo(level: integer; lst: PTLightlist;
          var branches: array of PTBranch; x, y: integer; l, u: real);
var
  len, i: integer;
  found: boolean;

  pnt_x, pnt_y: integer;
begin
  pnt_x := Round(x + l * cos(u));
  pnt_y := Round(y - l * sin(u));

  if Assigned(lst) then
  begin

    if CheckLine(x, y, pnt_x, pnt_y, len) then
    begin

      found := false;
      for i := 0 to pred(branches_count) do
      begin

        found := branches[i]^.GetHeight = ((y + pnt_y) div 2);
        if found then break;

      end;

      if not found then
      begin
        branches[branches_count] :=
          new(PTBranch, init((x + pnt_x) div 2,
                             (y + pnt_y) div 2, len));
        inc(branches_count);
      end;

    end;

  end;

  if assigned(lst) then
  begin

    if get_prob(97) then setcolor(green)
    else setcolor(lightgreen);

  end
  else setcolor(lightgray);

  Line(x, y, pnt_x, pnt_y);
  setcolor(lightgray);

  if level = ColorizeLevel then
  begin

    ; // do nothing

  end
  else if level = (LightsOnLevel) then
       begin
         if assigned(lst) and get_prob(75) then
           lst^.append(
             new(ptlight,
                 init(pnt_x, pnt_y,
                      light_colors[random(maxLightColors)])
             )
           );
       end;
end;


procedure DrawFern(level: integer; lst: PTLightList;
          var branches: array of PTBranch; x, y: integer; l, u: real);
begin

  if l > min then
  begin

    if (level > 1) and (level < 5) then
      DrawFern(5, lst, branches, x, y, 21, u);

    MakeLineTo(level, lst, branches, x, y, l, u);
    x := Round(x + l * cos(u));
    y := Round(y - l * sin(u));

    DrawFern(Succ(level), lst, branches, x, y, l*0.45, u - 14*pi/30);
    DrawFern(Succ(level), lst, branches, x, y, l*0.45, u + 14*pi/30);
    DrawFern(Succ(level), lst, branches, x, y, l*0.73, u + pi/30);
  end;
end;

end.
