{$mode objfpc}
unit uList;

interface

type
  generic
  TList<TType> = object

  type public
    PTItem = ^TItem;
    TItem = record
      info: TType;
      next, prev: PTItem;
    end;

    funcEachCondition = function(): boolean;
    funcEachAction = procedure(p: TType);
    funcCompare = function(const a, b: TType): boolean;

  var private
    first, last: PTItem;

  public
    constructor Init;
    destructor Done;

    procedure Invert;

    procedure Append(X: TType);
    procedure Insert(X: TType);

    function Present(X: TType; func: funcCompare): boolean;
    function Remove(X: TType; func: funcCompare;
                    OnRemove: funcEachAction): integer;

    function Empty: boolean;

    procedure ForEachTrue(cond: funcEachCondition;
              act: funcEachAction);

  private
    function Find(X: TType; func: funcCompare): PTItem;

    function CreateItem(X: TType; _next, _prev: PTItem): PTItem;
    procedure RemoveItem(p: PTItem);

    procedure InsertBefore(p: PTItem; X: TType);
    procedure InsertAfter(p: PTItem; X: TType);

  end;

implementation

function TList.CreateItem(X: TType; _next, _prev: PTItem): PTItem;
var p: PTItem;
begin
  New(p);
  with p^ do
  begin
    info := X; next := _next; prev := _prev;
  end;
  result := p;
end;

constructor TList.Init;
begin
  first := nil; last := nil;
end;

destructor TList.Done;
var p, T: ptitem;
begin
  p := first;
  while Assigned(p) do
  begin
    T := p;
    p := p^.next;

    dispose(T); T := nil;
  end;
end;

function TList.Empty: boolean;
begin
  result := not Assigned(first)
end;

{ insert new item to the start of list }
procedure TList.insert(X: TType);
var p: ptitem;
begin
  p := CreateItem(X, first, nil);

  if Empty() then last := p
  else first^.prev := p;

  first := p;
end;

{ append new item to the end of list }
procedure TList.Append(X: TType);
var p: PTItem;
begin
  p := CreateItem(x, nil, last);

  if Empty() then first := p
  else last^.next := p;

  last := p;
end;

procedure TList.Invert;
var p, T: PTItem;
begin
  if Empty() or (not Assigned(first^.next)) then exit
  else
  begin
    p := nil; last := first;
    while Assigned(first) do
    begin
      T := first^.next;
      first^.next := p;
      p := first;
      first := T
    end;
    first := p
  end
end;

procedure TList.InsertBefore(p: PTItem; X: TType);
var T: PTItem;
begin
  T := CreateItem(x, p, p^.prev);

  if T^.prev <> nil then T^.prev^.next := T
  else first := T;

  p^.prev := T
end;
procedure tlist.InsertAfter(p: PTItem; X: TType);
var T: PTItem;
begin
  T := CreateItem(x, p^.next, p);

  if T^.next <> nil then T^.next^.prev := T
  else last := T;

  p^.next := T
end;

function TList.Find(X: TType; func: funcCompare): PTItem;
var
  p: PTItem;
  ok: boolean;
begin
  p := first;
  ok := true;
  while Assigned(p) and ok do
    if func(p^.info, X) then ok := false
    else p := p^.next;

  result := p
end;

function TList.Present(X: TType; func: funcCompare): boolean;
begin
  result := (Find(X, func) <> nil)
end;


function TList.Remove(X: TType; func: funcCompare;
                      onremove: funcEachAction): integer;
var
  T: PTItem;
  count: Integer;
begin
  count := 0;
  repeat

    T := Find(X, func);
    if Assigned(T) then
    begin
      OnRemove(T^.info);
      RemoveItem(T);
      inc(count)
    end;

  until (T = nil);
  remove := count
end;


procedure TList.RemoveItem(p: PTItem);
var r: PTItem;
begin
  r := p^.prev;
  if r <> nil then r^.next := p^.next
  else first := p^.next;

  r := p^.next;
  if r <> nil then r^.prev := p^.prev
  else last := p^.prev;

  dispose(p); p := nil
end;

procedure TList.ForEachTrue(cond: funcEachCondition;
          act: funcEachAction);
var p: PTItem;
begin
  p := first;
  while p <> nil do
  begin
    if cond() then act(p^.info);
    p := p^.next;
  end;
end;

end.
