{$mode objfpc}

{.$define DEBUG_IT}
unit uScene;

interface
uses
  {$ifdef DEBUG_IT}
    SysUtils,
  {$endif}
  uList, uSnow, uLight, uEqua;

const
  //  ,   
  //  ( -  ,  )
  snow_amount  = 400;

  //   "" ,    
  max_branches = 200;

type
  TScene = object
    snowlist: TSnowList;
    lightlist: TLightList;
    branches: array[0 .. pred(max_branches)] of PTBranch;

    constructor Init;
    destructor Done;

    procedure Run;
  end;

var
  scene: TScene;

implementation
uses crt, graph, uFern, uFuncs, uFirewrk;

var
  grDriver, grMode, ErrCode:
    {$ifdef FPC}
      smallint
    {$else}
      integer
    {$endif}
  ;

{$ifndef FPC}
  {$L EGAVGA.OBJ}
  Procedure EGAVGADriverProc; External;
{$endif}

const
  to_delay =
    {$ifdef FPC}
      55
    {$else}
      1255
    {$endif}
  ;


//      ,  
//       FPC, 
//   - (, ...     
//   ).  ,    , -
//  -   .
procedure OpenGraphix;
begin
  {$ifdef FPC}
    grDriver := d8bit; grMode := m800x600;
  {$else}
    If RegisterBGIDriver(@EGAVGADriverProc) < 0 Then Begin
      WriteLn('Error registering driver: ',
              GraphErrorMsg(GraphResult));
      Halt( 100 )
    End;
    grDriver := Detect;
  {$endif}

  InitGraph(grDriver, grMode, '');
  ErrCode := GraphResult;
  if ErrCode <> grOk then begin
    Writeln('Graphics error:', GraphErrorMsg(ErrCode));
    writeln('Press Enter to halt()'); readln; halt(100);
  end;
end;
procedure CloseGraphix;
begin
  closegraph;
end;

constructor TScene.Init;
var
  i: integer;
begin
  OpenGraphix;
  randomize;

  //   .
  //      
  lightlist.Init;

  branches_count := 0;
  //    "" ,       ...
  DrawFern(1, nil, branches, 7 * GetMaxX div 8, GetMaxY, 100, pi/2);
  DrawFern(1, nil, branches, 1 * GetMaxX div 8, GetMaxY, 100, pi/2);

  // ...   -    ...
  DrawFern(1, @lightlist, branches, GetMaxX div 2, GetMaxY, 130, pi/2);
  {$ifdef FPC}
    {$ifdef DEBUG_IT} //  ,   
      OutTextXY(20, 20, IntToStr(branches_count));
    {$endif}
  {$endif}

  for i := 0 to pred(branches_count) do branches[i]^.show;
  //   (always) ,     
  //  show_lights
  lightlist.ForEachTrue(@always, @ShowLights);

  randomize;

  ground.Init;
  snowlist.Init;

  for i := 1 to snow_amount do
    snowlist.append(new(PTSnow, Init));
end;

destructor tscene.done;
var i: integer;
begin
  //   ,      TSnow,
  snowlist.ForEachTrue(@always, @destroy_snow);
  //    -  .    ...
  snowlist.done;

  ground.done;

  for i := 0 to pred(branches_count) do dispose(branches[i], Done);

  // .    -"",
  lightlist.ForEachTrue(@always, @DestroyLight);
  //   - ,    ...
  lightlist.Done;

  CloseGraphix;
end;

//   
procedure TScene.Run;
var
  i, count: integer;
  just_non_active: PTSnow;
begin
  //  "" ,  ,    
  //    ""  -   "/"
  just_non_active := new(PTSnow, Init);
  just_non_active^.active := false;

  while true do begin

    //    
    snowlist.ForEachTrue(@always, @refresh);
    just_non_active^.fall := true;

    snowlist.Remove(just_non_active, @snow_item_compare, @destroy_snow);

    //
    just_non_active^.fall := false;
    count := snowlist.Remove(just_non_active, @snow_item_compare, @destroy_snow);

    for i := 1 to count do
      snowlist.Append(new(PTSnow, Init));

    lightlist.ForEachTrue(@seldom, @LightTheLamp);

    delay(to_delay);

    if keypressed then begin
      case readkey of
        #27: break;
        #32:
          begin
            CreateFirework(snowlist, random(GetMaxX), random(GetMaxY div 4));
          end;
      end;
    end;

  end;
  dispose(just_non_active, Done);
end;

end.
