unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Grids, ComCtrls;

const
  LASTROW=49;
  LASTCOL=49;

type
  TfMain = class(TForm)
    bLoad: TBitBtn;
    bSolve: TBitBtn;
    bCheck: TBitBtn;
    bFinish: TBitBtn;
    bExit: TBitBtn;
    sgField: TStringGrid;
    fdLoad: TOpenDialog;
    lbQuestions: TListBox;
    StatusBar: TStatusBar;
    procedure FormShow(Sender: TObject);
    procedure bLoadClick(Sender: TObject);
    procedure bExitClick(Sender: TObject);
    procedure sgFieldDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure bCheckClick(Sender: TObject);
    procedure sgFieldKeyPress(Sender: TObject; var Key: Char);
    procedure bSolveClick(Sender: TObject);
    procedure bFinishClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetBtns(s: string);
    procedure ClearField(nCols,nRows: integer);
  public
    { Public declarations }
  end;

type
  TCell = record
            c: string[1];
            n: string[2];
          end;
type
  TMatrix = array[0..LASTCOL] of array[0..LASTROW] of TCell;

var
  fMain: TfMain;
  aMatrix: TMatrix;
  cPath: string;
  lCheckingMode: boolean;
  nAttempts: integer;

implementation

{$R *.dfm}

procedure TfMain.SetBtns(s: string);
begin
  bLoad.Enabled := s[1] = '1';
  bSolve.Enabled := s[2] = '1';
  bCheck.Enabled := s[3] = '1';
  bFinish.Enabled := s[4] = '1';
  bExit.Enabled := s[5] = '1';
end;

procedure TfMain.ClearField(nCols,nRows: integer);
Var i,j: integer;
begin
  sgField.ColCount := nCols;
  sgField.RowCount := nRows;

  for i:=0 to nCols-1 do
  for j:=0 to nRows-1 do
      begin
        sgField.Cells[i,j] := '';
        aMatrix[i,j].c := '';
        aMatrix[i,j].n := '';
      end;
end;

procedure TfMain.FormShow(Sender: TObject);
begin
  SetBtns('10001');
  lCheckingMode := True;
end;

procedure TfMain.bLoadClick(Sender: TObject);
var fFile: textfile;
    nCols,nRows,nNomer,nWords,nCol,nRow,i,j: integer;
    cWord: string;
begin
  if fdLoad.Execute then
     begin
       AssignFile(fFile,fdLoad.FileName);
       Reset(fFile);

       Readln(fFile,nCols,nRows);

       ClearField(nCols,nRows);

       // horizontal words

       Readln(fFile,nWords);

       for i:=1 to nWords do
           begin
             Readln(fFile,nNomer,nCol,nRow,cWord);

             cWord := Trim(cWord);

             for j:=0 to Length(cWord)-1 do
                 begin
                   sgField.Cells[nCol+j,nRow] := '';
                   aMatrix[nCol+j,nRow].c := cWord[j+1];
                 end;
             aMatrix[nCol,nRow].n := IntToStr(nNomer);
           end;

       // vertical words

       Readln(fFile,nWords);

       for i:=1 to nWords do
           begin
             Readln(fFile,nNomer,nCol,nRow,cWord);

             cWord := Trim(cWord);

             for j:=0 to Length(cWord)-1 do
                 begin
                   sgField.Cells[nCol,nRow+j] := '';
                   aMatrix[nCol,nRow+j].c := cWord[j+1];
                 end;
             aMatrix[nCol,nRow].n := IntToStr(nNomer);
           end;

       //questions

       lbQuestions.Clear;

       while not eof(fFile) do
             begin
               Readln(fFile,cWord);
               lbQuestions.Items.Add(cWord);
             end;

       CloseFile(fFile);

       lCheckingMode := true;

       sgField.Repaint;

       SetBtns('11001');

       StatusBar.Panels[0].Text := 'State: Waiting';
       StatusBar.Panels[1].Text := 'Attempts: 5';

       nAttempts := 5;
     end;
end;

procedure TfMain.bExitClick(Sender: TObject);
begin
 Close;
end;

procedure TfMain.sgFieldDrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var s: string[5];
begin
  if aMatrix[ACol,ARow].c = '' then
     begin
       sgField.Canvas.Brush.Color := clNavy;
       sgField.Canvas.FillRect(Rect);
     end
  else
     begin
       s := aMatrix[ACol,ARow].n;

       if s <> '' then s := s + ') ';

       s := s + sgField.Cells[ACol,ARow];

       if lCheckingMode and (aMatrix[ACol,ARow].c <> sgField.Cells[ACol,ARow])
          then
            begin
              sgField.Canvas.Font.Color := clRed;
              sgField.Canvas.Brush.Color := clYellow;
              sgField.Canvas.FillRect(Rect);
            end
          else
            begin
              sgField.Canvas.Font.Color := clGreen;
            end;

       sgField.Canvas.TextOut(Rect.Left+2,Rect.Top+2,s);
     end;
end;

procedure TfMain.bCheckClick(Sender: TObject);
begin
  sgField.SetFocus;

  if not lCheckingMode then
     begin
        if nAttempts <1 then
           begin
             MessageDlg('You have no more attempts to check!', mtError, [mbOK], 0);
             Exit;
           end
        else
           begin
             nAttempts := nAttempts - 1;
             StatusBar.Panels[1].Text := 'Attempts: '+IntToStr(nAttempts);
           end;
     end;

  lCheckingMode := not lCheckingMode;

  if lCheckingMode
     then
       begin
         bCheck.Caption := 'Continue';
         StatusBar.Panels[0].Text := 'State: Checking';
       end
     else
       begin
         bCheck.Caption := 'Check';
         StatusBar.Panels[0].Text := 'State: Solving';
       end;

  sgField.Repaint;   
end;

procedure TfMain.sgFieldKeyPress(Sender: TObject; var Key: Char);
begin
  if key <> #13 then
     begin
       if lCheckingMode
          then Key := #0
          else
             begin
               sgField.Cells[sgField.Col,sgField.Row] := Key;
               Key := #13;
             end;  
     end;

end;

procedure TfMain.bSolveClick(Sender: TObject);
begin
  SetBtns('00111');
  StatusBar.Panels[0].Text := 'State: Solving';
  lCheckingMode := false;
  sgField.Repaint;
  sgField.SetFocus;
end;

procedure TfMain.bFinishClick(Sender: TObject);
var i,j,nErrors: integer;
begin
  SetBtns('10001');
  StatusBar.Panels[0].Text := 'State: Game over';
  lCheckingMode := true;
  sgField.Repaint;

  nErrors := 0;

  for i:=0 to sgField.ColCount-1 do
  for j:=0 to sgField.RowCount-1 do
      begin
        If sgField.Cells[i,j] <> aMatrix[i,j].c
           then nErrors := nErrors + 1;
      end;

   if nErrors > 0 then
      MessageDlg('Oopsss... you have done '+IntToStr(nErrors)+' mistakes...try again...', mtError, [mbOK], 0)
   else
      MessageDlg('Bravissimo! You did it!!!', mtWarning, [mbOK], 0);

   StatusBar.Panels[0].Text := 'State: Waiting';
end;

end.
