unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, ExtCtrls, Spin, unit2, unit3;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Image2: TImage;
    StringGrid3: TStringGrid;
    StringGrid4: TStringGrid;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button3: TButton;
    Button28: TButton;
    Button11: TButton;
    Memo1: TMemo;
    DrawGrid1: TDrawGrid;
    DrawGrid2: TDrawGrid;
    Memo2: TMemo;
    Memo3: TMemo;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label9: TLabel;
    ComboBox1: TComboBox;
    SpinEdit1: TSpinEdit;
    Label10: TLabel;
    Button12: TButton;
    Button13: TButton;
    Splitter1: TSplitter;
    Splitter2: TSplitter;
    Splitter3: TSplitter;
    Splitter4: TSplitter;
    Button14: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Image2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button3Click(Sender: TObject);
    procedure Button28Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Training(Position: Integer);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure ComboBox1Select(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
  NumOfEtolons: integer;
      { Public declarations }
  end;

var
  Form1: TForm1;
  W: array [1..10,1..900] of real;
  W0: array [1..10] of real;
  X1: array [1..900] of integer;
  X2: array [1..900] of integer;
  X3: array [1..900] of integer;
  X4: array [1..900] of integer;
  X5: array [1..900] of integer;
  X6: array [1..900] of integer;
  X7: array [1..900] of integer;
  X8: array [1..900] of integer;
  X9: array [1..900] of integer;
  New: array [1..900] of integer;
  S: array [1..900] of integer;
  Sigma: array [1..10] of real;
  SSigma: array [1..10] of real;
  Y: array [1..10] of real;
  SY: array [1..10] of real;
  B: array [1..10] of real;
  D: array [1..10] of real;
  DeltaW: array [1..10,1..900] of real;
  DeltaW0: array [1..10] of real;
  alpha: real;
  Drawing: boolean;
  Iteration,NumOfTraining: integer;

implementation

{$R *.dfm}

procedure TForm1.Training(Position: Integer);
var
Mas: array [1..900] of integer;
i,j,k,index,f: integer;
flag: boolean;
R: TRect;
Label Next;
begin

 for i:=1 to 900 do
  begin
  Mas[i] := 0;
  end;

 for i:=1 to NumOfEtolons do
  begin
   Sigma[i] := 0;
  end;

 for i:=1 to NumOfEtolons do
  begin
  if (i = Position) then D[i] := 1
     else
     D[i] := 0;
  end;

 k:=1;
 for i:=1 to 30 do
  begin
   for j:=1 to 30 do
    begin
    if (Image1.Canvas.Pixels[j-1,i-1] = clWhite) then Mas[k] := 0
       else Mas[k] := 1;
       inc(k);
    end;
  end;

  for i:=0 to 29 do
  begin
   for j:=0 to 29 do
    begin
    if Image1.Canvas.Pixels[i,j] = clWhite then
       begin
       DrawGrid1.Canvas.Brush.Color := clAqua;
       R := DrawGrid1.CellRect(i,j);
       DrawGrid1.Canvas.Rectangle(R);
       end else
       begin
       DrawGrid1.Canvas.Brush.Color := clBlack;
       R := DrawGrid1.CellRect(i,j);
       DrawGrid1.Canvas.Rectangle(R);
       end;
    end;
  end;

  Memo2.Clear;
  k:=1;
   for i:=1 to 30 do
   begin
    if (i >= 7) and (i <= 22) then
    begin
    Memo2.Lines.Add(IntToStr(Mas[k])+IntToStr(Mas[k+1])+
    IntToStr(Mas[k+2])+IntToStr(Mas[k+3])+IntToStr(Mas[k+4])+
    IntToStr(Mas[k+5])+IntToStr(Mas[k+6])+IntToStr(Mas[k+7])+
    IntToStr(Mas[k+8])+IntToStr(Mas[k+9])+IntToStr(Mas[k+10])+
    IntToStr(Mas[k+11])+IntToStr(Mas[k+12])+IntToStr(Mas[k+13])+
    IntToStr(Mas[k+14])+IntToStr(Mas[k+15])+IntToStr(Mas[k+16])+
    IntToStr(Mas[k+17])+IntToStr(Mas[k+18])+IntToStr(Mas[k+19])+
    IntToStr(Mas[k+20])+IntToStr(Mas[k+21])+IntToStr(Mas[k+22])+
    IntToStr(Mas[k+23])+IntToStr(Mas[k+24])+IntToStr(Mas[k+25])+
    IntToStr(Mas[k+26])+IntToStr(Mas[k+27])+IntToStr(Mas[k+28])+
    IntToStr(Mas[k+29]));
    end;
    k:=k+30;
   end;

  f:=0; index:=1;
  for i:=1 to 900 do
   begin
    if (Mas[i] = 1) then inc(f);
    if (f >= 1) then
       begin
       Mas[index]:=Mas[i];
       Mas[i]:=0;
       inc(index);
       end;
   end;

  for i:=1 to NumOfEtolons do
   begin
    for j:=1 to 900 do
     begin
     Sigma[i] := Sigma[i] + (W[i,j]*Mas[j]);
     end;
   Sigma[i] := Sigma[i] + W0[i];
   end;

   for i:=1 to NumOfEtolons do
    begin
     if (Sigma[i] >=0) then Y[i] := 1
     else Y[i] := 0;
    end;

  flag:=true;
    for i:=1 to NumOfEtolons do
     begin
     if (D[i] <> Y[i]) then flag := false;
     end;

   if (flag = false) then
    begin

    Next:
    Inc(Iteration);

    for i:=1 to NumOfEtolons do
     begin
     Sigma[i] := 0;
     end;

    for i:=1 to NumOfEtolons do
     begin
     B[i] := D[i] - Y[i];
     end;

   for i:=1 to NumOfEtolons do
    begin
     for j:=1 to 900 do
      begin
      DeltaW[i,j] := alpha*B[i]*Mas[j];
      end;
     DeltaW0[i] := alpha*B[i];
    end;

   for i:=1 to NumOfEtolons do
    begin
     for j:=1 to 900 do
      begin
      W[i,j] := W[i,j] + DeltaW[i,j];
      end;
     W0[i] := W0[i] + DeltaW0[i];
    end;

  for i:=1 to NumOfEtolons do
   begin
    for j:=1 to 900 do
     begin
     Sigma[i] := Sigma[i] + (W[i,j]*Mas[j]);
     end;
     Sigma[i] := Sigma[i] + W0[i];
   end;

   for i:=1 to NumOfEtolons do
    begin
     if (Sigma[i] >= 0) then Y[i] := 1
     else Y[i] := 0;
    end;

    flag:=true;
    for i:=1 to NumOfEtolons do
     begin
     if (D[i] <> Y[i]) then flag := false;
     end;

   if (flag = false) then goto Next;

   end;

  for i:=1 to 900 do
   begin
    case Position of
    1: X1[i] := Mas[i];
    2: X2[i] := Mas[i];
    3: X3[i] := Mas[i];
    4: X4[i] := Mas[i];
    5: X5[i] := Mas[i];
    6: X6[i] := Mas[i];
    7: X7[i] := Mas[i];
    8: X8[i] := Mas[i];
    9: X9[i] := Mas[i];
   10: New[i] := Mas[i];
    end;
   end;

end;

procedure TForm1.FormCreate(Sender: TObject);
var
i,j: integer;
r: real;
begin

Image2.Picture.LoadFromFile('Empty.bmp');

Iteration:=1;

alpha := 0.2;
NumOfTraining := 3;
NumOfEtolons := 9;

StringGrid3.Cells[0,0] := 'O';
StringGrid3.Cells[1,0] := 'Q';
StringGrid3.Cells[2,0] := 'S';
StringGrid3.Cells[3,0] := 'L';
StringGrid3.Cells[4,0] := '5';
StringGrid3.Cells[5,0] := '4';
StringGrid3.Cells[6,0] := '3';
StringGrid3.Cells[7,0] := '+';
StringGrid3.Cells[8,0] := '&';

for i:=1 to 10 do
 begin
 StringGrid4.Cells[i-1,0] := 'W'+IntToStr(i)+',0';
 end;

for i:=1 to NumOfEtolons do
 begin
  for j:=1 to 900 do
   begin
   Randomize;
   r := Random(10)*0.01;
   if (Random(2) = 0) then r:=r;
   if (Random(2) = 1) then r:=r*(-1);
   W[i,j] := r;
   end;
   Randomize;
   r := Random(10)*0.01;
   r:=r*(-1);
   W0[i] := r;
 end;

end;

procedure TForm1.Button1Click(Sender: TObject);
var
i: integer;
begin

 Image1.Picture.LoadFromFile('O.bmp');
 Training(1);

    for i:=1 to NumOfEtolons do
     begin
     StringGrid4.Cells[i-1,1] := FloatToStr(W0[i]);
     end;

end;

procedure TForm1.Button2Click(Sender: TObject);
var
i: integer;
begin

 Image1.Picture.LoadFromFile('Q.bmp');
 Training(2);

    for i:=1 to NumOfEtolons do
     begin
     StringGrid4.Cells[i-1,1] := FloatToStr(W0[i]);
     end;

end;

procedure TForm1.Image2MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
X := Trunc(X/6.1);
Y := Trunc(Y/6.3);
if Drawing then
  begin
   case SpinEdit1.Value of
   1: Image2.Canvas.Pixels[X,Y] := clBlack;
   2:
   begin
   Image2.Canvas.Pixels[X,Y] := clBlack;
   Image2.Canvas.Pixels[X+1,Y+1] := clBlack;
   end;
   3:
   begin
   Image2.Canvas.Pixels[X,Y] := clBlack;
   Image2.Canvas.Pixels[X+1,Y+1] := clBlack;
   Image2.Canvas.Pixels[X+2,Y+2] := clBlack;
   end;
   4:
   begin
   Image2.Canvas.Pixels[X,Y] := clBlack;
   Image2.Canvas.Pixels[X+1,Y+1] := clBlack;
   Image2.Canvas.Pixels[X+2,Y+2] := clBlack;
   Image2.Canvas.Pixels[X+3,Y+3] := clBlack;
   end;
   end;
  end;
end;

procedure TForm1.Image2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Drawing := True;
end;

procedure TForm1.Image2MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Drawing := False;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
R: TRect;
i,j,k,index,f: integer;
begin

 for i:=1 to NumOfEtolons do
  begin
  SSigma[i] := 0;
  SY[i] := 0;
  end;

 for i:=1 to 900 do
  begin
  S[i] := 0;
  end;

 k:=1;
 for i:=1 to 30 do
  begin
   for j:=1 to 30 do
    begin
    if (Image2.Canvas.Pixels[j-1,i-1] = clWhite) then S[k] := 0
       else S[k] := 1;
       inc(k);
    end;
  end;

  for i:=0 to 29 do
  begin
   for j:=0 to 29 do
    begin
    if Image2.Canvas.Pixels[i,j] = clWhite then
       begin
       DrawGrid2.Canvas.Brush.Color := clAqua;
       R := DrawGrid2.CellRect(i,j);
       DrawGrid2.Canvas.Rectangle(R);
       end else
       begin
       DrawGrid2.Canvas.Brush.Color := clBlack;
       R := DrawGrid2.CellRect(i,j);
       DrawGrid2.Canvas.Rectangle(R);
       end;
    end;
  end;

  Memo3.Clear;
  k:=1;
   for i:=1 to 30 do
   begin
    Memo3.Lines.Add(IntToStr(S[k])+IntToStr(S[k+1])+
    IntToStr(S[k+2])+IntToStr(S[k+3])+IntToStr(S[k+4])+
    IntToStr(S[k+5])+IntToStr(S[k+6])+IntToStr(S[k+7])+
    IntToStr(S[k+8])+IntToStr(S[k+9])+IntToStr(S[k+10])+
    IntToStr(S[k+11])+IntToStr(S[k+12])+IntToStr(S[k+13])+
    IntToStr(S[k+14])+IntToStr(S[k+15])+IntToStr(S[k+16])+
    IntToStr(S[k+17])+IntToStr(S[k+18])+IntToStr(S[k+19])+
    IntToStr(S[k+20])+IntToStr(S[k+21])+IntToStr(S[k+22])+
    IntToStr(S[k+23])+IntToStr(S[k+24])+IntToStr(S[k+25])+
    IntToStr(S[k+26])+IntToStr(S[k+27])+IntToStr(S[k+28])+
    IntToStr(S[k+29]));
    k:=k+30;
   end;

  f:=0; index:=1;
  for i:=1 to 900 do
   begin
    if (S[i] = 1) then inc(f);
    if (f >= 1) then
       begin
       S[index]:=S[i];
       S[i]:=0;
       inc(index);
       end;
   end;

   for i:=1 to NumOfEtolons do
    begin
     for j:=1 to 900 do
      begin
      SSigma[i] := SSigma[i] + (W[i,j]*S[j]);
      end;
      SSigma[i] := SSigma[i] + W0[i];
    end;

   for i:=1 to NumOfEtolons do
    begin
     if (SSigma[i] >= 0) then SY[i] := 1
        else SY[i] := 0;
    end;

   index:=0;
   for i:=1 to NumOfEtolons do
    begin
    if (SY[i] = 1) then index := i;
    StringGrid3.Cells[i-1,1] := FloatToStr(SY[i]);
    end;

    if (index = 0) then
    begin
    ShowMessage(' !'+#13+'  !');
    end
    else
    begin
    Memo1.Clear;
    Memo1.Lines.Add(' : ' + StringGrid3.Cells[index-1,0]);
    Memo1.Lines.Add(' : ' + IntToStr(Iteration));
    end;

end;

procedure TForm1.Button28Click(Sender: TObject);
var
R: TRect;
i,j: integer;
begin
  Image2.Picture.LoadFromFile('Empty.bmp');
  Memo1.Clear;
  Memo3.Clear;
  for i:=1 to NumOfEtolons do
   begin
   StringGrid3.Cells[i-1,1] := IntToStr(0);
   end;
  for i:=0 to 29 do
   begin
    for j:=0 to 29 do
     begin
     DrawGrid2.Canvas.Brush.Color := clWhite;
     R := DrawGrid2.CellRect(i,j);
     DrawGrid2.Canvas.Rectangle(R);
     end;
   end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
i: integer;
begin
  Image1.Picture.LoadFromFile('S.bmp');
  Training(3);
  for i:=1 to NumOfEtolons do
     begin
     StringGrid4.Cells[i-1,1] := FloatToStr(W0[i]);
     end;
end;

procedure TForm1.Button5Click(Sender: TObject);
var
i: integer;
begin
  Image1.Picture.LoadFromFile('L.bmp');
  Training(4);
  for i:=1 to NumOfEtolons do
     begin
     StringGrid4.Cells[i-1,1] := FloatToStr(W0[i]);
     end;
end;

procedure TForm1.Button6Click(Sender: TObject);
var
i: integer;
begin
  Image1.Picture.LoadFromFile('5.bmp');
  Training(5);
  for i:=1 to NumOfEtolons do
     begin
     StringGrid4.Cells[i-1,1] := FloatToStr(W0[i]);
     end;
end;

procedure TForm1.Button7Click(Sender: TObject);
var
i: integer;
begin
  Image1.Picture.LoadFromFile('4.bmp');
  Training(6);
  for i:=1 to NumOfEtolons do
     begin
     StringGrid4.Cells[i-1,1] := FloatToStr(W0[i]);
     end;
end;

procedure TForm1.Button8Click(Sender: TObject);
var
i: integer;
begin
  Image1.Picture.LoadFromFile('3.bmp');
  Training(7);
  for i:=1 to NumOfEtolons do
     begin
     StringGrid4.Cells[i-1,1] := FloatToStr(W0[i]);
     end;
end;

procedure TForm1.Button9Click(Sender: TObject);
var
i: integer;
begin
  Image1.Picture.LoadFromFile('Plus.bmp');
  Training(8);
  for i:=1 to NumOfEtolons do
     begin
     StringGrid4.Cells[i-1,1] := FloatToStr(W0[i]);
     end;
end;

procedure TForm1.Button10Click(Sender: TObject);
var
i: integer;
begin
  Image1.Picture.LoadFromFile('Ampersant.bmp');
  Training(9);
  for i:=1 to NumOfEtolons do
     begin
     StringGrid4.Cells[i-1,1] := FloatToStr(W0[i]);
     end;
end;

procedure TForm1.Button11Click(Sender: TObject);
var
i,j: integer;
r: real;
Path: string;
begin

 if Form2.Apply or Form3.Apply then
  begin
  for i:=1 to NumOfEtolons do
  begin
   for j:=1 to 900 do
    begin
    Randomize;
    r := Random(10)*0.01;
    if (Random(2) = 0) then r:=r;
    if (Random(2) = 1) then r:=r*(-1);
    W[i,j] := r;
    end;
    Randomize;
    r := Random(10)*0.01;
    r:=r*(-1);
    W0[i] := r;
  end;
  Iteration := 1;
  end;

 for i:=1 to NumOfTraining do
  begin
  Button1.Click;
  Button2.Click;
  Button4.Click;
  Button5.Click;
  Button6.Click;
  Button7.Click;
  Button8.Click;
  Button9.Click;
  Button10.Click;
  if Form2.Apply then
    begin
    Path := Form2.Edit1.Text;
    Image1.Picture.LoadFromFile(Path+'.bmp');
    Training(10);
    for j:=1 to NumOfEtolons do
     begin
       StringGrid4.Cells[i-1,1] := FloatToStr(W0[i]);
     end;
    end;
  end;

end;

procedure TForm1.ComboBox1Select(Sender: TObject);
var
ind: integer;
i,j: integer;
r: real;
begin

for i:=1 to NumOfEtolons do
 begin
  for j:=1 to 900 do
   begin
   Randomize;
   r := Random(10)*0.01;
   if (Random(2) = 0) then r:=r;
   if (Random(2) = 1) then r:=r*(-1);
   W[i,j] := r;
   end;
   Randomize;
   r := Random(10)*0.01;
   r:=r*(-1);
   W0[i] := r;
 end;

 Iteration := 1;

ind := ComboBox1.ItemIndex;
 case ind of
  0: begin alpha := 0.2; NumOfTraining := 3; end;
  1: begin alpha := 0.7; NumOfTraining := 6; end;
 end;

end;

procedure TForm1.Button13Click(Sender: TObject);
begin
  Form2.ShowModal;
end;

procedure TForm1.Button12Click(Sender: TObject);
begin
  Form3.ShowModal;
end;

procedure TForm1.Button14Click(Sender: TObject);
begin
  Form1.Close;
end;

procedure TForm1.FormPaint(Sender: TObject);
var
i,j: integer;
R: TRect;
begin

  for i:=0 to 29 do
  begin
   for j:=0 to 29 do
    begin
    if Image1.Canvas.Pixels[i,j] = clWhite then
       begin
       DrawGrid1.Canvas.Brush.Color := clAqua;
       R := DrawGrid1.CellRect(i,j);
       DrawGrid1.Canvas.Rectangle(R);
       end else
       begin
       DrawGrid1.Canvas.Brush.Color := clBlack;
       R := DrawGrid1.CellRect(i,j);
       DrawGrid1.Canvas.Rectangle(R);
       end;
    end;
  end;

  for i:=0 to 29 do
  begin
   for j:=0 to 29 do
    begin
    if Image2.Canvas.Pixels[i,j] = clWhite then
       begin
       DrawGrid2.Canvas.Brush.Color := clAqua;
       R := DrawGrid2.CellRect(i,j);
       DrawGrid2.Canvas.Rectangle(R);
       end else
       begin
       DrawGrid2.Canvas.Brush.Color := clBlack;
       R := DrawGrid2.CellRect(i,j);
       DrawGrid2.Canvas.Rectangle(R);
       end;
    end;
  end;

end;

end.
