unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Spin;

type
  TForm3 = class(TForm)
    Image1: TImage;
    Label1: TLabel;
    SpinEdit1: TSpinEdit;
    Label2: TLabel;
    Button1: TButton;
    Edit1: TEdit;
    Label3: TLabel;
    Button2: TButton;
    ComboBox1: TComboBox;
    Label4: TLabel;
    Splitter1: TSplitter;
    Splitter2: TSplitter;
    Splitter3: TSplitter;
    Splitter4: TSplitter;
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ComboBox1Select(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
  Apply: boolean;
    { Public declarations }
  end;

var
  Form3: TForm3;
  Drawing, Eraser: boolean;
  PathToFile: string;
  index: integer;

implementation

uses unit1;

{$R *.dfm}

procedure TForm3.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Drawing := True;
end;

procedure TForm3.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
Color: TColor;
begin
Color := clBlack;
X := Trunc(X/6.1);
Y := Trunc(Y/6.3);
if Eraser then Color := clWhite;
if Drawing then
  begin
   case SpinEdit1.Value of
   1: Image1.Canvas.Pixels[X,Y] := Color;
   2:
   begin
   Image1.Canvas.Pixels[X,Y] := Color;
   Image1.Canvas.Pixels[X+1,Y+1] := Color;
   end;
   3:
   begin
   Image1.Canvas.Pixels[X,Y] := Color;
   Image1.Canvas.Pixels[X+1,Y+1] := Color;
   Image1.Canvas.Pixels[X+2,Y+2] := Color;
   end;
   4:
   begin
   Image1.Canvas.Pixels[X,Y] := Color;
   Image1.Canvas.Pixels[X+1,Y+1] := Color;
   Image1.Canvas.Pixels[X+2,Y+2] := Color;
   Image1.Canvas.Pixels[X+3,Y+3] := Color;
   end;
   end;
  end;
end;

procedure TForm3.Image1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Drawing := False;
end;

procedure TForm3.Button1Click(Sender: TObject);
begin
  if (Button1.Caption <> ' ') then
  begin
    Eraser := True;
    Button1.Caption := ' ';
  end else
  begin
    Eraser := False;
    Button1.Caption := '';
  end;
end;

procedure TForm3.FormActivate(Sender: TObject);
var
i: integer;
s: string;
begin
   Apply := False;
   ComboBox1.Text := ' --------------------------------------';
   for i:=0 to Form1.NumOfEtolons-1 do
    begin
    s := Form1.StringGrid3.Cells[i,0];
    ComboBox1.Items.Insert(i,s);
    end;
end;

procedure TForm3.ComboBox1Select(Sender: TObject);
begin
  PathToFile := '';
  index := ComboBox1.ItemIndex;
   case index of
     7: PathToFile := 'Plus.bmp';
     8: PathToFile := 'Ampersant.bmp';
     else PathToFile := ComboBox1.Items.Strings[index]+'.bmp';
     end;
  Image1.Picture.LoadFromFile(PathToFile);
end;

procedure TForm3.Button2Click(Sender: TObject);
begin
  if (Edit1.Text <> '') then
  begin
  Image1.Picture.SaveToFile(PathToFile);
  Apply := True;
  Form1.StringGrid3.Cells[index,0] := Edit1.Text;
  Image1.Picture.LoadFromFile('Empty.bmp');
  Form3.Close;
  end
  else ShowMessage('      !');
end;

end.
