unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, ExtCtrls;

type
  TForm2 = class(TForm)
    Image1: TImage;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    Splitter1: TSplitter;
    Splitter2: TSplitter;
    Splitter3: TSplitter;
    Splitter4: TSplitter;
    Button2: TButton;
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
  Apply: boolean;
    { Public declarations }
  end;

var
  Form2: TForm2;
  Drawing, Eraser: boolean;

implementation

uses unit1;

{$R *.dfm}

procedure TForm2.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Drawing := True;
end;

procedure TForm2.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
Color: TColor;
begin
Color := clBlack;
X := Trunc(X/6.1);
Y := Trunc(Y/6.3);
if Eraser then Color := clWhite;
if Drawing then
  begin
   case SpinEdit1.Value of
   1: Image1.Canvas.Pixels[X,Y] := Color;
   2:
   begin
   Image1.Canvas.Pixels[X,Y] := Color;
   Image1.Canvas.Pixels[X+1,Y+1] := Color;
   end;
   3:
   begin
   Image1.Canvas.Pixels[X,Y] := Color;
   Image1.Canvas.Pixels[X+1,Y+1] := Color;
   Image1.Canvas.Pixels[X+2,Y+2] := Color;
   end;
   4:
   begin
   Image1.Canvas.Pixels[X,Y] := Color;
   Image1.Canvas.Pixels[X+1,Y+1] := Color;
   Image1.Canvas.Pixels[X+2,Y+2] := Color;
   Image1.Canvas.Pixels[X+3,Y+3] := Color;
   end;
   end;
  end;
end;

procedure TForm2.Image1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Drawing := False;
end;

procedure TForm2.Button2Click(Sender: TObject);
begin
  if (Button2.Caption <> ' ') then
  begin
    Eraser := True;
    Button2.Caption := ' ';
  end else
  begin
    Eraser := False;
    Button2.Caption := '';
  end;
end;

procedure TForm2.Button1Click(Sender: TObject);
begin
  if (Edit1.Text = '')
     then ShowMessage('      !')
     else
     begin
     Form1.NumOfEtolons := 10;
     Form1.StringGrid3.Cells[9,0] := Edit1.Text;
     Image1.Picture.SaveToFile(Edit1.Text+'.bmp');
     Image1.Picture.LoadFromFile('Empty.bmp');
     Apply := True;
     Form2.Close;
     end;
end;

procedure TForm2.FormActivate(Sender: TObject);
begin
  Apply := False;
end;

end.
