unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Timer1: TTimer;
    CheckBox1: TCheckBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
    Rct: TRect;
    Bitmap: TBitmap;
  public
    { Public declarations }
  end;

const
 speed=10;

var
 Form1: TForm1;
 x: integer = 0;
 dx: integer;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
 doublebuffered:=true;
 Bitmap := TBitmap.Create;
 Bitmap.LoadFromFile('panoramb.bmp');
 Rct := Rect(0,0,ClientWidth-1,Bitmap.Height-1);
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
 Canvas.CopyRect(Rct,Bitmap.Canvas,rect(x,0,Rct.Right+x,Rct.Bottom));
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Bitmap.Free;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
 x:=x+dx;

 If (x < 0) or (x > Bitmap.Width - ClientWidth) then
    begin
      Timer1.Enabled := false;
      dx := 0;
      Button2.Enabled := false;

      If x < 0 then
        begin
          x := 0;
          Button3.Enabled:=false;
        end
      else
        begin
          x := Bitmap.Width - ClientWidth;
          Button1.Enabled:=false;
        end
    end;

 If RadioButton1.Checked
    then Repaint
    else InvalidateRect(Handle,@Rct,false);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 dx := speed;
 Timer1.enabled := true;
 Button1.Enabled := false;
 Button2.Enabled := true;
 Button3.Enabled := true;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 Timer1.Enabled := false;
 Button1.Enabled := true;
 Button2.Enabled := false;
 Button3.Enabled := true;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 dx := -speed;
 Timer1.enabled := true;
 Button1.Enabled := true;
 Button2.Enabled := true;
 Button3.Enabled := false;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
 DoubleBuffered := CheckBox1.Checked;
end;

end.
