﻿unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  PFileNotifyInformation = ^TFileNotifyInformation;
  TFileNotifyInformation =
  record
    NextEntryOffset: DWORD;
    Action: DWORD;
    FileNameLength: DWORD;
    FileName: array [0..MAX_PATH - 1] of WideChar;
  end;

const
  CheckPath = 'F:\Tst\';
  Filter =
    FILE_NOTIFY_CHANGE_FILE_NAME or
    FILE_NOTIFY_CHANGE_DIR_NAME or
    FILE_NOTIFY_CHANGE_ATTRIBUTES or
    FILE_NOTIFY_CHANGE_SIZE or
    FILE_NOTIFY_CHANGE_CREATION or
    FILE_NOTIFY_CHANGE_SECURITY;

var
  Form1: TForm1;
  hThread:THandle;

implementation

{$R *.dfm}

procedure WorkThread(myMemo: TMemo); stdcall;
const
  BUFFER = 2048;
var
  hDir : THandle;
  lpBuf : Pointer;
  Ptr   : Pointer;
  cbReturn : Cardinal;
  FileName : PWideChar;
  sTime : _SYSTEMTIME;
  sAction, st: string;
begin
  hDir := CreateFile(CheckPath, GENERIC_READ,
    FILE_SHARE_READ or FILE_SHARE_WRITE or FILE_SHARE_DELETE,
    nil, OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);

  if hDir = INVALID_HANDLE_VALUE then
  begin
    ShowMessage(SysErrorMessage(GetLastError));
    Exit;
  end;

  GetMem(lpBuf, BUFFER);
  repeat
    ZeroMemory(lpBuf, BUFFER);
    if not ReadDirectoryChangesW(hDir, lpBuf, BUFFER, true, Filter, @cbReturn, nil, nil) then Break;
    Ptr := lpBuf;
    repeat
      GetMem(FileName, PFileNotifyInformation(Ptr).FileNameLength + 2);
      ZeroMemory(FileName, PFileNotifyInformation(Ptr).FileNameLength + 2);
      lstrcpynW(FileName, PFileNotifyInformation(Ptr).FileName,
                (PFileNotifyInformation(Ptr).FileNameLength div 2) + 1);

      st := FileName;
      FreeMem(FileName);
      case PFileNotifyInformation(Ptr).Action of
        FILE_ACTION_ADDED            : sAction := '(создан) ';
        FILE_ACTION_REMOVED          : sAction := '(удален) ';
        FILE_ACTION_MODIFIED         : sAction := '(изменен) ';
        FILE_ACTION_RENAMED_OLD_NAME : sAction := ' с ';
        FILE_ACTION_RENAMED_NEW_NAME : sAction := ' на ';
      end;

      GetLocalTime(sTime);
      with sTime do
        st := Format('(%.2d:%.2d:%.2d)',[wHour, wMinute, wSecond]) +
              ' ' + sAction + ' ' + st;
      myMemo.Lines.Add(st);

      if PFileNotifyInformation(Ptr).NextEntryOffset = 0 then Break
      else
        Inc(Cardinal(Ptr), PFileNotifyInformation(Ptr).NextEntryOffset);
    until False;
  until False;
  FreeMem(lpBuf);
end;

procedure TForm1.Button1Click(Sender: TObject);
var myThread: Cardinal;
begin
  hThread := CreateThread(nil, 0, @WorkThread, Memo1, 0, myThread);
  if hThread = 0 then
  begin
    ShowMessage(SysErrorMessage(GetLastError));
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  TerminateThread(hThread, Cardinal(-1));
end;

end.
